/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResLdapTreeTable;

public class LdapTree
extends TResLdapTreeTable {
    public static LdapTreeCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new LdapTreeCursor(con, htWhereClause, columns);
    }

    public LdapTree() {
        this.clear();
    }

    public LdapTree(int TreeId, String Name2, int ComputerId) {
        this.clear();
        this.m_TreeId = TreeId;
        this.m_Name = Name2;
        this.m_ComputerId = ComputerId;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_TreeId != Integer.MIN_VALUE) {
            htColsAndValues.put(LdapTree.getColumnInfo("TREE_ID"), String.valueOf(this.m_TreeId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(LdapTree.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(LdapTree.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_LDAP_TREE", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_RES_LDAP_TREE", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_LDAP_TREE", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_LDAP_TREE", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_LDAP_TREE", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_LDAP_TREE", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_LDAP_TREE", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LdapTree retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        LdapTree el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_LDAP_TREE", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new LdapTree();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_LDAP_TREE", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_LDAP_TREE", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setTreeId(DBrs.getInt("TREE_ID"));
        this.setName(DBrs.getString("NAME"));
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
    }

    public static class LdapTreeCursor
    extends DBCursor {
        private LdapTree element = new LdapTree();
        private DBConnection con;

        public LdapTreeCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_LDAP_TREE", con, htWhereClause, columns);
            this.con = con;
        }

        public LdapTree getObject() throws SQLException {
            LdapTree el = null;
            if (this.DBrs != null) {
                el = new LdapTree();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public LdapTree getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

