/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResLparTable;

public class Lpar
extends TResLparTable {
    public static LparCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new LparCursor(con, htWhereClause, columns);
    }

    public Lpar() {
        this.clear();
    }

    public Lpar(int LparId, int RedundancyId, int VirtualMemory, int NumIoSlots, int NumProcs, int SubsystemId, int StorageFacilityId, Timestamp UpdateTimestamp) {
        this.clear();
        this.m_LparId = LparId;
        this.m_RedundancyId = RedundancyId;
        this.m_VirtualMemory = VirtualMemory;
        this.m_NumIoSlots = NumIoSlots;
        this.m_NumProcs = NumProcs;
        this.m_SubsystemId = SubsystemId;
        this.m_StorageFacilityId = StorageFacilityId;
        this.m_UpdateTimestamp = UpdateTimestamp;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_RedundancyId != Integer.MIN_VALUE) {
            htColsAndValues.put(Lpar.getColumnInfo("REDUNDANCY_ID"), String.valueOf(this.m_RedundancyId));
        }
        if (this.m_VirtualMemory != Integer.MIN_VALUE) {
            htColsAndValues.put(Lpar.getColumnInfo("VIRTUAL_MEMORY"), String.valueOf(this.m_VirtualMemory));
        }
        if (this.m_NumIoSlots != Integer.MIN_VALUE) {
            htColsAndValues.put(Lpar.getColumnInfo("NUM_IO_SLOTS"), String.valueOf(this.m_NumIoSlots));
        }
        if (this.m_NumProcs != Integer.MIN_VALUE) {
            htColsAndValues.put(Lpar.getColumnInfo("NUM_PROCS"), String.valueOf(this.m_NumProcs));
        }
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(Lpar.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
        if (this.m_StorageFacilityId != Integer.MIN_VALUE) {
            htColsAndValues.put(Lpar.getColumnInfo("STORAGE_FACILITY_ID"), String.valueOf(this.m_StorageFacilityId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Lpar.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_LparId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key LPAR_ID not found");
        }
        this.htColsAndValues.put(Lpar.getColumnInfo("LPAR_ID"), String.valueOf(this.m_LparId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_LPAR", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Lpar.getColumnInfo("LPAR_ID")) == null) {
            throw new SQLException(" ERROR: key LPAR_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_LPAR", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_LparId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key LPAR_ID not found");
        }
        this.htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), String.valueOf(this.m_LparId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_LPAR", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Lpar.getColumnInfo("LPAR_ID")) == null) {
            throw new SQLException(" ERROR: key LPAR_ID not found");
        }
        this.htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), htinput.get(Lpar.getColumnInfo("LPAR_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_LPAR", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_LparId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key LPAR_ID not found");
        }
        this.htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), String.valueOf(this.m_LparId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_LPAR", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Lpar.getColumnInfo("LPAR_ID")) == null) {
            throw new SQLException(" ERROR: key LPAR_ID not found");
        }
        this.htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), htinput.get(Lpar.getColumnInfo("LPAR_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_LPAR", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_LparId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key LPAR_ID not found");
        }
        this.htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), String.valueOf(this.m_LparId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_LPAR", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lpar retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Lpar el = null;
        if (htinput.get(Lpar.getColumnInfo("LPAR_ID")) == null) {
            throw new SQLException(" ERROR: key LPAR_ID not found");
        }
        htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), htinput.get(Lpar.getColumnInfo("LPAR_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_LPAR", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Lpar();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_LPAR", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_LPAR", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setLparId(DBrs.getInt("LPAR_ID"));
        this.setRedundancyId(DBrs.getInt("REDUNDANCY_ID"));
        this.setVirtualMemory(DBrs.getInt("VIRTUAL_MEMORY"));
        this.setNumIoSlots(DBrs.getInt("NUM_IO_SLOTS"));
        this.setNumProcs(DBrs.getInt("NUM_PROCS"));
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setStorageFacilityId(DBrs.getInt("STORAGE_FACILITY_ID"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class LparCursor
    extends DBCursor {
        private Lpar element = new Lpar();
        private DBConnection con;

        public LparCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_LPAR", con, htWhereClause, columns);
            this.con = con;
        }

        public Lpar getObject() throws SQLException {
            Lpar el = null;
            if (this.DBrs != null) {
                el = new Lpar();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Lpar getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

