/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResModelSnapshotTable;

public class ModelSnapshot
extends TResModelSnapshotTable {
    private String m_ModelId_str;

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static ModelSnapshotCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ModelSnapshotCursor(con, htWhereClause, columns);
    }

    public ModelSnapshot() {
        this.clear();
    }

    public ModelSnapshot(int SnapshotId, short ModelId, String ModelName, String ModelDescription) {
        this.clear();
        this.m_SnapshotId = SnapshotId;
        this.m_ModelId = ModelId;
        this.m_ModelName = ModelName;
        this.m_ModelDescription = ModelDescription;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_ModelDescription != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ModelSnapshot.getColumnInfo("MODEL_DESCRIPTION"), this.m_ModelDescription);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htColsAndValues.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_MODEL_SNAPSHOT", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(ModelSnapshot.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        if (htinput.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_MODEL_SNAPSHOT", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL_SNAPSHOT", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(ModelSnapshot.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), htinput.get(ModelSnapshot.getColumnInfo("MODEL_NAME")));
        if (htinput.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL_SNAPSHOT", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL_SNAPSHOT", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(ModelSnapshot.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), htinput.get(ModelSnapshot.getColumnInfo("MODEL_NAME")));
        if (htinput.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL_SNAPSHOT", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_MODEL_SNAPSHOT", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelSnapshot retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        ModelSnapshot el = null;
        if (htinput.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(ModelSnapshot.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), htinput.get(ModelSnapshot.getColumnInfo("MODEL_NAME")));
        if (htinput.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), htinput.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_MODEL_SNAPSHOT", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new ModelSnapshot();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL_SNAPSHOT", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL_SNAPSHOT", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSnapshotId(DBrs.getInt("SNAPSHOT_ID"));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setModelName(DBrs.getString("MODEL_NAME"));
        this.setModelDescription(DBrs.getString("MODEL_DESCRIPTION"));
    }

    public static class ModelSnapshotCursor
    extends DBCursor {
        private ModelSnapshot element = new ModelSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResModelSnapshotTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TResModelSnapshotTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TResModelSnapshotTable.getColumnInfo("MODEL_ID")))));
            }
            return htWhereClause;
        }

        public ModelSnapshotCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_MODEL_SNAPSHOT", con, ModelSnapshotCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public ModelSnapshot getObject() throws SQLException {
            ModelSnapshot el = null;
            if (this.DBrs != null) {
                el = new ModelSnapshot();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public ModelSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

