/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatPingHistTable;

public class PingHist
extends TStatPingHistTable {
    public static PingHistCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new PingHistCursor(con, htWhereClause, columns);
    }

    public PingHist() {
        this.clear();
    }

    public PingHist(int ComputerId, String StatisticType, Timestamp MonitorStart, Timestamp MonitorEnd, int Transmitted, int Received, int Damaged, int MinTransitTime, int MaxTransitTime, double AvgTransitTime) {
        this.clear();
        this.m_ComputerId = ComputerId;
        this.m_StatisticType = StatisticType;
        this.m_MonitorStart = MonitorStart;
        this.m_MonitorEnd = MonitorEnd;
        this.m_Transmitted = Transmitted;
        this.m_Received = Received;
        this.m_Damaged = Damaged;
        this.m_MinTransitTime = MinTransitTime;
        this.m_MaxTransitTime = MaxTransitTime;
        this.m_AvgTransitTime = AvgTransitTime;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(PingHist.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_StatisticType != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(PingHist.getColumnInfo("STATISTIC_TYPE"), this.m_StatisticType);
        }
        if (this.m_MonitorStart != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(PingHist.getColumnInfo("MONITOR_START"), this.m_MonitorStart);
        }
        if (this.m_MonitorEnd != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(PingHist.getColumnInfo("MONITOR_END"), this.m_MonitorEnd);
        }
        if (this.m_Transmitted != Integer.MIN_VALUE) {
            htColsAndValues.put(PingHist.getColumnInfo("TRANSMITTED"), String.valueOf(this.m_Transmitted));
        }
        if (this.m_Received != Integer.MIN_VALUE) {
            htColsAndValues.put(PingHist.getColumnInfo("RECEIVED"), String.valueOf(this.m_Received));
        }
        if (this.m_Damaged != Integer.MIN_VALUE) {
            htColsAndValues.put(PingHist.getColumnInfo("DAMAGED"), String.valueOf(this.m_Damaged));
        }
        if (this.m_MinTransitTime != Integer.MIN_VALUE) {
            htColsAndValues.put(PingHist.getColumnInfo("MIN_TRANSIT_TIME"), String.valueOf(this.m_MinTransitTime));
        }
        if (this.m_MaxTransitTime != Integer.MIN_VALUE) {
            htColsAndValues.put(PingHist.getColumnInfo("MAX_TRANSIT_TIME"), String.valueOf(this.m_MaxTransitTime));
        }
        if (this.m_AvgTransitTime != Double.MIN_VALUE) {
            htColsAndValues.put(PingHist.getColumnInfo("AVG_TRANSIT_TIME"), String.valueOf(this.m_AvgTransitTime));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_PING_HIST", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_PING_HIST", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_PING_HIST", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_PING_HIST", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_PING_HIST", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_PING_HIST", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_PING_HIST", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PingHist retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        PingHist el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_PING_HIST", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new PingHist();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_PING_HIST", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_PING_HIST", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setStatisticType(DBrs.getString("STATISTIC_TYPE"));
        this.setMonitorStart(DBrs.getTimestamp("MONITOR_START"));
        this.setMonitorEnd(DBrs.getTimestamp("MONITOR_END"));
        this.setTransmitted(DBrs.getInt("TRANSMITTED"));
        this.setReceived(DBrs.getInt("RECEIVED"));
        this.setDamaged(DBrs.getInt("DAMAGED"));
        this.setMinTransitTime(DBrs.getInt("MIN_TRANSIT_TIME"));
        this.setMaxTransitTime(DBrs.getInt("MAX_TRANSIT_TIME"));
        this.setAvgTransitTime(DBrs.getDouble("AVG_TRANSIT_TIME"));
    }

    public static class PingHistCursor
    extends DBCursor {
        private PingHist element = new PingHist();
        private DBConnection con;

        public PingHistCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_STAT_PING_HIST", con, htWhereClause, columns);
            this.con = con;
        }

        public PingHist getObject() throws SQLException {
            PingHist el = null;
            if (this.DBrs != null) {
                el = new PingHist();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public PingHist getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

