/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResServerTable;

public class Server
extends TResServerTable {
    public static ServerCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ServerCursor(con, htWhereClause, columns);
    }

    public Server() {
        this.clear();
    }

    public Server(int ServerId, String ServerName, double ServerToken, int ComputerId, int PortNumber, int ServerType, String Password) {
        this.clear();
        this.m_ServerId = ServerId;
        this.m_ServerName = ServerName;
        this.m_ServerToken = ServerToken;
        this.m_ComputerId = ComputerId;
        this.m_PortNumber = PortNumber;
        this.m_ServerType = ServerType;
        this.m_Password = Password;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ServerName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Server.getColumnInfo("SERVER_NAME"), this.m_ServerName);
        }
        if (this.m_ServerToken != Double.MIN_VALUE) {
            htColsAndValues.put(Server.getColumnInfo("SERVER_TOKEN"), String.valueOf(this.m_ServerToken));
        }
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(Server.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_PortNumber != Integer.MIN_VALUE) {
            htColsAndValues.put(Server.getColumnInfo("PORT_NUMBER"), String.valueOf(this.m_PortNumber));
        }
        if (this.m_ServerType != Integer.MIN_VALUE) {
            htColsAndValues.put(Server.getColumnInfo("SERVER_TYPE"), String.valueOf(this.m_ServerType));
        }
        if (this.m_Password != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Server.getColumnInfo("PASSWORD"), this.m_Password);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ServerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SERVER_ID not found");
        }
        this.htColsAndValues.put(Server.getColumnInfo("SERVER_ID"), String.valueOf(this.m_ServerId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SERVER", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Server.getColumnInfo("SERVER_ID")) == null) {
            throw new SQLException(" ERROR: key SERVER_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SERVER", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ServerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SERVER_ID not found");
        }
        this.htWhereClause.put(Server.getColumnInfo("SERVER_ID"), String.valueOf(this.m_ServerId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SERVER", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Server.getColumnInfo("SERVER_ID")) == null) {
            throw new SQLException(" ERROR: key SERVER_ID not found");
        }
        this.htWhereClause.put(Server.getColumnInfo("SERVER_ID"), htinput.get(Server.getColumnInfo("SERVER_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SERVER", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ServerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SERVER_ID not found");
        }
        this.htWhereClause.put(Server.getColumnInfo("SERVER_ID"), String.valueOf(this.m_ServerId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SERVER", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Server.getColumnInfo("SERVER_ID")) == null) {
            throw new SQLException(" ERROR: key SERVER_ID not found");
        }
        this.htWhereClause.put(Server.getColumnInfo("SERVER_ID"), htinput.get(Server.getColumnInfo("SERVER_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SERVER", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ServerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SERVER_ID not found");
        }
        this.htWhereClause.put(Server.getColumnInfo("SERVER_ID"), String.valueOf(this.m_ServerId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SERVER", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Server el = null;
        if (htinput.get(Server.getColumnInfo("SERVER_ID")) == null) {
            throw new SQLException(" ERROR: key SERVER_ID not found");
        }
        htWhereClause.put(Server.getColumnInfo("SERVER_ID"), htinput.get(Server.getColumnInfo("SERVER_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SERVER", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Server();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_SERVER", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_SERVER", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setServerId(DBrs.getInt("SERVER_ID"));
        this.setServerName(DBrs.getString("SERVER_NAME"));
        this.setServerToken(DBrs.getDouble("SERVER_TOKEN"));
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setPortNumber(DBrs.getInt("PORT_NUMBER"));
        this.setServerType(DBrs.getInt("SERVER_TYPE"));
        this.setPassword(DBrs.getString("PASSWORD"));
    }

    public static class ServerCursor
    extends DBCursor {
        private Server element = new Server();
        private DBConnection con;

        public ServerCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_SERVER", con, htWhereClause, columns);
            this.con = con;
        }

        public Server getObject() throws SQLException {
            Server el = null;
            if (this.DBrs != null) {
                el = new Server();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Server getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

