/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TViewSsAggrinfoTable;

public class SsAggrinfo
extends TViewSsAggrinfoTable {
    public static SsAggrinfoCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new SsAggrinfoCursor(con, htWhereClause, columns);
    }

    public SsAggrinfo() {
        this.clear();
    }

    public SsAggrinfo(int SubsystemId, int NDisks, double DiskCapacity, int NLuns, long Overhead, long LgldiskAssignedCapacity, long LunCapacityZos, long LunCapacity, double DiskFreespace) {
        this.clear();
        this.m_SubsystemId = SubsystemId;
        this.m_NDisks = NDisks;
        this.m_DiskCapacity = DiskCapacity;
        this.m_NLuns = NLuns;
        this.m_Overhead = Overhead;
        this.m_LgldiskAssignedCapacity = LgldiskAssignedCapacity;
        this.m_LunCapacityZos = LunCapacityZos;
        this.m_LunCapacity = LunCapacity;
        this.m_DiskFreespace = DiskFreespace;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            htColsAndValues.put(SsAggrinfo.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
        if (this.m_NDisks != Integer.MIN_VALUE) {
            htColsAndValues.put(SsAggrinfo.getColumnInfo("N_DISKS"), String.valueOf(this.m_NDisks));
        }
        if (this.m_DiskCapacity != Double.MIN_VALUE) {
            htColsAndValues.put(SsAggrinfo.getColumnInfo("DISK_CAPACITY"), String.valueOf(this.m_DiskCapacity));
        }
        if (this.m_NLuns != Integer.MIN_VALUE) {
            htColsAndValues.put(SsAggrinfo.getColumnInfo("N_LUNS"), String.valueOf(this.m_NLuns));
        }
        if (this.m_Overhead != Long.MIN_VALUE) {
            htColsAndValues.put(SsAggrinfo.getColumnInfo("OVERHEAD"), String.valueOf(this.m_Overhead));
        }
        if (this.m_LgldiskAssignedCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(SsAggrinfo.getColumnInfo("LGLDISK_ASSIGNED_CAPACITY"), String.valueOf(this.m_LgldiskAssignedCapacity));
        }
        if (this.m_LunCapacityZos != Long.MIN_VALUE) {
            htColsAndValues.put(SsAggrinfo.getColumnInfo("LUN_CAPACITY_ZOS"), String.valueOf(this.m_LunCapacityZos));
        }
        if (this.m_LunCapacity != Long.MIN_VALUE) {
            htColsAndValues.put(SsAggrinfo.getColumnInfo("LUN_CAPACITY"), String.valueOf(this.m_LunCapacity));
        }
        if (this.m_DiskFreespace != Double.MIN_VALUE) {
            htColsAndValues.put(SsAggrinfo.getColumnInfo("DISK_FREESPACE"), String.valueOf(this.m_DiskFreespace));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_VIEW_SS_AGGRINFO", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_VIEW_SS_AGGRINFO", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_SS_AGGRINFO", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_SS_AGGRINFO", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_SS_AGGRINFO", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_SS_AGGRINFO", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_SS_AGGRINFO", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SsAggrinfo retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        SsAggrinfo el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_SS_AGGRINFO", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new SsAggrinfo();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_SS_AGGRINFO", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_VIEW_SS_AGGRINFO", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSubsystemId(DBrs.getInt("SUBSYSTEM_ID"));
        this.setNDisks(DBrs.getInt("N_DISKS"));
        this.setDiskCapacity(DBrs.getDouble("DISK_CAPACITY"));
        this.setNLuns(DBrs.getInt("N_LUNS"));
        this.setOverhead(DBrs.getLong("OVERHEAD"));
        this.setLgldiskAssignedCapacity(DBrs.getLong("LGLDISK_ASSIGNED_CAPACITY"));
        this.setLunCapacityZos(DBrs.getLong("LUN_CAPACITY_ZOS"));
        this.setLunCapacity(DBrs.getLong("LUN_CAPACITY"));
        this.setDiskFreespace(DBrs.getDouble("DISK_FREESPACE"));
    }

    public static class SsAggrinfoCursor
    extends DBCursor {
        private SsAggrinfo element = new SsAggrinfo();
        private DBConnection con;

        public SsAggrinfoCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_VIEW_SS_AGGRINFO", con, htWhereClause, columns);
            this.con = con;
        }

        public SsAggrinfo getObject() throws SQLException {
            SsAggrinfo el = null;
            if (this.DBrs != null) {
                el = new SsAggrinfo();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public SsAggrinfo getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

