/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatComputerTable;

public class StatComputer
extends TStatComputerTable {
    public static StatComputerCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new StatComputerCursor(con, htWhereClause, columns);
    }

    public StatComputer() {
        this.clear();
    }

    public StatComputer(int ComputerId, int DomainId, int GroupId, String Manufacturer, String Model2, String SerialNumber, short OsType, String OsVersion, String ProcessorType, short ProcessorCount, short ProcessorSpeed, int Ram, int SwapSpace, double DiskCapacity, double FsFreeSpace, double DiskFreeSpace, Timestamp LastBootTime, String ProbeStatus, Timestamp LastProbeTime, double OwnedDiskCap, double OwnedDiskFreeSp, int ClusterId, int NodeHostedId, short CpuArchitecture) {
        this.clear();
        this.m_ComputerId = ComputerId;
        this.m_DomainId = DomainId;
        this.m_GroupId = GroupId;
        this.m_Manufacturer = Manufacturer;
        this.m_Model = Model2;
        this.m_SerialNumber = SerialNumber;
        this.m_OsType = OsType;
        this.m_OsVersion = OsVersion;
        this.m_ProcessorType = ProcessorType;
        this.m_ProcessorCount = ProcessorCount;
        this.m_ProcessorSpeed = ProcessorSpeed;
        this.m_Ram = Ram;
        this.m_SwapSpace = SwapSpace;
        this.m_DiskCapacity = DiskCapacity;
        this.m_FsFreeSpace = FsFreeSpace;
        this.m_DiskFreeSpace = DiskFreeSpace;
        this.m_LastBootTime = LastBootTime;
        this.m_ProbeStatus = ProbeStatus;
        this.m_LastProbeTime = LastProbeTime;
        this.m_OwnedDiskCap = OwnedDiskCap;
        this.m_OwnedDiskFreeSp = OwnedDiskFreeSp;
        this.m_ClusterId = ClusterId;
        this.m_NodeHostedId = NodeHostedId;
        this.m_CpuArchitecture = CpuArchitecture;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_DomainId != Integer.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("DOMAIN_ID"), String.valueOf(this.m_DomainId));
        }
        if (this.m_GroupId != Integer.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("GROUP_ID"), String.valueOf(this.m_GroupId));
        }
        if (this.m_Manufacturer != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("MANUFACTURER"), this.m_Manufacturer);
        }
        if (this.m_Model != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("MODEL"), this.m_Model);
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_OsType != Short.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("OS_TYPE"), String.valueOf(this.m_OsType));
        }
        if (this.m_OsVersion != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("OS_VERSION"), this.m_OsVersion);
        }
        if (this.m_ProcessorType != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("PROCESSOR_TYPE"), this.m_ProcessorType);
        }
        if (this.m_ProcessorCount != Short.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("PROCESSOR_COUNT"), String.valueOf(this.m_ProcessorCount));
        }
        if (this.m_ProcessorSpeed != Short.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("PROCESSOR_SPEED"), String.valueOf(this.m_ProcessorSpeed));
        }
        if (this.m_Ram != Integer.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("RAM"), String.valueOf(this.m_Ram));
        }
        if (this.m_SwapSpace != Integer.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("SWAP_SPACE"), String.valueOf(this.m_SwapSpace));
        }
        if (this.m_DiskCapacity != Double.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("DISK_CAPACITY"), String.valueOf(this.m_DiskCapacity));
        }
        if (this.m_FsFreeSpace != Double.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("FS_FREE_SPACE"), String.valueOf(this.m_FsFreeSpace));
        }
        if (this.m_DiskFreeSpace != Double.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("DISK_FREE_SPACE"), String.valueOf(this.m_DiskFreeSpace));
        }
        if (this.m_LastBootTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("LAST_BOOT_TIME"), this.m_LastBootTime);
        }
        if (this.m_ProbeStatus != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("PROBE_STATUS"), this.m_ProbeStatus);
        }
        if (this.m_LastProbeTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("LAST_PROBE_TIME"), this.m_LastProbeTime);
        }
        if (this.m_OwnedDiskCap != Double.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("OWNED_DISK_CAP"), String.valueOf(this.m_OwnedDiskCap));
        }
        if (this.m_OwnedDiskFreeSp != Double.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("OWNED_DISK_FREE_SP"), String.valueOf(this.m_OwnedDiskFreeSp));
        }
        if (this.m_ClusterId != Integer.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("CLUSTER_ID"), String.valueOf(this.m_ClusterId));
        }
        if (this.m_NodeHostedId != Integer.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("NODE_HOSTED_ID"), String.valueOf(this.m_NodeHostedId));
        }
        if (this.m_CpuArchitecture != Short.MIN_VALUE) {
            htColsAndValues.put(StatComputer.getColumnInfo("CPU_ARCHITECTURE"), String.valueOf(this.m_CpuArchitecture));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_COMPUTER", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_COMPUTER", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_COMPUTER", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_COMPUTER", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_COMPUTER", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_COMPUTER", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_COMPUTER", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatComputer retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        StatComputer el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_COMPUTER", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new StatComputer();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_COMPUTER", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_COMPUTER", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setComputerId(DBrs.getInt("COMPUTER_ID"));
        this.setDomainId(DBrs.getInt("DOMAIN_ID"));
        this.setGroupId(DBrs.getInt("GROUP_ID"));
        this.setManufacturer(DBrs.getString("MANUFACTURER"));
        this.setModel(DBrs.getString("MODEL"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setOsType(DBrs.getShort("OS_TYPE"));
        this.setOsVersion(DBrs.getString("OS_VERSION"));
        this.setProcessorType(DBrs.getString("PROCESSOR_TYPE"));
        this.setProcessorCount(DBrs.getShort("PROCESSOR_COUNT"));
        this.setProcessorSpeed(DBrs.getShort("PROCESSOR_SPEED"));
        this.setRam(DBrs.getInt("RAM"));
        this.setSwapSpace(DBrs.getInt("SWAP_SPACE"));
        this.setDiskCapacity(DBrs.getDouble("DISK_CAPACITY"));
        this.setFsFreeSpace(DBrs.getDouble("FS_FREE_SPACE"));
        this.setDiskFreeSpace(DBrs.getDouble("DISK_FREE_SPACE"));
        this.setLastBootTime(DBrs.getTimestamp("LAST_BOOT_TIME"));
        this.setProbeStatus(DBrs.getString("PROBE_STATUS"));
        this.setLastProbeTime(DBrs.getTimestamp("LAST_PROBE_TIME"));
        this.setOwnedDiskCap(DBrs.getDouble("OWNED_DISK_CAP"));
        this.setOwnedDiskFreeSp(DBrs.getDouble("OWNED_DISK_FREE_SP"));
        this.setClusterId(DBrs.getInt("CLUSTER_ID"));
        this.setNodeHostedId(DBrs.getInt("NODE_HOSTED_ID"));
        this.setCpuArchitecture(DBrs.getShort("CPU_ARCHITECTURE"));
    }

    public static class StatComputerCursor
    extends DBCursor {
        private StatComputer element = new StatComputer();
        private DBConnection con;

        public StatComputerCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_STAT_COMPUTER", con, htWhereClause, columns);
            this.con = con;
        }

        public StatComputer getObject() throws SQLException {
            StatComputer el = null;
            if (this.DBrs != null) {
                el = new StatComputer();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public StatComputer getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

