/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchBladeTable;

public class SwitchBlade
extends TResSwitchBladeTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static SwitchBladeCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new SwitchBladeCursor(con, htWhereClause, columns);
    }

    public SwitchBlade() {
        this.clear();
    }

    public SwitchBlade(int SwitchBladeId, short VendorId, String SerialNumber, String Slot, short SwitchBladeTypeId, short ModelId, String SwitchWwn, String FirmwareRevision, Timestamp UpdateTimestamp, short Detectable, int OperationalStatus, short ConsolidatedStatus, short PropagatedStatus) {
        this.clear();
        this.m_SwitchBladeId = SwitchBladeId;
        this.m_VendorId = VendorId;
        this.m_SerialNumber = SerialNumber;
        this.m_Slot = Slot;
        this.m_SwitchBladeTypeId = SwitchBladeTypeId;
        this.m_ModelId = ModelId;
        this.m_SwitchWwn = SwitchWwn;
        this.m_FirmwareRevision = FirmwareRevision;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_Detectable = Detectable;
        this.m_OperationalStatus = OperationalStatus;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_PropagatedStatus = PropagatedStatus;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_SwitchBladeId != Integer.MIN_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("SWITCH_BLADE_ID"), String.valueOf(this.m_SwitchBladeId));
        }
        if (this.m_Slot != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("SLOT"), this.m_Slot);
        }
        if (this.m_SwitchBladeTypeId != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("SWITCH_BLADE_TYPE_ID"), String.valueOf(this.m_SwitchBladeTypeId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_SwitchWwn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        }
        if (this.m_FirmwareRevision != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("FIRMWARE_REVISION"), this.m_FirmwareRevision);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(SwitchBlade.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key VENDOR_ID not found");
        }
        this.htColsAndValues.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        if (this.m_SerialNumber == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SERIAL_NUMBER not found");
        }
        this.htColsAndValues.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SWITCH_BLADE", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")) == null) {
            throw new SQLException(" ERROR: key VENDOR_ID not found");
        }
        if (htinput.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")) == null) {
            throw new SQLException(" ERROR: key SERIAL_NUMBER not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SWITCH_BLADE", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key VENDOR_ID not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        if (this.m_SerialNumber == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SERIAL_NUMBER not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_BLADE", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")) == null) {
            throw new SQLException(" ERROR: key VENDOR_ID not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")));
        if (htinput.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")) == null) {
            throw new SQLException(" ERROR: key SERIAL_NUMBER not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), htinput.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_BLADE", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key VENDOR_ID not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        if (this.m_SerialNumber == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SERIAL_NUMBER not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_BLADE", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")) == null) {
            throw new SQLException(" ERROR: key VENDOR_ID not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")));
        if (htinput.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")) == null) {
            throw new SQLException(" ERROR: key SERIAL_NUMBER not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), htinput.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_BLADE", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key VENDOR_ID not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        if (this.m_SerialNumber == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SERIAL_NUMBER not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SWITCH_BLADE", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SwitchBlade retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        SwitchBlade el = null;
        if (htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")) == null) {
            throw new SQLException(" ERROR: key VENDOR_ID not found");
        }
        htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")));
        if (htinput.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")) == null) {
            throw new SQLException(" ERROR: key SERIAL_NUMBER not found");
        }
        htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), htinput.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_SWITCH_BLADE", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new SwitchBlade();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (htinput.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_BLADE", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_BLADE", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setSwitchBladeId(DBrs.getInt("SWITCH_BLADE_ID"));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setSlot(DBrs.getString("SLOT"));
        this.setSwitchBladeTypeId(DBrs.getShort("SWITCH_BLADE_TYPE_ID"));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setSwitchWwn(DBrs.getString("SWITCH_WWN"));
        this.setFirmwareRevision(DBrs.getString("FIRMWARE_REVISION"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
    }

    public static class SwitchBladeCursor
    extends DBCursor {
        private SwitchBlade element = new SwitchBlade();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResSwitchBladeTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TResSwitchBladeTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TResSwitchBladeTable.getColumnInfo("VENDOR_ID")))));
            }
            if (htWhereClause.get(TResSwitchBladeTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TResSwitchBladeTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TResSwitchBladeTable.getColumnInfo("MODEL_ID")))));
            }
            return htWhereClause;
        }

        public SwitchBladeCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_SWITCH_BLADE", con, SwitchBladeCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public SwitchBlade getObject() throws SQLException {
            SwitchBlade el = null;
            if (this.DBrs != null) {
                el = new SwitchBlade();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public SwitchBlade getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

