/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeDriveTable;

public class TapeDrive
extends TResTapeDriveTable {
    private String m_SystemCreationClassNameId_str;
    private String m_CreationClassNameId_str;
    private String m_SystemNamesId_str;

    public void setSystemCreationClassName(String el) {
        this.m_SystemCreationClassNameId_str = el;
    }

    public String getSystemCreationClassName() {
        return this.m_SystemCreationClassNameId_str;
    }

    public void setCreationClassName(String el) {
        this.m_CreationClassNameId_str = el;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setSystemNames(String el) {
        this.m_SystemNamesId_str = el;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public static TapeDriveCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new TapeDriveCursor(con, htWhereClause, columns);
    }

    public TapeDrive() {
        this.clear();
    }

    public TapeDrive(int TapeDriveId, short SystemCreationClassNameId, short CreationClassNameId, short SystemNamesId, String DeviceId, int OperationalStatus, short NeedsCleaning, long MountCount, short Availability, long PowerOnHours, long TotalPowerOnHours, int TapeLibraryId, String ElementName, int NodeId, String FirmwareVersion, int LocationId, Timestamp UpdateTimestamp, short ConsolidatedStatus, short Detectable, String DisplayName, short PropagatedStatus, String UserAttrib1, String UserAttrib2, String UserAttrib3) {
        this.clear();
        this.m_TapeDriveId = TapeDriveId;
        this.m_SystemCreationClassNameId = SystemCreationClassNameId;
        this.m_CreationClassNameId = CreationClassNameId;
        this.m_SystemNamesId = SystemNamesId;
        this.m_DeviceId = DeviceId;
        this.m_OperationalStatus = OperationalStatus;
        this.m_NeedsCleaning = NeedsCleaning;
        this.m_MountCount = MountCount;
        this.m_Availability = Availability;
        this.m_PowerOnHours = PowerOnHours;
        this.m_TotalPowerOnHours = TotalPowerOnHours;
        this.m_TapeLibraryId = TapeLibraryId;
        this.m_ElementName = ElementName;
        this.m_NodeId = NodeId;
        this.m_FirmwareVersion = FirmwareVersion;
        this.m_LocationId = LocationId;
        this.m_UpdateTimestamp = UpdateTimestamp;
        this.m_ConsolidatedStatus = ConsolidatedStatus;
        this.m_Detectable = Detectable;
        this.m_DisplayName = DisplayName;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_UserAttrib1 = UserAttrib1;
        this.m_UserAttrib2 = UserAttrib2;
        this.m_UserAttrib3 = UserAttrib3;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_TapeDriveId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("TAPE_DRIVE_ID"), String.valueOf(this.m_TapeDriveId));
        }
        if (this.m_SystemCreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(this.m_SystemCreationClassNameId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_SystemNamesId != Short.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_NeedsCleaning != Short.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("NEEDS_CLEANING"), String.valueOf(this.m_NeedsCleaning));
        }
        if (this.m_MountCount != Long.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("MOUNT_COUNT"), String.valueOf(this.m_MountCount));
        }
        if (this.m_Availability != Short.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("AVAILABILITY"), String.valueOf(this.m_Availability));
        }
        if (this.m_PowerOnHours != Long.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("POWER_ON_HOURS"), String.valueOf(this.m_PowerOnHours));
        }
        if (this.m_TotalPowerOnHours != Long.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("TOTAL_POWER_ON_HOURS"), String.valueOf(this.m_TotalPowerOnHours));
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_NodeId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        }
        if (this.m_FirmwareVersion != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("FIRMWARE_VERSION"), this.m_FirmwareVersion);
        }
        if (this.m_LocationId != Integer.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("LOCATION_ID"), String.valueOf(this.m_LocationId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(TapeDrive.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htColsAndValues.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htColsAndValues.put(TapeDrive.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_DRIVE", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        if (htinput.get(TapeDrive.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_DRIVE", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_DRIVE", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), htinput.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")));
        if (htinput.get(TapeDrive.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), htinput.get(TapeDrive.getColumnInfo("DEVICE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_DRIVE", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_DRIVE", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), htinput.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")));
        if (htinput.get(TapeDrive.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), htinput.get(TapeDrive.getColumnInfo("DEVICE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_DRIVE", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(con, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(con, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(con, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_DRIVE", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TapeDrive retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        TapeDrive el = null;
        if (htinput.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), htinput.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")));
        if (htinput.get(TapeDrive.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), htinput.get(TapeDrive.getColumnInfo("DEVICE_ID")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_TAPE_DRIVE", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new TapeDrive();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htinput.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htinput.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htinput.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (htWhereClause.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_DRIVE", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            htWhereClause.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (htWhereClause.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            htWhereClause.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_DRIVE", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setTapeDriveId(DBrs.getInt("TAPE_DRIVE_ID"));
        this.setSystemCreationClassNameId(DBrs.getShort("SYSTEM_CREATION_CLASS_NAME_ID"));
        this.setSystemCreationClassName(Normalizer.SystemCreationClassNameGetName(con, this.m_SystemCreationClassNameId));
        this.setCreationClassNameId(DBrs.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(con, this.m_CreationClassNameId));
        this.setSystemNamesId(DBrs.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(con, this.m_SystemNamesId));
        this.setDeviceId(DBrs.getString("DEVICE_ID"));
        this.setOperationalStatus(DBrs.getInt("OPERATIONAL_STATUS"));
        this.setNeedsCleaning(DBrs.getShort("NEEDS_CLEANING"));
        this.setMountCount(DBrs.getLong("MOUNT_COUNT"));
        this.setAvailability(DBrs.getShort("AVAILABILITY"));
        this.setPowerOnHours(DBrs.getLong("POWER_ON_HOURS"));
        this.setTotalPowerOnHours(DBrs.getLong("TOTAL_POWER_ON_HOURS"));
        this.setTapeLibraryId(DBrs.getInt("TAPE_LIBRARY_ID"));
        this.setElementName(DBrs.getString("ELEMENT_NAME"));
        this.setNodeId(DBrs.getInt("NODE_ID"));
        this.setFirmwareVersion(DBrs.getString("FIRMWARE_VERSION"));
        this.setLocationId(DBrs.getInt("LOCATION_ID"));
        this.setUpdateTimestamp(DBrs.getTimestamp("UPDATE_TIMESTAMP"));
        this.setConsolidatedStatus(DBrs.getShort("CONSOLIDATED_STATUS"));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setPropagatedStatus(DBrs.getShort("PROPAGATED_STATUS"));
        this.setUserAttrib1(DBrs.getString("USER_ATTRIB1"));
        this.setUserAttrib2(DBrs.getString("USER_ATTRIB2"));
        this.setUserAttrib3(DBrs.getString("USER_ATTRIB3"));
    }

    public static class TapeDriveCursor
    extends DBCursor {
        private TapeDrive element = new TapeDrive();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TResTapeDriveTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResTapeDriveTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(con, (String)htWhereClause.get(TResTapeDriveTable.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResTapeDriveTable.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                htWhereClause.put(TResTapeDriveTable.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(con, (String)htWhereClause.get(TResTapeDriveTable.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (htWhereClause.get(TResTapeDriveTable.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                htWhereClause.put(TResTapeDriveTable.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(con, (String)htWhereClause.get(TResTapeDriveTable.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            return htWhereClause;
        }

        public TapeDriveCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_TAPE_DRIVE", con, TapeDriveCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public TapeDrive getObject() throws SQLException {
            TapeDrive el = null;
            if (this.DBrs != null) {
                el = new TapeDrive();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public TapeDrive getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

