/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatTotalsTable;

public class Totals
extends TStatTotalsTable {
    public static TotalsCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new TotalsCursor(con, htWhereClause, columns);
    }

    public Totals() {
        this.clear();
    }

    public Totals(short StatisticType, Timestamp UpdateTime, double FsCapacity, double UsedSpace, double FreeSpace, double DiskCapacity, double DiskUnallocated, int TotalDirectories, int TotalFiles, int TotalFilesystems, int TotalAgents, int TotalComputers, int TotalUsers, int TotalDisks, int AllAlerts, int ComputerAlerts, int HardDiskAlerts, int FilesystemAlerts, int DirectoryAlerts, int UserQuotaAlerts, int GrpQuotaAlerts, int UserAlerts, short ComputerType, String UserName, String FilesystemName, int TotalSs, int TotalLuns, double LunCapacity, double UsableLunCap, int SsAlerts, int SwitchAlerts, int FabricAlerts, int EndptAlerts, int TapeLibAlerts, int ExternalAlerts) {
        this.clear();
        this.m_StatisticType = StatisticType;
        this.m_UpdateTime = UpdateTime;
        this.m_FsCapacity = FsCapacity;
        this.m_UsedSpace = UsedSpace;
        this.m_FreeSpace = FreeSpace;
        this.m_DiskCapacity = DiskCapacity;
        this.m_DiskUnallocated = DiskUnallocated;
        this.m_TotalDirectories = TotalDirectories;
        this.m_TotalFiles = TotalFiles;
        this.m_TotalFilesystems = TotalFilesystems;
        this.m_TotalAgents = TotalAgents;
        this.m_TotalComputers = TotalComputers;
        this.m_TotalUsers = TotalUsers;
        this.m_TotalDisks = TotalDisks;
        this.m_AllAlerts = AllAlerts;
        this.m_ComputerAlerts = ComputerAlerts;
        this.m_HardDiskAlerts = HardDiskAlerts;
        this.m_FilesystemAlerts = FilesystemAlerts;
        this.m_DirectoryAlerts = DirectoryAlerts;
        this.m_UserQuotaAlerts = UserQuotaAlerts;
        this.m_GrpQuotaAlerts = GrpQuotaAlerts;
        this.m_UserAlerts = UserAlerts;
        this.m_ComputerType = ComputerType;
        this.m_UserName = UserName;
        this.m_FilesystemName = FilesystemName;
        this.m_TotalSs = TotalSs;
        this.m_TotalLuns = TotalLuns;
        this.m_LunCapacity = LunCapacity;
        this.m_UsableLunCap = UsableLunCap;
        this.m_SsAlerts = SsAlerts;
        this.m_SwitchAlerts = SwitchAlerts;
        this.m_FabricAlerts = FabricAlerts;
        this.m_EndptAlerts = EndptAlerts;
        this.m_TapeLibAlerts = TapeLibAlerts;
        this.m_ExternalAlerts = ExternalAlerts;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_StatisticType != Short.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("STATISTIC_TYPE"), String.valueOf(this.m_StatisticType));
        }
        if (this.m_UpdateTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("UPDATE_TIME"), this.m_UpdateTime);
        }
        if (this.m_FsCapacity != Double.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("FS_CAPACITY"), String.valueOf(this.m_FsCapacity));
        }
        if (this.m_UsedSpace != Double.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("USED_SPACE"), String.valueOf(this.m_UsedSpace));
        }
        if (this.m_FreeSpace != Double.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("FREE_SPACE"), String.valueOf(this.m_FreeSpace));
        }
        if (this.m_DiskCapacity != Double.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("DISK_CAPACITY"), String.valueOf(this.m_DiskCapacity));
        }
        if (this.m_DiskUnallocated != Double.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("DISK_UNALLOCATED"), String.valueOf(this.m_DiskUnallocated));
        }
        if (this.m_TotalDirectories != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("TOTAL_DIRECTORIES"), String.valueOf(this.m_TotalDirectories));
        }
        if (this.m_TotalFiles != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("TOTAL_FILES"), String.valueOf(this.m_TotalFiles));
        }
        if (this.m_TotalFilesystems != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("TOTAL_FILESYSTEMS"), String.valueOf(this.m_TotalFilesystems));
        }
        if (this.m_TotalAgents != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("TOTAL_AGENTS"), String.valueOf(this.m_TotalAgents));
        }
        if (this.m_TotalComputers != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("TOTAL_COMPUTERS"), String.valueOf(this.m_TotalComputers));
        }
        if (this.m_TotalUsers != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("TOTAL_USERS"), String.valueOf(this.m_TotalUsers));
        }
        if (this.m_TotalDisks != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("TOTAL_DISKS"), String.valueOf(this.m_TotalDisks));
        }
        if (this.m_AllAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("ALL_ALERTS"), String.valueOf(this.m_AllAlerts));
        }
        if (this.m_ComputerAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("COMPUTER_ALERTS"), String.valueOf(this.m_ComputerAlerts));
        }
        if (this.m_HardDiskAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("HARD_DISK_ALERTS"), String.valueOf(this.m_HardDiskAlerts));
        }
        if (this.m_FilesystemAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("FILESYSTEM_ALERTS"), String.valueOf(this.m_FilesystemAlerts));
        }
        if (this.m_DirectoryAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("DIRECTORY_ALERTS"), String.valueOf(this.m_DirectoryAlerts));
        }
        if (this.m_UserQuotaAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("USER_QUOTA_ALERTS"), String.valueOf(this.m_UserQuotaAlerts));
        }
        if (this.m_GrpQuotaAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("GRP_QUOTA_ALERTS"), String.valueOf(this.m_GrpQuotaAlerts));
        }
        if (this.m_UserAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("USER_ALERTS"), String.valueOf(this.m_UserAlerts));
        }
        if (this.m_ComputerType != Short.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("COMPUTER_TYPE"), String.valueOf(this.m_ComputerType));
        }
        if (this.m_UserName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("USER_NAME"), this.m_UserName);
        }
        if (this.m_FilesystemName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("FILESYSTEM_NAME"), this.m_FilesystemName);
        }
        if (this.m_TotalSs != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("TOTAL_SS"), String.valueOf(this.m_TotalSs));
        }
        if (this.m_TotalLuns != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("TOTAL_LUNS"), String.valueOf(this.m_TotalLuns));
        }
        if (this.m_LunCapacity != Double.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("LUN_CAPACITY"), String.valueOf(this.m_LunCapacity));
        }
        if (this.m_UsableLunCap != Double.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("USABLE_LUN_CAP"), String.valueOf(this.m_UsableLunCap));
        }
        if (this.m_SsAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("SS_ALERTS"), String.valueOf(this.m_SsAlerts));
        }
        if (this.m_SwitchAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("SWITCH_ALERTS"), String.valueOf(this.m_SwitchAlerts));
        }
        if (this.m_FabricAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("FABRIC_ALERTS"), String.valueOf(this.m_FabricAlerts));
        }
        if (this.m_EndptAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("ENDPT_ALERTS"), String.valueOf(this.m_EndptAlerts));
        }
        if (this.m_TapeLibAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("TAPE_LIB_ALERTS"), String.valueOf(this.m_TapeLibAlerts));
        }
        if (this.m_ExternalAlerts != Integer.MIN_VALUE) {
            htColsAndValues.put(Totals.getColumnInfo("EXTERNAL_ALERTS"), String.valueOf(this.m_ExternalAlerts));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_TOTALS", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_TOTALS", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_TOTALS", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_TOTALS", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_TOTALS", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_TOTALS", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_TOTALS", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Totals retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Totals el = null;
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_STAT_TOTALS", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Totals();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_TOTALS", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_TOTALS", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setStatisticType(DBrs.getShort("STATISTIC_TYPE"));
        this.setUpdateTime(DBrs.getTimestamp("UPDATE_TIME"));
        this.setFsCapacity(DBrs.getDouble("FS_CAPACITY"));
        this.setUsedSpace(DBrs.getDouble("USED_SPACE"));
        this.setFreeSpace(DBrs.getDouble("FREE_SPACE"));
        this.setDiskCapacity(DBrs.getDouble("DISK_CAPACITY"));
        this.setDiskUnallocated(DBrs.getDouble("DISK_UNALLOCATED"));
        this.setTotalDirectories(DBrs.getInt("TOTAL_DIRECTORIES"));
        this.setTotalFiles(DBrs.getInt("TOTAL_FILES"));
        this.setTotalFilesystems(DBrs.getInt("TOTAL_FILESYSTEMS"));
        this.setTotalAgents(DBrs.getInt("TOTAL_AGENTS"));
        this.setTotalComputers(DBrs.getInt("TOTAL_COMPUTERS"));
        this.setTotalUsers(DBrs.getInt("TOTAL_USERS"));
        this.setTotalDisks(DBrs.getInt("TOTAL_DISKS"));
        this.setAllAlerts(DBrs.getInt("ALL_ALERTS"));
        this.setComputerAlerts(DBrs.getInt("COMPUTER_ALERTS"));
        this.setHardDiskAlerts(DBrs.getInt("HARD_DISK_ALERTS"));
        this.setFilesystemAlerts(DBrs.getInt("FILESYSTEM_ALERTS"));
        this.setDirectoryAlerts(DBrs.getInt("DIRECTORY_ALERTS"));
        this.setUserQuotaAlerts(DBrs.getInt("USER_QUOTA_ALERTS"));
        this.setGrpQuotaAlerts(DBrs.getInt("GRP_QUOTA_ALERTS"));
        this.setUserAlerts(DBrs.getInt("USER_ALERTS"));
        this.setComputerType(DBrs.getShort("COMPUTER_TYPE"));
        this.setUserName(DBrs.getString("USER_NAME"));
        this.setFilesystemName(DBrs.getString("FILESYSTEM_NAME"));
        this.setTotalSs(DBrs.getInt("TOTAL_SS"));
        this.setTotalLuns(DBrs.getInt("TOTAL_LUNS"));
        this.setLunCapacity(DBrs.getDouble("LUN_CAPACITY"));
        this.setUsableLunCap(DBrs.getDouble("USABLE_LUN_CAP"));
        this.setSsAlerts(DBrs.getInt("SS_ALERTS"));
        this.setSwitchAlerts(DBrs.getInt("SWITCH_ALERTS"));
        this.setFabricAlerts(DBrs.getInt("FABRIC_ALERTS"));
        this.setEndptAlerts(DBrs.getInt("ENDPT_ALERTS"));
        this.setTapeLibAlerts(DBrs.getInt("TAPE_LIB_ALERTS"));
        this.setExternalAlerts(DBrs.getInt("EXTERNAL_ALERTS"));
    }

    public static class TotalsCursor
    extends DBCursor {
        private Totals element = new Totals();
        private DBConnection con;

        public TotalsCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_STAT_TOTALS", con, htWhereClause, columns);
            this.con = con;
        }

        public Totals getObject() throws SQLException {
            Totals el = null;
            if (this.DBrs != null) {
                el = new Totals();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Totals getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

