/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TViewVunknownTable;

public class Vunknown
extends TViewVunknownTable {
    private String m_ModelId_str;
    private String m_VendorId_str;

    public void setModel(String el) {
        this.m_ModelId_str = el;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public void setVendor(String el) {
        this.m_VendorId_str = el;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public static VunknownCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new VunknownCursor(con, htWhereClause, columns);
    }

    public Vunknown() {
        this.clear();
    }

    public Vunknown(String PrefixId, int UnknownId, String DisplayName, String Wwn, String AccessInfo, String SerialNumber, short ModelId, short VendorId, short Detectable, int PropagatedStatus, int OtherType) {
        this.clear();
        this.m_PrefixId = PrefixId;
        this.m_UnknownId = UnknownId;
        this.m_DisplayName = DisplayName;
        this.m_Wwn = Wwn;
        this.m_AccessInfo = AccessInfo;
        this.m_SerialNumber = SerialNumber;
        this.m_ModelId = ModelId;
        this.m_VendorId = VendorId;
        this.m_Detectable = Detectable;
        this.m_PropagatedStatus = PropagatedStatus;
        this.m_OtherType = OtherType;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_PrefixId != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("PREFIX_ID"), this.m_PrefixId);
        }
        if (this.m_UnknownId != Integer.MIN_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("UNKNOWN_ID"), String.valueOf(this.m_UnknownId));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_Wwn != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("WWN"), this.m_Wwn);
        }
        if (this.m_AccessInfo != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("ACCESS_INFO"), this.m_AccessInfo);
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_PropagatedStatus != Integer.MIN_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_OtherType != Integer.MIN_VALUE) {
            htColsAndValues.put(Vunknown.getColumnInfo("OTHER_TYPE"), String.valueOf(this.m_OtherType));
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_VIEW_VUNKNOWN", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Vunknown.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Vunknown.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Vunknown.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Vunknown.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Vunknown.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Vunknown.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performInsert("T_VIEW_VUNKNOWN", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VUNKNOWN", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Vunknown.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Vunknown.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Vunknown.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Vunknown.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Vunknown.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Vunknown.getColumnInfo("VENDOR_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VUNKNOWN", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_VUNKNOWN", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(Vunknown.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Vunknown.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Vunknown.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Vunknown.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Vunknown.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Vunknown.getColumnInfo("VENDOR_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_VUNKNOWN", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(con, this.m_ModelId_str);
        }
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(con, this.m_VendorId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_VUNKNOWN", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vunknown retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        Vunknown el = null;
        if (htinput.get(Vunknown.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Vunknown.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Vunknown.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Vunknown.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Vunknown.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Vunknown.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_VIEW_VUNKNOWN", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new Vunknown();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(Vunknown.getColumnInfo("MODEL_ID")) != null) {
            htinput.put(Vunknown.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htinput.get(Vunknown.getColumnInfo("MODEL_ID")))));
        }
        if (htinput.get(Vunknown.getColumnInfo("VENDOR_ID")) != null) {
            htinput.put(Vunknown.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htinput.get(Vunknown.getColumnInfo("VENDOR_ID")))));
        }
        if (htWhereClause.get(Vunknown.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(Vunknown.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(Vunknown.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(Vunknown.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(Vunknown.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(Vunknown.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_VIEW_VUNKNOWN", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htWhereClause.get(Vunknown.getColumnInfo("MODEL_ID")) != null) {
            htWhereClause.put(Vunknown.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(Vunknown.getColumnInfo("MODEL_ID")))));
        }
        if (htWhereClause.get(Vunknown.getColumnInfo("VENDOR_ID")) != null) {
            htWhereClause.put(Vunknown.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(Vunknown.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performDelete("T_VIEW_VUNKNOWN", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setPrefixId(DBrs.getString("PREFIX_ID"));
        this.setUnknownId(DBrs.getInt("UNKNOWN_ID"));
        this.setDisplayName(DBrs.getString("DISPLAY_NAME"));
        this.setWwn(DBrs.getString("WWN"));
        this.setAccessInfo(DBrs.getString("ACCESS_INFO"));
        this.setSerialNumber(DBrs.getString("SERIAL_NUMBER"));
        this.setModelId(DBrs.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(con, this.m_ModelId));
        this.setVendorId(DBrs.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(con, this.m_VendorId));
        this.setDetectable(DBrs.getShort("DETECTABLE"));
        this.setPropagatedStatus(DBrs.getInt("PROPAGATED_STATUS"));
        this.setOtherType(DBrs.getInt("OTHER_TYPE"));
    }

    public static class VunknownCursor
    extends DBCursor {
        private Vunknown element = new Vunknown();
        private DBConnection con;

        private static Hashtable normalize(DBConnection con, Hashtable htWhereClause) throws SQLException {
            if (htWhereClause == null) {
                return null;
            }
            if (htWhereClause.get(TViewVunknownTable.getColumnInfo("MODEL_ID")) != null) {
                htWhereClause.put(TViewVunknownTable.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(con, (String)htWhereClause.get(TViewVunknownTable.getColumnInfo("MODEL_ID")))));
            }
            if (htWhereClause.get(TViewVunknownTable.getColumnInfo("VENDOR_ID")) != null) {
                htWhereClause.put(TViewVunknownTable.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(con, (String)htWhereClause.get(TViewVunknownTable.getColumnInfo("VENDOR_ID")))));
            }
            return htWhereClause;
        }

        public VunknownCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_VIEW_VUNKNOWN", con, VunknownCursor.normalize(con, htWhereClause), columns);
            this.con = con;
        }

        public Vunknown getObject() throws SQLException {
            Vunknown el = null;
            if (this.DBrs != null) {
                el = new Vunknown();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public Vunknown getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

