/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResZoneMemberTable;

public class ZoneMember
extends TResZoneMemberTable {
    public static ZoneMemberCursor getCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
        return new ZoneMemberCursor(con, htWhereClause, columns);
    }

    public ZoneMember() {
        this.clear();
    }

    public ZoneMember(int ZoneMemberId, String MemberName, short Type2, short VendorType, String Description) {
        this.clear();
        this.m_ZoneMemberId = ZoneMemberId;
        this.m_MemberName = MemberName;
        this.m_Type = Type2;
        this.m_VendorType = VendorType;
        this.m_Description = Description;
    }

    private void setNonKeyValues(Hashtable htColsAndValues) {
        if (this.m_ZoneMemberId != Integer.MIN_VALUE) {
            htColsAndValues.put(ZoneMember.getColumnInfo("ZONE_MEMBER_ID"), String.valueOf(this.m_ZoneMemberId));
        }
        if (this.m_Type != Short.MIN_VALUE) {
            htColsAndValues.put(ZoneMember.getColumnInfo("TYPE"), String.valueOf(this.m_Type));
        }
        if (this.m_VendorType != Short.MIN_VALUE) {
            htColsAndValues.put(ZoneMember.getColumnInfo("VENDOR_TYPE"), String.valueOf(this.m_VendorType));
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            htColsAndValues.put(ZoneMember.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
    }

    public boolean insert(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_MemberName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MEMBER_NAME not found");
        }
        this.htColsAndValues.put(ZoneMember.getColumnInfo("MEMBER_NAME"), this.m_MemberName);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_ZONE_MEMBER", con, this.htColsAndValues);
    }

    public boolean insert(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (htinput.get(ZoneMember.getColumnInfo("MEMBER_NAME")) == null) {
            throw new SQLException(" ERROR: key MEMBER_NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_ZONE_MEMBER", con, htinput);
    }

    public int update(DBConnection con) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_MemberName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MEMBER_NAME not found");
        }
        this.htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), this.m_MemberName);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_ZONE_MEMBER", con, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(ZoneMember.getColumnInfo("MEMBER_NAME")) == null) {
            throw new SQLException(" ERROR: key MEMBER_NAME not found");
        }
        this.htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), htinput.get(ZoneMember.getColumnInfo("MEMBER_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_ZONE_MEMBER", con, htinput, this.htWhereClause);
    }

    public int delete(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_MemberName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MEMBER_NAME not found");
        }
        this.htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), this.m_MemberName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_ZONE_MEMBER", con, this.htWhereClause);
    }

    public int delete(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (htinput.get(ZoneMember.getColumnInfo("MEMBER_NAME")) == null) {
            throw new SQLException(" ERROR: key MEMBER_NAME not found");
        }
        this.htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), htinput.get(ZoneMember.getColumnInfo("MEMBER_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_ZONE_MEMBER", con, this.htWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieve(DBConnection con) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_MemberName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MEMBER_NAME not found");
        }
        this.htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), this.m_MemberName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        boolean res = false;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_ZONE_MEMBER", con, this.htWhereClause, null);
            if (DBrs.next()) {
                this.setFields(con, DBrs);
                res = true;
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZoneMember retrieve(DBConnection con, Hashtable htinput) throws SQLException {
        if (con == null || htinput == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable htWhereClause = new Hashtable();
        ZoneMember el = null;
        if (htinput.get(ZoneMember.getColumnInfo("MEMBER_NAME")) == null) {
            throw new SQLException(" ERROR: key MEMBER_NAME not found");
        }
        htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), htinput.get(ZoneMember.getColumnInfo("MEMBER_NAME")));
        if (htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet DBrs = null;
        try {
            DBrs = DBQueryAssistant.performRetrieve("T_RES_ZONE_MEMBER", con, htWhereClause, null);
            if (DBrs.next()) {
                el = new ZoneMember();
                el.setFields(con, DBrs);
            }
        }
        finally {
            if (DBrs != null) {
                DBrs.getStatement().close();
            }
        }
        return el;
    }

    public static int update(DBConnection con, Hashtable htinput, Hashtable htWhereClause) throws SQLException {
        if (con == null || htinput == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_ZONE_MEMBER", con, htinput, htWhereClause);
    }

    public static int deletes(DBConnection con, Hashtable htWhereClause) throws SQLException {
        if (con == null || htWhereClause == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_ZONE_MEMBER", con, htWhereClause);
    }

    protected void setFields(DBConnection con, DBResultSet DBrs) throws SQLException {
        this.setZoneMemberId(DBrs.getInt("ZONE_MEMBER_ID"));
        this.setMemberName(DBrs.getString("MEMBER_NAME"));
        this.setType(DBrs.getShort("TYPE"));
        this.setVendorType(DBrs.getShort("VENDOR_TYPE"));
        this.setDescription(DBrs.getString("DESCRIPTION"));
    }

    public static class ZoneMemberCursor
    extends DBCursor {
        private ZoneMember element = new ZoneMember();
        private DBConnection con;

        public ZoneMemberCursor(DBConnection con, Hashtable htWhereClause, Vector columns) throws SQLException {
            super("T_RES_ZONE_MEMBER", con, htWhereClause, columns);
            this.con = con;
        }

        public ZoneMember getObject() throws SQLException {
            ZoneMember el = null;
            if (this.DBrs != null) {
                el = new ZoneMember();
                el.setFields(this.con, this.DBrs);
            }
            return el;
        }

        public ZoneMember getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

