/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.detectability;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Null;
import org.eclipse.aperi.infrastructure.database.objects.Attribute;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.Fabric2switch;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Node2computer;
import org.eclipse.aperi.infrastructure.database.objects.Pe2node;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.Port2parent;
import org.eclipse.aperi.infrastructure.database.objects.Port2port2fabric;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.infrastructure.database.sql.SqlAttribute;
import org.eclipse.aperi.infrastructure.history.detectability.AssociatedEntityElement;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetectionElement;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class ChangeDetection {
    private static Hashtable hChangeDetection = null;
    private static Hashtable assocEntity = null;
    private static String thisClassName = ChangeDetection.class.getName();
    private static boolean TRACE = false;
    private static ILogger traceLogger = null;
    private static ColumnInfo groupidCI = StorageSubsystem.getColumnInfo("GROUP_ID");
    private static int tokenGenerator = 0;
    private static int[] systemTypes = new int[]{114, 127, 13, 126, 139, 138, 129, 121, 78, 77, 1, 0, 134, 133};
    private static int[] attributeTypes = new int[]{114, 121, 138, 129, 81, 82, 26};
    private static int[] groupTypes = new int[]{77, 0, 133};
    public int tokenid = -1;
    private ViewReportTablesUpdater vrtu = null;
    private static IEventMonitorService iems = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeDetection(DBConnection dbCon) {
        Class<ChangeDetection> clazz = ChangeDetection.class;
        synchronized (ChangeDetection.class) {
            this.tokenid = tokenGenerator++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.vrtu = new ViewReportTablesUpdater();
            this.startEntityAttribute(dbCon);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getEntityAttribute(DBConnection dbCon, ColumnInfo idColumnInfo, ColumnInfo[] attributeColumnInfo, String className, String systemId) throws SQLException {
        String methodName = "getEntityAttribute";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
        }
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        Vector<String> v = new Vector<String>();
        htWhereClause.put(idColumnInfo, systemId);
        for (int i = 0; i < attributeColumnInfo.length; ++i) {
            v.add(attributeColumnInfo[i].getName());
        }
        DBCursor sc = null;
        try {
            Class<?> helperClass = Class.forName(className);
            Method getCursorMethod = helperClass.getDeclaredMethod("getCursor", DBConnection.class, Hashtable.class, Vector.class);
            sc = (DBCursor)getCursorMethod.invoke(helperClass, dbCon, htWhereClause, v);
            if (sc.next()) {
                Object[] attribs = sc.getAttribute(v);
                if (TRACE) {
                    traceLogger.entry(IRecordType.TYPE_INFO, methodName, "attribute returned is " + attribs[0]);
                }
                if (TRACE) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
                }
                Object[] objectArray = attribs;
                return objectArray;
            }
        }
        catch (Exception e) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e);
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_INFO, methodName, "attribute returned is null");
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getSnapEntityAttribute(DBConnection dbCon, ColumnInfo idColumnInfo, ColumnInfo[] attributeColumnInfo, int resourceType, int attributeType, Object[] entityValue, String className, String systemId) throws SQLException {
        String methodName = "getSnapEntityAttribute";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
        }
        Object[] snapValue = null;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        Vector<String> v = new Vector<String>();
        htWhereClause.put(idColumnInfo, systemId);
        for (int i = 0; i < attributeColumnInfo.length; ++i) {
            v.add(attributeColumnInfo[i].getName());
        }
        DBCursor sc = null;
        try {
            Class<?> helperClass = Class.forName(className + "AttributeSnapshot");
            Method getCursorMethod = helperClass.getDeclaredMethod("getCursor", DBConnection.class, Hashtable.class, Vector.class);
            sc = (DBCursor)getCursorMethod.invoke(helperClass, dbCon, htWhereClause, v);
            if (sc.next()) {
                Object[] attribs;
                snapValue = attribs = sc.getAttribute(v);
            }
            sc.close();
        }
        catch (Exception e) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e);
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
        return snapValue;
    }

    private static void operateSnapEntityAttribute(DBConnection dbCon, String className, String method, ColumnInfo idColumnInfo, ColumnInfo[] attributeColumnInfo, String systemId, Object[] entityValue) {
        String methodName;
        block9: {
            methodName = "operateSnapEntityAttribute";
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName + ":" + method);
            }
            Hashtable<ColumnInfo, Object> htWhereClause = new Hashtable<ColumnInfo, Object>();
            htWhereClause.put(idColumnInfo, systemId);
            if (method.equals("insert") || method.equals("update")) {
                for (int i = 0; i < attributeColumnInfo.length; ++i) {
                    if (entityValue[i] instanceof Integer || entityValue[i] instanceof Long || entityValue[i] instanceof Short || entityValue[i] instanceof Double) {
                        entityValue[i] = entityValue[i].toString();
                    }
                    if (entityValue[i] == null) {
                        entityValue[i] = new Null();
                    }
                    htWhereClause.put(attributeColumnInfo[i], entityValue[i]);
                }
            }
            try {
                Class<?> helperClass = Class.forName(className + "AttributeSnapshot");
                Method getCursorMethod = helperClass.getDeclaredMethod(method, DBConnection.class, Hashtable.class);
                getCursorMethod.invoke(helperClass.newInstance(), dbCon, htWhereClause);
                if (method.equals("insert") || method.equals("update") || method.equals("delete")) {
                    dbCon.commit();
                }
            }
            catch (Exception e) {
                if (!TRACE) break block9;
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e);
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName + ":" + method);
        }
    }

    private String getTableName(int systemType) {
        switch (systemType) {
            case 13: 
            case 77: 
            case 78: {
                return "T_RES_STORAGE_SUBSYSTEM";
            }
            case 114: {
                return "T_RES_FABRIC";
            }
            case 127: {
                return "T_RES_ZONE";
            }
            case 126: {
                return "T_RES_ZSET";
            }
            case 121: {
                return "T_RES_SWITCH";
            }
            case 129: 
            case 139: {
                return "T_RES_PHY_PE";
            }
            case 138: {
                return "T_RES_NODE";
            }
            case 0: 
            case 1: {
                return "T_RES_HOST";
            }
            case 133: 
            case 134: {
                return "T_RES_TAPE_LIBRARY";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAssociatedEntityAttribute(DBConnection dbCon, String tableName, String systemId) {
        Vector assocVec;
        String methodName = "startAssociatedEntityAttribute";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
        }
        if ((assocVec = (Vector)assocEntity.get(tableName)) == null) {
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
            }
            return;
        }
        for (int s = 0; s < assocVec.size(); ++s) {
            AssociatedEntityElement aee = (AssociatedEntityElement)assocVec.elementAt(s);
            Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
            Vector<String> v = new Vector<String>();
            htWhereClause.put(aee.associatorColumnInfo, systemId);
            ChangeDetectionElement cde = (ChangeDetectionElement)hChangeDetection.get(aee.tableName);
            if (cde == null) continue;
            v.add(cde.idColumnInfo.getName());
            DBCursor sc = null;
            try {
                Class<?> helperClass = Class.forName(cde.className);
                Method getCursorMethod = helperClass.getDeclaredMethod("getCursor", DBConnection.class, Hashtable.class, Vector.class);
                sc = (DBCursor)getCursorMethod.invoke(helperClass, dbCon, htWhereClause, v);
                while (sc.next()) {
                    String aId;
                    Object[] entityValue;
                    Object[] attribs = sc.getAttribute(v);
                    if (TRACE) {
                        traceLogger.entry(IRecordType.TYPE_INFO, methodName, "attribute returned is " + attribs[0]);
                    }
                    if ((entityValue = this.getEntityAttribute(dbCon, cde.idColumnInfo, cde.attributeColumnInfo, cde.className, aId = attribs[0].toString())) == null) continue;
                    try {
                        ChangeDetection.operateSnapEntityAttribute(dbCon, cde.className, "insert", cde.idColumnInfo, cde.attributeColumnInfo, aId, entityValue);
                    }
                    catch (Exception e3) {
                        if (!TRACE) continue;
                        traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e3);
                    }
                }
                continue;
            }
            catch (Exception e) {
                if (!TRACE) continue;
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e);
                continue;
            }
            finally {
                block21: {
                    try {
                        if (sc != null) {
                            sc.close();
                        }
                    }
                    catch (Exception e1) {
                        if (!TRACE) break block21;
                        traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e1);
                    }
                }
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
    }

    private boolean isGroupType(int systemType) {
        boolean ret = false;
        for (int i = 0; i < groupTypes.length; ++i) {
            if (groupTypes[i] != systemType) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private String normalizeType(String systemType) {
        if (systemType.equals("T_RES_PORT2PORT")) {
            return "T_VIEW_PORT2PORT2FABRIC";
        }
        if (systemType.equals("T_RES_NODE2HBA")) {
            return "T_VIEW_NODE2COMPUTER";
        }
        if (systemType.equals("T_RES_PORT")) {
            return "T_VIEW_PORT2PARENT";
        }
        return systemType;
    }

    private String deNormalizeType(String systemType) {
        if (systemType.equals("T_VIEW_PORT2PORT2FABRIC")) {
            return "T_RES_PORT2PORT";
        }
        if (systemType.equals("T_VIEW_NODE2COMPUTER")) {
            return "T_RES_NODE2HBA";
        }
        if (systemType.equals("T_VIEW_PORT2PARENT")) {
            return "T_RES_PORT";
        }
        return systemType;
    }

    public void startNew(DBConnection dbCon, Map newEntries) {
        String methodName;
        block7: {
            methodName = "startNew";
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
            }
            this.vrtu.processView(newEntries);
            try {
                for (String systemType : newEntries.keySet()) {
                    List systemIdVec = (List)newEntries.get(systemType);
                    systemType = this.normalizeType(systemType);
                    for (int i = 0; i < systemIdVec.size(); ++i) {
                        String systemId_int = (String)systemIdVec.get(i);
                        String systemId = this.subWwnForId(dbCon, systemType, systemId_int);
                        if (TRACE) {
                            traceLogger.entry(IRecordType.TYPE_INFO, methodName, systemType + ":" + systemId);
                        }
                        this.startNewEntityAttribute(dbCon, systemType, systemId);
                        this.startNewEntityAttribute2(dbCon, systemType, systemId);
                    }
                }
            }
            catch (Exception e) {
                if (!TRACE) break block7;
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e);
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewEntityAttribute(DBConnection dbCon, String systemType, String systemId) {
        String methodName;
        block28: {
            methodName = "startNewEntityAttribute";
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
            }
            ChangeDetectionElement cde = (ChangeDetectionElement)hChangeDetection.get(systemType);
            String tableName = systemType;
            if (cde != null) {
                boolean dynamicAlertDefined = false;
                DBCursor acs = null;
                try {
                    Hashtable<ColumnInfo, Number> ht = new Hashtable<ColumnInfo, Number>();
                    ht.put(Attribute.getColumnInfo("ATTRIBUTE_TYPE"), new Short((short)cde.attributeType));
                    ht.put(Attribute.getColumnInfo("RESOURCE_ID"), new Integer(-1));
                    acs = Attribute.getCursor(dbCon, ht, null);
                    dynamicAlertDefined = acs.next();
                }
                catch (Exception e1) {
                    if (TRACE) {
                        traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e1);
                    }
                }
                finally {
                    block25: {
                        try {
                            if (acs != null) {
                                acs.close();
                            }
                        }
                        catch (Exception e2) {
                            if (!TRACE) break block25;
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e2);
                        }
                    }
                }
                if (dynamicAlertDefined) {
                    Object[] entityValue;
                    block26: {
                        entityValue = null;
                        try {
                            entityValue = this.getEntityAttribute(dbCon, cde.idColumnInfo, cde.attributeColumnInfo, cde.className, systemId);
                        }
                        catch (Exception e3) {
                            if (!TRACE) break block26;
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e3);
                        }
                    }
                    if (entityValue != null) {
                        block27: {
                            try {
                                ChangeDetection.operateSnapEntityAttribute(dbCon, cde.className, "insert", cde.idColumnInfo, cde.attributeColumnInfo, systemId, entityValue);
                            }
                            catch (Exception e1) {
                                if (!TRACE) break block27;
                                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e1);
                            }
                        }
                        try {
                            this.startAssociatedEntityAttribute(dbCon, tableName, systemId);
                        }
                        catch (Exception e1) {
                            if (!TRACE) break block28;
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e1);
                        }
                    }
                }
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
    }

    private void startNewEntityAttribute2(DBConnection dbCon, String systemType, String systemId) {
        String methodName = "startNewEntityAttribute2";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
        }
        Enumeration e = assocEntity.keys();
        while (e.hasMoreElements()) {
            String parent = (String)e.nextElement();
            Vector v = (Vector)assocEntity.get(parent);
            for (int i = 0; i < v.size(); ++i) {
                ChangeDetectionElement cde;
                AssociatedEntityElement aee = (AssociatedEntityElement)v.get(i);
                if (!aee.tableName.equals(this.normalizeType(systemType)) || (cde = (ChangeDetectionElement)hChangeDetection.get(aee.tableName)) == null) continue;
                try {
                    Object[] snap_entity_val;
                    Object[] parentValue = this.getEntityAttribute(dbCon, cde.idColumnInfo, new ColumnInfo[]{aee.associatorColumnInfo}, cde.className, systemId);
                    if (parentValue == null) continue;
                    String parent_id = parentValue[0].toString();
                    ChangeDetectionElement cdep = (ChangeDetectionElement)hChangeDetection.get(parent);
                    if (cdep == null || (snap_entity_val = this.getSnapEntityAttribute(dbCon, cdep.idColumnInfo, cdep.attributeColumnInfo, cdep.resourceType, cdep.attributeType, parentValue, cdep.className, parent_id)) == null) continue;
                    Object[] entityValue = this.getEntityAttribute(dbCon, cde.idColumnInfo, cde.attributeColumnInfo, cde.className, systemId);
                    ChangeDetection.operateSnapEntityAttribute(dbCon, cde.className, "insert", cde.idColumnInfo, cde.attributeColumnInfo, systemId, entityValue);
                    continue;
                }
                catch (Exception e3) {
                    if (!TRACE) continue;
                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e3);
                }
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEntityAttribute(DBConnection dbCon) {
        String methodName = "startEntityAttribute";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
        }
        String types_array = "";
        for (int i = 0; i < systemTypes.length; ++i) {
            types_array = types_array + String.valueOf(systemTypes[i]);
            if (i >= systemTypes.length - 1) continue;
            types_array = types_array + ",";
        }
        String attribute_types_array = "";
        for (int i = 0; i < attributeTypes.length; ++i) {
            attribute_types_array = attribute_types_array + String.valueOf(attributeTypes[i]);
            if (i >= attributeTypes.length - 1) continue;
            attribute_types_array = attribute_types_array + ",";
        }
        String concatSql = "(" + types_array + ") AND ATTRIBUTE_TYPE IN (" + attribute_types_array + ")";
        DBResultSet rs = null;
        DBCursor sc = null;
        try {
            rs = SqlAttribute.sqlQuery(dbCon, SqlAttribute.getSnapshotEntitiesQuery, concatSql, null);
            while (rs.next()) {
                short attributeType;
                short systemType;
                int systemId_int;
                block49: {
                    String systemId;
                    ChangeDetectionElement cde;
                    String tableName;
                    systemId_int = rs.getInt(1);
                    systemType = rs.getShort(2);
                    attributeType = rs.getShort(3);
                    if (TRACE) {
                        traceLogger.entry(IRecordType.TYPE_INFO, methodName, "AD:" + systemId_int + ":" + systemType + ":" + attributeType);
                    }
                    if ((tableName = this.getTableName(systemType)) == null || (cde = (ChangeDetectionElement)hChangeDetection.get(tableName)) == null) continue;
                    if (this.isGroupType(systemType)) {
                        systemId = String.valueOf(systemId_int);
                        Vector<String> v = new Vector<String>();
                        v.add(cde.idColumnInfo.getName());
                        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
                        htWhereClause.put(groupidCI, systemId);
                        Class<?> helperClass = Class.forName(cde.className.equals("org.eclipse.aperi.infrastructure.database.objects.Host") ? "org.eclipse.aperi.infrastructure.database.objects.StatComputer" : cde.className);
                        Method getCursorMethod = helperClass.getDeclaredMethod("getCursor", DBConnection.class, Hashtable.class, Vector.class);
                        sc = (DBCursor)getCursorMethod.invoke(helperClass, dbCon, htWhereClause, v);
                        while (sc.next()) {
                            String aId;
                            block47: {
                                Object[] entityValue;
                                Object[] attribs = sc.getAttribute(v);
                                if (TRACE) {
                                    traceLogger.entry(IRecordType.TYPE_INFO, methodName, "attribute returned is " + attribs[0]);
                                }
                                if ((entityValue = this.getEntityAttribute(dbCon, cde.idColumnInfo, cde.attributeColumnInfo, cde.className, aId = attribs[0].toString())) == null) continue;
                                try {
                                    ChangeDetection.operateSnapEntityAttribute(dbCon, cde.className, "insert", cde.idColumnInfo, cde.attributeColumnInfo, aId, entityValue);
                                }
                                catch (Exception e2) {
                                    if (!TRACE) break block47;
                                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e2);
                                }
                            }
                            try {
                                this.startAssociatedEntityAttribute(dbCon, tableName, aId);
                            }
                            catch (Exception e2) {
                                if (!TRACE) continue;
                                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e2);
                            }
                        }
                    } else if (systemId_int != -1) {
                        systemId = String.valueOf(systemId_int);
                        Object[] entityValue = this.getEntityAttribute(dbCon, cde.idColumnInfo, cde.attributeColumnInfo, cde.className, systemId = this.subWwnForId(dbCon, tableName, systemId));
                        if (entityValue != null) {
                            block48: {
                                try {
                                    ChangeDetection.operateSnapEntityAttribute(dbCon, cde.className, "insert", cde.idColumnInfo, cde.attributeColumnInfo, systemId, entityValue);
                                }
                                catch (Exception e1) {
                                    if (!TRACE) break block48;
                                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e1);
                                }
                            }
                            try {
                                this.startAssociatedEntityAttribute(dbCon, tableName, systemId);
                            }
                            catch (Exception e1) {
                                if (!TRACE) break block49;
                                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e1);
                            }
                        }
                    } else {
                        Vector<String> v = new Vector<String>();
                        v.add(cde.idColumnInfo.getName());
                        Class<?> helperClass = Class.forName(cde.className);
                        Method getCursorMethod = helperClass.getDeclaredMethod("getCursor", DBConnection.class, Hashtable.class, Vector.class);
                        sc = (DBCursor)getCursorMethod.invoke(helperClass, dbCon, null, v);
                        while (sc.next()) {
                            String aId;
                            block50: {
                                Object[] entityValue;
                                Object[] attribs = sc.getAttribute(v);
                                if (TRACE) {
                                    traceLogger.entry(IRecordType.TYPE_INFO, methodName, "attribute returned is " + attribs[0]);
                                }
                                if ((entityValue = this.getEntityAttribute(dbCon, cde.idColumnInfo, cde.attributeColumnInfo, cde.className, aId = attribs[0].toString())) == null) continue;
                                try {
                                    ChangeDetection.operateSnapEntityAttribute(dbCon, cde.className, "insert", cde.idColumnInfo, cde.attributeColumnInfo, aId, entityValue);
                                }
                                catch (Exception e2) {
                                    if (!TRACE) break block50;
                                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e2);
                                }
                            }
                            try {
                                this.startAssociatedEntityAttribute(dbCon, tableName, aId);
                            }
                            catch (Exception e2) {
                                if (!TRACE) continue;
                                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e2);
                            }
                        }
                    }
                }
                Vector<ColumnInfo> v1 = new Vector<ColumnInfo>();
                Vector<String> v2 = new Vector<String>();
                v1.add(Attribute.getColumnInfo("RESOURCE_ID"));
                v2.add(String.valueOf(systemId_int));
                v1.add(Attribute.getColumnInfo("RESOURCE_TYPE"));
                v2.add(String.valueOf(systemType));
                v1.add(Attribute.getColumnInfo("ATTRIBUTE_TYPE"));
                v2.add(String.valueOf(attributeType));
                Hashtable params = ComplexQuery.generateHashtable(v1, v2);
                int rc = SqlAttribute.sqlUpdate(dbCon, SqlAttribute.updateSnapshotted, params);
                dbCon.commit();
            }
        }
        catch (Exception e) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e);
            }
        }
        finally {
            block53: {
                block52: {
                    try {
                        if (rs != null) {
                            rs.getStatement().close();
                        }
                    }
                    catch (Exception e) {
                        if (!TRACE) break block52;
                        traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e);
                    }
                }
                try {
                    if (sc != null) {
                        sc.close();
                    }
                }
                catch (Exception e) {
                    if (!TRACE) break block53;
                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e);
                }
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
    }

    private void stopEntityAttribute(DBConnection dbCon, ColumnInfo idColumnInfo, ColumnInfo[] attributeColumnInfo, int resourceType, int attributeType, String className, String systemId, String systemId_int, String processId) throws SQLException {
        String methodName = "stopEntityAttribute";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
        }
        Object[] entityValue = this.getEntityAttribute(dbCon, idColumnInfo, attributeColumnInfo, className, systemId);
        Object[] snap_entity_val = this.getSnapEntityAttribute(dbCon, idColumnInfo, attributeColumnInfo, resourceType, attributeType, entityValue, className, systemId);
        boolean update = false;
        for (int i = 0; entityValue != null && snap_entity_val != null && i < entityValue.length; ++i) {
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_INFO, methodName, "snap_entity_val is " + snap_entity_val);
            }
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_INFO, methodName, "entityValue is " + entityValue);
            }
            if (snap_entity_val[i] != null && entityValue[i] != null && !snap_entity_val[i].equals(entityValue[i])) {
                update = true;
                Hashtable<String, Object> oldValues = new Hashtable<String, Object>();
                oldValues.put(attributeColumnInfo[i].getName(), snap_entity_val[i]);
                Hashtable<String, Object> newValues = new Hashtable<String, Object>();
                newValues.put(attributeColumnInfo[i].getName(), entityValue[i]);
                if (TRACE) {
                    traceLogger.entry(IRecordType.TYPE_INFO, methodName, className + ":" + systemId_int + ":" + attributeColumnInfo[i].getName() + ":" + snap_entity_val[i] + ":" + entityValue[i]);
                }
                String tableName = this.deNormalizeType(attributeColumnInfo[i].getTableName());
                if (iems == null) continue;
                iems.handleDevicePropertyChange(processId, tableName, systemId_int, oldValues, newValues);
                continue;
            }
            if (!(snap_entity_val[i] == null ^ entityValue[i] == null)) continue;
            update = true;
        }
        if (update) {
            ChangeDetection.operateSnapEntityAttribute(dbCon, className, "update", idColumnInfo, attributeColumnInfo, systemId, entityValue);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
    }

    public void complete(Map modifiedEntries) {
    }

    public void complete(DBConnection dbCon, Map modifiedEntries, String processId) {
        String methodName;
        block7: {
            methodName = "detectChangeinAttributes";
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
            }
            this.vrtu.processView(modifiedEntries);
            try {
                Iterator e = modifiedEntries.keySet().iterator();
                while (e.hasNext()) {
                    String systemType;
                    String oldSystemType = systemType = (String)e.next();
                    ChangeDetectionElement cde = (ChangeDetectionElement)hChangeDetection.get(systemType = this.normalizeType(systemType));
                    if (cde == null) continue;
                    List systemIdVec = (List)modifiedEntries.get(oldSystemType);
                    for (int i = 0; i < systemIdVec.size(); ++i) {
                        String systemId_int = (String)systemIdVec.get(i);
                        String systemId = this.subWwnForId(dbCon, systemType, systemId_int);
                        if (TRACE) {
                            traceLogger.entry(IRecordType.TYPE_INFO, methodName, systemType + ":" + systemId);
                        }
                        this.stopEntityAttribute(dbCon, cde.idColumnInfo, cde.attributeColumnInfo, cde.resourceType, cde.attributeType, cde.className, systemId, systemId_int, processId);
                    }
                }
            }
            catch (Exception e) {
                if (!TRACE) break block7;
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e);
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String subWwnForId(DBConnection dbCon, String tableName, String id) {
        String methodName = "subWwnForId";
        String ret = id;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
        }
        if (tableName.equals("T_RES_FABRIC") || tableName.equals("T_RES_SWITCH")) {
            Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
            Vector<String> v = new Vector<String>();
            boolean isFabric = tableName.equals("T_RES_FABRIC");
            htWhereClause.put(isFabric ? Fabric.getColumnInfo("FABRIC_ID") : Switch.getColumnInfo("SWITCH_ID"), id);
            v.add(isFabric ? "FABRIC_WWN" : "SWITCH_WWN");
            DBCursor dcs = null;
            try {
                DBCursor dBCursor = dcs = isFabric ? Fabric.getCursor(dbCon, htWhereClause, v) : Switch.getCursor(dbCon, htWhereClause, v);
                if (dcs.next()) {
                    ret = dcs.getAttribute(v)[0].toString();
                }
            }
            catch (Exception e) {
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e);
            }
            finally {
                try {
                    dcs.close();
                }
                catch (Exception e1) {
                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, methodName, e1);
                }
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
        return ret;
    }

    public void cancel() {
        String methodName = "cancel";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, methodName);
        }
        this.tokenid = -1;
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, methodName);
        }
    }

    static {
        iems = (IEventMonitorService)Activator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        hChangeDetection = new Hashtable();
        hChangeDetection.put("T_RES_STORAGE_SUBSYSTEM", new ChangeDetectionElement(StorageSubsystem.getColumnInfo("SUBSYSTEM_ID"), new ColumnInfo[]{StorageSubsystem.getColumnInfo("CACHE"), StorageSubsystem.getColumnInfo("CODE_LEVEL"), StorageSubsystem.getColumnInfo("ALLOCATED_CAPACITY"), StorageSubsystem.getColumnInfo("AVAILABLE_CAPACITY"), StorageSubsystem.getColumnInfo("BACKEND_STORAGE_CAPACITY"), StorageSubsystem.getColumnInfo("OPERATIONAL_STATUS"), StorageSubsystem.getColumnInfo("DETECTABLE")}, 78, 81, "org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem"));
        hChangeDetection.put("T_RES_STORAGE_POOL", new ChangeDetectionElement(StoragePool.getColumnInfo("POOL_ID"), new ColumnInfo[]{StoragePool.getColumnInfo("TOTAL_AVAILABLE_SPACE"), StoragePool.getColumnInfo("CAPACITY"), StoragePool.getColumnInfo("OPERATIONAL_STATUS"), StoragePool.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.StoragePool"));
        hChangeDetection.put("T_RES_PHYSICAL_VOLUME", new ChangeDetectionElement(PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID"), new ColumnInfo[]{PhysicalVolume.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume"));
        hChangeDetection.put("T_RES_STORAGE_VOLUME", new ChangeDetectionElement(StorageVolume.getColumnInfo("SVID"), new ColumnInfo[]{StorageVolume.getColumnInfo("CAPACITY"), StorageVolume.getColumnInfo("OPERATIONAL_STATUS"), StorageVolume.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.StorageVolume"));
        hChangeDetection.put("T_RES_BACKEND_CONTROLLER", new ChangeDetectionElement(BackendController.getColumnInfo("BACKEND_CONTROLLER_ID"), new ColumnInfo[]{BackendController.getColumnInfo("OPERATIONAL_STATUS")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.BackendController"));
        hChangeDetection.put("T_RES_FABRIC", new ChangeDetectionElement(Fabric.getColumnInfo("FABRIC_WWN"), new ColumnInfo[]{Fabric.getColumnInfo("ACTIVE"), Fabric.getColumnInfo("DETECTABLE"), Fabric.getColumnInfo("OPERATIONAL_STATUS")}, 114, 114, "org.eclipse.aperi.infrastructure.database.objects.Fabric"));
        hChangeDetection.put("T_RES_FABRIC2SWITCH", new ChangeDetectionElement(Fabric2switch.getColumnInfo("FABRIC2SWITCH_ID"), new ColumnInfo[]{Fabric2switch.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Fabric2switch"));
        hChangeDetection.put("T_VIEW_PORT2PORT2FABRIC", new ChangeDetectionElement(Port2port2fabric.getColumnInfo("PORT2PORT_ID"), new ColumnInfo[]{Port2port2fabric.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Port2port2fabric"));
        hChangeDetection.put("T_VIEW_PORT2PARENT", new ChangeDetectionElement(Port2parent.getColumnInfo("PORT_ID"), new ColumnInfo[]{Port2parent.getColumnInfo("OPERATIONAL_STATUS"), Port2parent.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Port2parent"));
        hChangeDetection.put("T_RES_ZONE", new ChangeDetectionElement(Zone.getColumnInfo("ZONE_ID"), new ColumnInfo[]{Zone.getColumnInfo("ACTIVE")}, 127, 114, "org.eclipse.aperi.infrastructure.database.objects.Zone"));
        hChangeDetection.put("T_RES_ZSET", new ChangeDetectionElement(Zset.getColumnInfo("ZSET_ID"), new ColumnInfo[]{Zset.getColumnInfo("ACTIVE")}, 126, 114, "org.eclipse.aperi.infrastructure.database.objects.Zset"));
        hChangeDetection.put("T_RES_SWITCH", new ChangeDetectionElement(Switch.getColumnInfo("SWITCH_WWN"), new ColumnInfo[]{Switch.getColumnInfo("DETECTABLE"), Switch.getColumnInfo("OPERATIONAL_STATUS"), Switch.getColumnInfo("VERSION")}, 121, 121, "org.eclipse.aperi.infrastructure.database.objects.Switch"));
        hChangeDetection.put("T_RES_SWITCH_BLADE", new ChangeDetectionElement(SwitchBlade.getColumnInfo("SWITCH_BLADE_ID"), new ColumnInfo[]{SwitchBlade.getColumnInfo("DETECTABLE"), SwitchBlade.getColumnInfo("OPERATIONAL_STATUS")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.SwitchBlade"));
        hChangeDetection.put("T_RES_SWITCH2PORT", new ChangeDetectionElement(Switch2port.getColumnInfo("SWITCH2PORT_ID"), new ColumnInfo[]{Switch2port.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Switch2port"));
        hChangeDetection.put("T_RES_PE2NODE", new ChangeDetectionElement(Pe2node.getColumnInfo("PE2NODE_ID"), new ColumnInfo[]{Pe2node.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Pe2node"));
        hChangeDetection.put("T_RES_PHY_PE", new ChangeDetectionElement(PhyPe.getColumnInfo("PHY_PE_ID"), new ColumnInfo[]{PhyPe.getColumnInfo("DETECTABLE"), PhyPe.getColumnInfo("FIRMWARE_REVISION")}, 129, 129, "org.eclipse.aperi.infrastructure.database.objects.PhyPe"));
        hChangeDetection.put("T_RES_NODE", new ChangeDetectionElement(Node.getColumnInfo("NODE_ID"), new ColumnInfo[]{Node.getColumnInfo("DETECTABLE"), Node.getColumnInfo("OPERATIONAL_STATUS")}, 138, 129, "org.eclipse.aperi.infrastructure.database.objects.Node"));
        hChangeDetection.put("T_RES_HOST", new ChangeDetectionElement(Host.getColumnInfo("COMPUTER_ID"), new ColumnInfo[]{Host.getColumnInfo("DETECTABLE"), Host.getColumnInfo("OPERATIONAL_STATUS")}, 1, 26, "org.eclipse.aperi.infrastructure.database.objects.Host"));
        hChangeDetection.put("T_RES_HBA", new ChangeDetectionElement(Hba.getColumnInfo("HBA_ID"), new ColumnInfo[]{Hba.getColumnInfo("DETECTABLE"), Hba.getColumnInfo("FIRMWARE_VERSION"), Hba.getColumnInfo("DRIVER_VERSION"), Hba.getColumnInfo("OPERATIONAL_STATUS")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Hba"));
        hChangeDetection.put("T_VIEW_NODE2COMPUTER", new ChangeDetectionElement(Node2computer.getColumnInfo("NODE2HBA_ID"), new ColumnInfo[]{Node2computer.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Node2computer"));
        hChangeDetection.put("T_RES_TAPE_LIBRARY", new ChangeDetectionElement(TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"), new ColumnInfo[]{TapeLibrary.getColumnInfo("DETECTABLE"), TapeLibrary.getColumnInfo("OPERATIONAL_STATUS")}, 134, 81, "org.eclipse.aperi.infrastructure.database.objects.TapeLibrary"));
        hChangeDetection.put("T_RES_TAPE_DRIVE", new ChangeDetectionElement(TapeDrive.getColumnInfo("TAPE_DRIVE_ID"), new ColumnInfo[]{TapeDrive.getColumnInfo("DETECTABLE"), TapeDrive.getColumnInfo("NEEDS_CLEANING"), TapeDrive.getColumnInfo("FIRMWARE_VERSION"), TapeDrive.getColumnInfo("OPERATIONAL_STATUS")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.TapeDrive"));
        hChangeDetection.put("T_RES_TAPE_MEDIA_CHANGER", new ChangeDetectionElement(TapeMediaChanger.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), new ColumnInfo[]{TapeMediaChanger.getColumnInfo("DETECTABLE"), TapeMediaChanger.getColumnInfo("FIRMWARE_VERSION"), TapeMediaChanger.getColumnInfo("OPERATIONAL_STATUS")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger"));
        assocEntity = new Hashtable();
        Vector<AssociatedEntityElement> v1 = new Vector<AssociatedEntityElement>();
        v1.add(new AssociatedEntityElement("T_RES_STORAGE_VOLUME", StorageVolume.getColumnInfo("SUBSYSTEM_ID")));
        v1.add(new AssociatedEntityElement("T_RES_STORAGE_POOL", StoragePool.getColumnInfo("SUBSYSTEM_ID")));
        v1.add(new AssociatedEntityElement("T_VIEW_PORT2PARENT", Port2parent.getColumnInfo("SUBSYSTEM_ID")));
        v1.add(new AssociatedEntityElement("T_RES_BACKEND_CONTROLLER", BackendController.getColumnInfo("OWNING_SUBSYSTEM_ID")));
        v1.add(new AssociatedEntityElement("T_RES_PHYSICAL_VOLUME", PhysicalVolume.getColumnInfo("SUBSYSTEM_ID")));
        assocEntity.put("T_RES_STORAGE_SUBSYSTEM", v1);
        Vector<AssociatedEntityElement> v2 = new Vector<AssociatedEntityElement>();
        v2.add(new AssociatedEntityElement("T_RES_SWITCH_BLADE", SwitchBlade.getColumnInfo("SWITCH_WWN")));
        v2.add(new AssociatedEntityElement("T_RES_SWITCH2PORT", Switch2port.getColumnInfo("SWITCH_WWN")));
        v2.add(new AssociatedEntityElement("T_VIEW_PORT2PARENT", Port2parent.getColumnInfo("SWITCH_WWN")));
        assocEntity.put("T_RES_SWITCH", v2);
        Vector<AssociatedEntityElement> v3 = new Vector<AssociatedEntityElement>();
        v3.add(new AssociatedEntityElement("T_RES_HBA", Hba.getColumnInfo("HOST_ID")));
        v3.add(new AssociatedEntityElement("T_VIEW_NODE2COMPUTER", Node2computer.getColumnInfo("HOST_ID")));
        v3.add(new AssociatedEntityElement("T_VIEW_PORT2PARENT", Port2parent.getColumnInfo("HOST_ID")));
        assocEntity.put("T_RES_HOST", v3);
        Vector<AssociatedEntityElement> v4 = new Vector<AssociatedEntityElement>();
        v4.add(new AssociatedEntityElement("T_RES_TAPE_DRIVE", TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")));
        v4.add(new AssociatedEntityElement("T_RES_TAPE_MEDIA_CHANGER", TapeMediaChanger.getColumnInfo("TAPE_LIBRARY_ID")));
        assocEntity.put("T_RES_TAPE_LIBRARY", v4);
        Vector<AssociatedEntityElement> v5 = new Vector<AssociatedEntityElement>();
        v5.add(new AssociatedEntityElement("T_RES_FABRIC2SWITCH", Fabric2switch.getColumnInfo("FABRIC_WWN")));
        v5.add(new AssociatedEntityElement("T_VIEW_PORT2PORT2FABRIC", Port2port2fabric.getColumnInfo("FABRIC_WWN")));
        assocEntity.put("T_RES_FABRIC", v5);
        Vector<AssociatedEntityElement> v6 = new Vector<AssociatedEntityElement>();
        v6.add(new AssociatedEntityElement("T_RES_PE2NODE", Pe2node.getColumnInfo("PHY_PE_ID")));
        v6.add(new AssociatedEntityElement("T_VIEW_PORT2PARENT", Port2parent.getColumnInfo("PHY_PE_ID")));
        assocEntity.put("T_RES_PHY_PE", v6);
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }
}

