/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.snapshot;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.ParameterizedSql;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespaceSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimomSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.SnapshotMetadata;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSnapshotMetadataTable;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotUtil;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotCimom {
    private static String REGISTERED_CIMOM_TABLE = "T_RES_REGISTERED_CIMOM";
    private static String CIMOM2NAMESPACE_TABLE = "T_RES_CIMOM2NAMESPACE";
    private static ILogger traceLogger = null;
    private static String className = SnapshotCimom.class.getName();
    private static boolean TRACE = false;

    static int create(DBConnection sqlConn, int cimomId) throws Exception {
        String methodName = "create(" + cimomId + ")";
        int snapshotId = -1;
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        RegisteredCimom myCimom = null;
        DBCursor myCursor = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            htWhereClause.put(TResRegisteredCimomTable.getColumnInfo("REG_CIMOM_ID"), String.valueOf(cimomId));
            myCursor = RegisteredCimom.getCursor(sqlConn, htWhereClause, null);
            if (myCursor.next()) {
                myCimom = ((RegisteredCimom.RegisteredCimomCursor)myCursor).getAttributes();
            }
            if (myCimom == null) {
                Exception ex = new Exception("Bad CIMOM ID: " + cimomId);
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
                }
                throw ex;
            }
            snapshotId = AutoIdentifier.getIdentifier(9, 1);
            Timestamp currTs = CurrentTime.getTimestamp(sqlConn);
            SnapshotUtil.createSnapshotMetadata(sqlConn, snapshotId, currTs, cimomId, 3, true);
            SnapshotCimom.createRegisteredCimomSnapshot(sqlConn, myCimom, snapshotId, REGISTERED_CIMOM_TABLE);
            SnapshotCimom.createCimom2NamespaceSnapshot(sqlConn, myCimom, snapshotId, CIMOM2NAMESPACE_TABLE);
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
            int ex = snapshotId;
            return ex;
        }
        catch (SQLException sqlEx) {
            try {
                sqlConn.rollback();
            }
            catch (SQLException sqlEx1) {
                // empty catch block
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        finally {
            if (myCursor != null) {
                myCursor.close();
            }
        }
    }

    static void delete(DBConnection sqlConn, int snapshotId) throws Exception {
        String methodName = "delete(" + snapshotId + ")";
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            htWhereClause.put(TResCimom2namespaceSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            Cimom2namespaceSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.put(TResRegisteredCimomSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            RegisteredCimomSnapshot.deletes(sqlConn, htWhereClause);
            htWhereClause.put(TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(snapshotId));
            SnapshotMetadata.deletes(sqlConn, htWhereClause);
        }
        catch (SQLException sqlEx) {
            try {
                sqlConn.rollback();
            }
            catch (SQLException sqlEx1) {
                // empty catch block
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createRegisteredCimomSnapshot(DBConnection sqlConn, RegisteredCimom myCimom, int snapshotId, String tableName) throws SQLException {
        String methodName = "createRegisteredCimomSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(3, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResRegisteredCimomTable.getColumnInfo("REG_CIMOM_ID"), String.valueOf(myCimom.getRegCimomId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private static void createCimom2NamespaceSnapshot(DBConnection sqlConn, RegisteredCimom myCimom, int snapshotId, String tableName) throws SQLException {
        String methodName = "createCimom2NamespaceSnapshot(" + snapshotId + ", " + tableName + ")";
        Hashtable<String, String> tokenParams = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> sqlParams = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            String snapCreateSqlStmt = SnapshotUtil.getSnapshotCreationStmt(3, tableName);
            if (snapCreateSqlStmt != null) {
                tokenParams.put("<<SNAPSHOT_ID>>", String.valueOf(snapshotId));
                sqlParams.put(TResCimom2namespaceTable.getColumnInfo("CIMOM_ID"), String.valueOf(myCimom.getRegCimomId()));
                ParameterizedSql.sqlUpdate(sqlConn, snapCreateSqlStmt, tokenParams, sqlParams);
            }
        }
        catch (SQLException sqlEx) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, sqlEx);
            }
            throw sqlEx;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }
}

