/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.snapshot;

import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.SnapshotMetadata;
import org.eclipse.aperi.infrastructure.database.sql.SqlSnapshotMetadata;
import org.eclipse.aperi.infrastructure.database.tables.TResSnapshotMetadataTable;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotCimom;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotStorageSubsystem;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotSwitch;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotService {
    public static final int TYPE_STORAGE_SUBSYSTEM = 1;
    public static final int TYPE_SWITCH = 2;
    public static final int TYPE_CIMOM = 3;
    public static final int TYPE_HOST = 4;
    public static final int TYPE_FABRIC = 5;
    public static final int CONFIG_DB_SNAPSHOT = 1;
    public static final int REFERENCE_SNAPSHOT = 2;
    private static ILogger traceLogger = null;
    private static String className = SnapshotService.class.getName();
    private static boolean TRACE = false;

    public static int createSnapshot(int systemId, int systemType) throws Exception {
        String methodName = "createSnapshot (" + systemId + ", " + systemType + ")";
        DBConnection sqlConn = null;
        int snapshotId = -1;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            sqlConn = (DBConnection)ds.getPooledConnection();
            if (systemType == 1) {
                snapshotId = SnapshotStorageSubsystem.create(sqlConn, systemId);
            } else if (systemType == 2) {
                snapshotId = SnapshotSwitch.create(sqlConn, systemId);
            } else if (systemType == 3) {
                snapshotId = SnapshotCimom.create(sqlConn, systemId);
            } else {
                Exception ex = new Exception("System type " + systemType + " not supported by Snapshot Service");
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
                }
                throw ex;
            }
            sqlConn.commit();
        }
        catch (Exception dbConnEx) {
            if (sqlConn != null) {
                try {
                    sqlConn.rollback();
                    sqlConn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, dbConnEx);
            }
            throw dbConnEx;
        }
        finally {
            sqlConn.close();
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return snapshotId;
    }

    public static void deleteSnapshot(int snapshotId) throws Exception {
        String methodName = "deleteSnapshot(" + snapshotId + ")";
        DBConnection sqlConn = null;
        int systemId = -1;
        int systemType = -1;
        boolean rc = false;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            sqlConn = (DBConnection)ds.getPooledConnection();
            SnapshotMetadata snapshotMd = new SnapshotMetadata();
            snapshotMd.setSnapshotId(snapshotId);
            boolean snapshotExists = snapshotMd.retrieve(sqlConn);
            if (!snapshotExists) {
                Exception ex = new Exception("Snapshot ID " + snapshotId + " does not exist");
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
                }
                throw ex;
            }
            systemId = snapshotMd.getSystemId();
            systemType = snapshotMd.getSystemType();
            if (systemType == 1) {
                SnapshotStorageSubsystem.delete(sqlConn, snapshotId);
            } else if (systemType == 2) {
                SnapshotSwitch.delete(sqlConn, snapshotId);
            } else if (systemType == 3) {
                SnapshotCimom.delete(sqlConn, snapshotId);
            } else {
                throw new Exception("Internal error: System type " + systemType + " not supported by Snapshot Service");
            }
            sqlConn.commit();
        }
        catch (Exception dbConnEx) {
            if (sqlConn != null) {
                try {
                    sqlConn.rollback();
                    sqlConn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, dbConnEx);
            }
            throw dbConnEx;
        }
        finally {
            sqlConn.close();
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public static void deleteSystemSnapshots(int systemId, int systemType, Timestamp ts) throws Exception {
        String methodName = "deleteSystemSnapshots(" + systemId + ", " + systemType + ")";
        DBConnection sqlConn = null;
        DBCursor myCursor = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            sqlConn = (DBConnection)ds.getPooledConnection();
            if (systemType != 1 && systemType != 2 && systemType != 3) {
                Exception ex = new Exception("deleteSystemSnapshots: invalid system type - " + systemType);
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, ex);
                }
                throw ex;
            }
            Hashtable<ColumnInfo, Object> htWhereClause = new Hashtable<ColumnInfo, Object>();
            SnapshotMetadata snapshotMd = null;
            htWhereClause.put(TResSnapshotMetadataTable.getColumnInfo("SYSTEM_ID"), String.valueOf(systemId));
            htWhereClause.put(TResSnapshotMetadataTable.getColumnInfo("SYSTEM_TYPE"), String.valueOf(systemType));
            htWhereClause.put(TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_TYPE"), String.valueOf(1));
            if (ts != null) {
                ColumnInfo colTs = TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_TIME");
                colTs = colTs.addOperator("<");
                htWhereClause.put(colTs, ts);
            }
            myCursor = SnapshotMetadata.getCursor(sqlConn, htWhereClause, null);
            while (myCursor.next()) {
                snapshotMd = ((SnapshotMetadata.SnapshotMetadataCursor)myCursor).getAttributes();
                SnapshotService.deleteSnapshot(snapshotMd.getSnapshotId());
            }
        }
        catch (Exception dbConnEx) {
            if (sqlConn != null) {
                try {
                    sqlConn.rollback();
                    sqlConn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, dbConnEx);
            }
            throw dbConnEx;
        }
        finally {
            sqlConn.close();
            if (myCursor != null) {
                myCursor.close();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    public static Timestamp snapshotIdToTs(int snapshotId) throws Exception {
        String methodName = "snapshotIdToTs(" + snapshotId + ")";
        DBConnection sqlConn = null;
        Timestamp tsRc = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            sqlConn = (DBConnection)ds.getPooledConnection();
            SnapshotMetadata snapshotMd = new SnapshotMetadata();
            snapshotMd.setSnapshotId(snapshotId);
            boolean tupleExists = snapshotMd.retrieve(sqlConn);
            if (tupleExists) {
                tsRc = snapshotMd.getSnapshotTime();
            }
        }
        catch (Exception dbConnEx) {
            if (sqlConn != null) {
                try {
                    sqlConn.rollback();
                    sqlConn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, dbConnEx);
            }
            throw dbConnEx;
        }
        finally {
            sqlConn.close();
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return tsRc;
    }

    public static int tsToSnapshotId(int systemId, int systemType, Timestamp ts) throws Exception {
        String methodName = "tsToSnapshotId(" + systemId + ", " + systemType + ")";
        DBConnection sqlConn = null;
        DBResultSet dbrs = null;
        int rc = 0;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            sqlConn = (DBConnection)ds.getPooledConnection();
            Hashtable<ColumnInfo, Object> htParams = new Hashtable<ColumnInfo, Object>();
            htParams.put(TResSnapshotMetadataTable.getColumnInfo("SYSTEM_ID"), String.valueOf(systemId));
            htParams.put(TResSnapshotMetadataTable.getColumnInfo("SYSTEM_TYPE"), String.valueOf(systemType));
            if (ts == null) {
                dbrs = SqlSnapshotMetadata.sqlQuery(sqlConn, SqlSnapshotMetadata.mostRecentSystemSnapshot, htParams);
            } else {
                htParams.put(TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_TIME"), ts);
                dbrs = SqlSnapshotMetadata.sqlQuery(sqlConn, SqlSnapshotMetadata.mostRecentSystemSnapshotBeforeTimeT, htParams);
            }
            if (dbrs.next()) {
                rc = dbrs.getInt(1);
            }
        }
        catch (Exception dbConnEx) {
            if (sqlConn != null) {
                try {
                    sqlConn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, dbConnEx);
            }
            throw dbConnEx;
        }
        finally {
            sqlConn.close();
            if (dbrs != null) {
                dbrs.getStatement().close();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return rc;
    }

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }
}

