/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.mapping.BladeXmlToDBMapper;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.FcNodeXmlToDBMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class BladeXml2FcNodeIdXmlToDBMapper
extends DBAttributeMapper {
    private static final String NODENAME = "Node_Name";
    private static final String NODEFORMAT = "Node_Format";
    private static final String NODEBLADE = "Node_Blade";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "BladeXml2FcNodeIdXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public BladeXml2FcNodeIdXmlToDBMapper() {
        ColumnInfo nodeName = Node.getColumnInfo("NAME");
        nodeName.isPrimaryKey();
        nodeName.setReferencedColumn(nodeName);
        this.m_htAttribToMapperInfo.put(NODENAME.toLowerCase(), new MapperInfo(nodeName));
        ColumnInfo nodeFormat = Node.getColumnInfo("NAME_FORMAT");
        nodeFormat.isPrimaryKey();
        nodeFormat.setReferencedColumn(nodeFormat);
        this.m_htAttribToMapperInfo.put(NODEFORMAT.toLowerCase(), new MapperInfo(nodeFormat));
        ColumnInfo nodeBlade = Node.getColumnInfo("BLADE_ID");
        nodeBlade.setReferencedColumn(SwitchBlade.getColumnInfo("SWITCH_BLADE_ID"));
        this.m_htAttribToMapperInfo.put(NODEBLADE.toLowerCase(), new MapperInfo(nodeBlade));
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        String wwn = (String)htValues.get("ToUniqueIdXml");
        Hashtable<String, String> temp1 = new Hashtable<String, String>();
        FcNodeXmlToDBMapper nodeMapper = new FcNodeXmlToDBMapper();
        if (wwn == null) {
            SQLException e = new SQLException("Required field, ToUniqueIdXml, was not found to find node wwn");
            this.logException(this.myClassname, methodName, e, "");
            throw e;
        }
        temp1.put("UniqueIdXml", wwn);
        String blade = (String)htValues.get("FromUniqueIdXml");
        Hashtable<String, String> temp2 = new Hashtable<String, String>();
        if (blade == null) {
            SQLException e = new SQLException("Required field, FromUniqueIdXml, was not found to find controller (hba) wwn");
            this.logException(this.myClassname, methodName, e, "");
            throw e;
        }
        temp2.put("UniqueIdXml", blade);
        BladeXmlToDBMapper bladeMapper = new BladeXmlToDBMapper();
        MapperResult mr = this.persist(conn, nodeMapper, temp1, bladeMapper, temp2, scanID);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

