/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import com.ibm.log.Level;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DataConverter {
    private String classname = "org.eclipse.aperi.infrastructure.mapping.DataConverter.java";
    private ILogger myLogger = null;
    private final boolean useLogger = true;
    Hashtable m_simpleDataConversions = new Hashtable();
    Hashtable m_complexDataConversions = new Hashtable();
    Hashtable m_calculationDataConversions = new Hashtable();

    DataConverter() {
        this.myLogger = DBConstants.getLogger();
    }

    void addCalculationDataConversion(String xmlAttribute, String operator, String value) {
        this.m_calculationDataConversions.put(xmlAttribute.toLowerCase(), new OperatorAndValue(operator, value));
    }

    void addSimpleDataConversion(String xmlAttribute, Hashtable conversionTable) {
        this.m_simpleDataConversions.put(xmlAttribute.toLowerCase(), conversionTable);
    }

    void addSimpleDataConversion(String xmlAttribute, String conversionName) {
        this.m_simpleDataConversions.put(xmlAttribute.toLowerCase(), conversionName);
    }

    void addComplexDataConversion(String xmlAttribute, String regexString, int nthField) {
        this.m_complexDataConversions.put(xmlAttribute.toLowerCase(), new RegexAndValue(regexString, nthField));
    }

    void removeSimpleAndComplexDataConversion(String xmlAttribute) {
        String lcatt = xmlAttribute.toLowerCase();
        this.m_complexDataConversions.remove(lcatt);
        this.m_simpleDataConversions.remove(lcatt);
    }

    void removeCalculationDataConversion(String xmlAttribute) {
        this.m_calculationDataConversions.remove(xmlAttribute.toLowerCase());
    }

    void removeSimpleDataConversion(String xmlAttribute) {
        this.m_simpleDataConversions.remove(xmlAttribute.toLowerCase());
    }

    void removeComplexDataConversion(String xmlAttribute) {
        this.m_complexDataConversions.remove(xmlAttribute.toLowerCase());
    }

    void performDataConversion(Hashtable htValues) {
        String methodname = "performDataConversion(Hashtable htValues)";
        Hashtable<String, String> temp = new Hashtable<String, String>();
        Iterator xmlIterator = htValues.keySet().iterator();
        while (xmlIterator.hasNext()) {
            Object simpleConversion;
            String xmlTagName = (String)xmlIterator.next();
            String lcXmlTagName = xmlTagName.toLowerCase();
            String xmlValue = (String)htValues.get(xmlTagName);
            if (xmlValue == null) continue;
            String convertedValue = null;
            RegexAndValue rval = (RegexAndValue)this.m_complexDataConversions.get(lcXmlTagName);
            if (rval != null) {
                convertedValue = rval.getNthField(xmlValue);
                if (convertedValue != null && convertedValue.length() > 0) {
                    this.log(IRecordType.TYPE_INFO, methodname, "For xmlTag " + xmlTagName + ", converting \"" + xmlValue + "\" to \"" + convertedValue + "\"");
                    xmlValue = convertedValue;
                } else {
                    xmlIterator.remove();
                    this.log(IRecordType.TYPE_WARNING, methodname, "For xmlTag " + xmlTagName + ", \"" + xmlValue + "\" did not contain the appropriate token to get desired value.  This mapping will be removed from info to be persisted.");
                }
            }
            if ((simpleConversion = this.m_simpleDataConversions.get(lcXmlTagName)) != null) {
                if (simpleConversion instanceof Hashtable) {
                    convertedValue = (String)((Hashtable)simpleConversion).get(xmlValue.toLowerCase());
                    this.log(IRecordType.TYPE_INFO, methodname, "For xmlTag " + xmlTagName + ", converting \"" + xmlValue + "\" to \"" + convertedValue + "\"");
                } else {
                    convertedValue = DBConstants.getValueFromKey((String)simpleConversion, xmlValue.toLowerCase());
                    this.log(IRecordType.TYPE_INFO, methodname, "For xmlTag " + xmlTagName + ", converting \"" + xmlValue + "\" to \"" + convertedValue + "\"");
                }
                if (convertedValue == null) {
                    xmlIterator.remove();
                    this.log(IRecordType.TYPE_WARNING, methodname, "For xmlTag " + xmlTagName + ", \"" + xmlValue.toLowerCase() + "\" was not found in the specified lookup hashtable.  This mapping will be removed from info to be persisted.");
                }
            }
            if (convertedValue != null) {
                temp.put(xmlTagName, convertedValue);
                continue;
            }
            OperatorAndValue oval = (OperatorAndValue)this.m_calculationDataConversions.get(lcXmlTagName);
            if (oval == null) continue;
            convertedValue = oval.getCalculatedResultValue(xmlValue);
            if (convertedValue != null && convertedValue.length() > 0) {
                this.log(IRecordType.TYPE_INFO, methodname, "For xmlTag " + xmlTagName + ", calculated \"" + xmlValue + "\" to \"" + convertedValue + "\"");
                temp.put(xmlTagName, convertedValue);
                continue;
            }
            xmlIterator.remove();
            this.log(IRecordType.TYPE_WARNING, methodname, "For xmlTag " + xmlTagName + ", \"" + xmlValue + "\" did not contain the appropriate token to get desired value.  This mapping will be removed from info to be persisted.");
        }
        htValues.putAll(temp);
    }

    private void log(Level level, String methodname, String msg) {
        if (this.myLogger.isLogging()) {
            this.myLogger.text(level, this.classname, methodname, msg);
        } else {
            System.out.println(this.classname + "." + methodname + ":  " + msg);
        }
    }

    class OperatorAndValue {
        public long cValue;
        public String cOperator;

        OperatorAndValue(String pOperator, String pValue) {
            this.cValue = Long.parseLong(pValue);
            this.cOperator = pOperator;
        }

        public String getCalculatedResultValue(String pValue) {
            long pValueLong = Long.parseLong(pValue);
            if (this.cOperator.equals("+")) {
                return String.valueOf(pValueLong + this.cValue);
            }
            if (this.cOperator.equals("-")) {
                return String.valueOf(pValueLong - this.cValue);
            }
            if (this.cOperator.equals("*")) {
                return String.valueOf(pValueLong * this.cValue);
            }
            if (this.cOperator.equals("/")) {
                return String.valueOf(pValueLong / this.cValue);
            }
            return pValue;
        }
    }

    class RegexAndValue {
        int m_nthField;
        String m_regexString;
        boolean m_initialized;

        RegexAndValue(String Regex, int nthField) {
            if (Regex != null) {
                this.m_regexString = new String(Regex);
                this.m_nthField = nthField;
                this.m_initialized = true;
            } else {
                this.m_initialized = false;
            }
        }

        String getNthField(String value) {
            if (!this.m_initialized) {
                return null;
            }
            String[] splittedString = value.split(this.m_regexString);
            if (splittedString.length <= this.m_nthField - 1) {
                return null;
            }
            return splittedString[this.m_nthField - 1];
        }
    }
}

