/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class FcNodeXmlToDBMapper
extends DBAttributeMapper {
    private static final String INTERFACESTATUS = "Interface Status";
    private static final String CONSOLIDATEDSTATUS = "conStatus";
    private static final String PLATFORMTYPE = "Platform Type";
    private static final String RNIDTYPE = "RNID Type";
    private static final String SCSISUPPORT = "SCSI Support";
    private static final String MGMTTELNETADDRESS = "Management Telnet Address";
    private static final String MGMTSNMPADDRESS = "Management Snmp Address";
    private static final String MGMTURLADDRESS = "Management URL Address";
    private static final String NAMEFORMAT = "Name Format";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "FcNodeXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public FcNodeXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml", ":", 2);
        this.m_dataConverter.addSimpleDataConversion(PLATFORMTYPE.toLowerCase(), "Node_Type");
        this.m_dataConverter.addSimpleDataConversion(RNIDTYPE.toLowerCase(), "Node_Type");
        this.m_htAttribToMapperInfo.put(SCSISUPPORT.toLowerCase(), new MapperInfo(Node.getColumnInfo("SCSI_SUPPORT")));
        this.m_htAttribToMapperInfo.put(PLATFORMTYPE.toLowerCase(), new MapperInfo(Node.getColumnInfo("PLATFORM_TYPE")));
        this.m_htAttribToMapperInfo.put(RNIDTYPE.toLowerCase(), new MapperInfo(Node.getColumnInfo("RNID_TYPE")));
        this.m_htAttribToMapperInfo.put("name", new MapperInfo(Node.getColumnInfo("OTHER_NAME")));
        this.m_htAttribToMapperInfo.put(MGMTURLADDRESS.toLowerCase(), new MapperInfo(Node.getColumnInfo("MGMT_URL_ADDR")));
        this.m_htAttribToMapperInfo.put(MGMTTELNETADDRESS.toLowerCase(), new MapperInfo(Node.getColumnInfo("MGMT_TEL_ADDR")));
        this.m_htAttribToMapperInfo.put(MGMTSNMPADDRESS.toLowerCase(), new MapperInfo(Node.getColumnInfo("MGMT_SNMP_ADDR")));
        this.m_htAttribToMapperInfo.put(INTERFACESTATUS.toLowerCase(), new MapperInfo(Node.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(CONSOLIDATEDSTATUS.toLowerCase(), new MapperInfo(Node.getColumnInfo("CONSOLIDATED_STATUS")));
        ColumnInfo nodeName = Node.getColumnInfo("NAME");
        nodeName.setIsPrimaryKey();
        MapperInfo nodeNameMapperInfo = new MapperInfo(nodeName);
        ColumnInfo nodeId = Node.getColumnInfo("NODE_ID");
        nodeId.setAutoGenerated();
        nodeNameMapperInfo.setDerivedColumn(nodeId);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), nodeNameMapperInfo);
        ColumnInfo nameFormat = Node.getColumnInfo("NAME_FORMAT");
        nameFormat.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put(NAMEFORMAT.toLowerCase(), new MapperInfo(nameFormat));
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String url;
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        String sniaVal = (String)htValues.get(INTERFACESTATUS);
        if (sniaVal != null) {
            String[] smisValArr = this.convertSNIAOPStatToBitArrValue(sniaVal);
            htValues.put(INTERFACESTATUS, smisValArr[0]);
            Vector<String> vOpStat = new Vector<String>();
            vOpStat.add(smisValArr[1]);
            String conState = DBConstants.convertOperationalstatusArrayToConsolidatedValue(vOpStat);
            if (conState != null) {
                htValues.put(CONSOLIDATEDSTATUS, conState);
            }
        }
        if (htValues.get(NAMEFORMAT.toLowerCase()) == null) {
            String format = DBConstants.getValueFromKey("Name_Format", "FC_WWN");
            htValues.put(NAMEFORMAT.toLowerCase(), format);
        }
        if ((url = (String)htValues.get(MGMTURLADDRESS)) != null && url.indexOf("0.0.0.0") != -1) {
            htValues.remove(MGMTURLADDRESS);
        }
        MapperResult mr = super.persist(conn, htValues, scanID);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

