/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.mapping.AttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.DBTableMapper;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class MapperManager {
    public static final String CIMOM_SOURCE = "CIMOM";
    public static final String LEGACY_FABRIC_SOURCE = "LFABRIC";
    public static final String SANMXML_10 = "SANXML_1_0";
    public static final String SMIS_10 = "SMIS_1_0";
    public static final String SLP_10 = "SLP_1_0";
    public static final String TPCDB_10 = "DBMapper";
    private static final String mapperPkg = "org.eclipse.aperi.infrastructure.mapping";
    private static ILogger myLogger = DBConstants.getLogger();
    private static String myClassname = "org.eclipse.aperi.infrastructure.mapping.MapperManager.java";
    private static Hashtable mapperInstancesCache = new Hashtable();
    public static final String SMIS1_0 = "SMIS";
    public static final String SANMXML1_0 = "";
    public static final String SLP1_0 = "SLP";
    public static final String CIMOM = "CIMOM";
    public static final String TPCDB1_0 = "DBMapper";

    private MapperManager() {
    }

    public static AttributeMapper retrieveMapper(String infoSource, String objectName, String spec, String destination, Hashtable params) {
        String methodName = "retrieveMapper( String infoSource, String objectName, String spec, String destination, Hashtable params )";
        AttributeMapper mapper = null;
        String originalRequest = infoSource + spec + objectName + "To" + destination;
        String name = null;
        while (mapper == null && objectName != null) {
            name = infoSource + spec + objectName + "To" + destination;
            if (myLogger.isLogging()) {
                myLogger.text(IRecordType.TYPE_INFO, myClassname, methodName, "Searching for mapper named \"" + name + "\"");
            }
            if ((mapper = MapperManager.classRetrieval(name)) == null) {
                name = infoSource + objectName + "To" + destination;
                if (myLogger.isLogging()) {
                    myLogger.text(IRecordType.TYPE_INFO, myClassname, methodName, "Searching for mapper named \"" + name + "\"");
                }
                mapper = MapperManager.classRetrieval(name);
            }
            if (mapper != null) continue;
            objectName = DBTableMapper.getLookup(objectName, params);
        }
        if (mapper != null) {
            mapperInstancesCache.put("org.eclipse.aperi.infrastructure.mapping." + originalRequest, mapper);
            mapperInstancesCache.put("org.eclipse.aperi.infrastructure.mapping." + name, mapper);
        }
        return mapper;
    }

    private static AttributeMapper classRetrieval(String classname) {
        Class<?> c = null;
        String methodName = "classRetrieval( String classname )";
        String fullMapperName = "org.eclipse.aperi.infrastructure.mapping." + classname;
        Object obj = mapperInstancesCache.get(fullMapperName);
        if (obj == null) {
            try {
                c = Class.forName(fullMapperName);
            }
            catch (ClassNotFoundException e) {
                if (myLogger.isLogging()) {
                    myLogger.exception(IRecordType.TYPE_ERROR, myClassname, methodName, e, "Could not find class " + fullMapperName + ".");
                }
                c = null;
            }
            catch (ExceptionInInitializerError e) {
                if (myLogger.isLogging()) {
                    myLogger.exception(IRecordType.TYPE_ERROR, myClassname, methodName, e, "Class " + fullMapperName + " failed initialization and thus can not be used.");
                }
                c = null;
            }
            catch (NoClassDefFoundError e) {
                if (myLogger.isLogging()) {
                    myLogger.exception(IRecordType.TYPE_ERROR, myClassname, methodName, e, "Runtime error: Class definition for " + fullMapperName + " once existed, but can no longer be found.");
                }
                c = null;
            }
            if (c != null) {
                try {
                    obj = c.newInstance();
                    if (!(obj instanceof AttributeMapper)) {
                        if (myLogger.isLogging()) {
                            myLogger.text(IRecordType.TYPE_ERROR, myClassname, methodName, "Class matching requested " + fullMapperName + " was found, but did not extend AttributeMapper and is thus invalid.");
                        }
                        obj = null;
                    }
                }
                catch (InstantiationException e) {
                    if (myLogger.isLogging()) {
                        myLogger.exception(IRecordType.TYPE_ERROR, myClassname, methodName, e, "Can not instantiate class " + fullMapperName);
                    }
                    obj = null;
                }
                catch (IllegalAccessException e) {
                    if (myLogger.isLogging()) {
                        myLogger.exception(IRecordType.TYPE_ERROR, myClassname, methodName, e, "Requested class, " + fullMapperName + ", is not accessible");
                    }
                    obj = null;
                }
            }
        }
        return (AttributeMapper)obj;
    }

    public static AttributeMapper getMapper(String from, String to, String cimEntity, Hashtable params) {
        AttributeMapper mapper = null;
        String mapperName = from + cimEntity + "To" + to;
        String originalCimEntity = cimEntity;
        mapper = MapperManager.retrieveAttributeMapperClass(mapperPkg, mapperName);
        if (mapper == null) {
            String genMapperName = from + MapperManager.extractGenericName(cimEntity) + "To" + to;
            mapper = MapperManager.retrieveAttributeMapperClass(mapperPkg, genMapperName);
        }
        if (mapper == null && (cimEntity = DBTableMapper.getLookup(cimEntity, params)) != null) {
            mapperName = from + cimEntity + "To" + to;
            mapper = MapperManager.retrieveAttributeMapperClass(mapperPkg, mapperName);
        }
        if (mapperName != null && mapper != null) {
            mapperInstancesCache.put("org.eclipse.aperi.infrastructure.mapping." + mapperName, mapper);
            mapperInstancesCache.put("org.eclipse.aperi.infrastructure.mapping." + from + originalCimEntity + "To" + to, mapper);
        }
        return mapper;
    }

    private static String extractGenericName(String aCIMName) {
        return aCIMName.substring(aCIMName.indexOf("_") + 1);
    }

    private static AttributeMapper retrieveAttributeMapperClass(String mapperPkg, String mapperName) {
        Class<?> c = null;
        Object obj = null;
        String mapperPkgName = mapperPkg + "." + mapperName;
        obj = mapperInstancesCache.get(mapperPkgName);
        if (obj == null) {
            try {
                c = Class.forName(mapperPkgName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                c = null;
            }
            catch (NoClassDefFoundError ex) {
                ex.printStackTrace();
            }
            catch (ExceptionInInitializerError er) {
                er.printStackTrace();
            }
            if (c != null) {
                try {
                    obj = c.newInstance();
                    if (!(obj instanceof AttributeMapper)) {
                        System.err.println("ERROR - " + mapperPkgName + " is not an AttributeMapper subclass");
                        obj = null;
                    }
                }
                catch (InstantiationException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return obj;
    }

    public static boolean testMappers(boolean outputMappings) {
        boolean passed = true;
        String path = System.getProperty("user.dir");
        File mapperDirectory = new File(path + "\\com\\ibm\\tpc\\infrastructure\\mapping\\");
        String[] mapperFiles = mapperDirectory.list(new mapperTestFileFilter());
        for (int i = 0; i < mapperFiles.length; ++i) {
            String mapperName = mapperFiles[i].replaceFirst(".java", SANMXML1_0);
            AttributeMapper am = MapperManager.classRetrieval(mapperName);
            System.out.println("\tFound Mapper: " + mapperName);
            if (am == null) {
                passed = false;
            }
            if (am == null || !outputMappings) continue;
            Hashtable mappings = ((DBAttributeMapper)am).m_htAttribToMapperInfo;
            for (String key : mappings.keySet()) {
                System.out.println("\t\t" + key);
            }
        }
        return passed;
    }

    public static class mapperTestFileFilter
    implements FilenameFilter {
        public boolean accept(File f, String s) {
            return s.indexOf("ToDBMapper.java") != -1;
        }
    }
}

