/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPort;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMIS11CIM_FCPortSMLToDBMapper
extends DBAttributeMapper {
    public static final String sPERMANENTADDRESS = "permanentaddress";
    public static final String sNAME = "name";
    public static final String sNAMEFORMAT = "nameformat";
    public static final String sDISPLAYNAME = "displayname";
    public static final String sDISPLAYICONNAME = "displayiconname";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sDEVICEID = "deviceid";
    public static final String sSYSTEMNAME = "systemname";
    public static final String sNODEID = "ref_node_id";
    public static final String sPORTTYPE = "porttype";
    public static final String sACTIVE = "active";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_FCPort";
        String mSMIS = "1.1.0";
        String mDeviceType = "GENERIC_TAPE_LIBRARY";
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMIS11CIM_FCPortSMLToDBMapper() {
        ColumnInfo mNameFormatInfo = Port.getColumnInfo("NAME_FORMAT");
        mNameFormatInfo.setIsPrimaryKey();
        this.m_dataConverter.addSimpleDataConversion(sNAMEFORMAT, "Name_Format");
        this.m_htAttribToMapperInfo.put(sNAMEFORMAT, new MapperInfo(mNameFormatInfo));
        this.m_htAttribToMapperInfo.put(sDISPLAYNAME, new MapperInfo(Port.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put(sDISPLAYICONNAME, new MapperInfo(Port.getColumnInfo("DISPLAY_ICON_TYPE")));
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS, new MapperInfo(Port.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(Port.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(sPORTTYPE, new MapperInfo(Port.getColumnInfo("TYPE")));
        this.m_htAttribToMapperInfo.put(sNODEID, new MapperInfo(Port.getColumnInfo("NODE_ID")));
        ColumnInfo mNameColumn = Port.getColumnInfo("NAME");
        mNameColumn.setIsPrimaryKey();
        MapperInfo mNameMapperInfo = new MapperInfo(mNameColumn);
        ColumnInfo mPortIdColumn = Port.getColumnInfo("PORT_ID");
        mPortIdColumn.setAutoGenerated();
        mNameMapperInfo.setDerivedColumn(mPortIdColumn);
        this.m_htAttribToMapperInfo.put(sPERMANENTADDRESS, mNameMapperInfo);
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String mWWPN;
        String nameFormat;
        String portType;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String opstatus = (String)pParams.get(sOPERATIONALSTATUS);
        if (opstatus != null) {
            Vector opArray = SMIS11CIM_FCPortSMLToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put(sOPERATIONALSTATUS, opstatus);
            } else {
                pParams.remove(sOPERATIONALSTATUS);
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                pParams.put("CONSOLIDATED_STATUS".toLowerCase(), opstatus);
            }
        }
        if ((portType = (String)pParams.get(sPORTTYPE)) == null) {
            pParams.put(sPORTTYPE, "2");
        }
        if ((nameFormat = (String)pParams.get(sNAMEFORMAT)) == null) {
            pParams.put(sNAMEFORMAT, "FC_WWN");
        }
        if ((mWWPN = (String)pParams.get(sPERMANENTADDRESS)) != null) {
            pParams.put(sDISPLAYNAME, mWWPN);
        }
        MapperResult result1 = super.persist(pConn, pParams, pScanID);
        Hashtable mAllHTregCIMOM = result1.getAllRows();
        String mPortID = (String)((Hashtable)mAllHTregCIMOM.get(Port.getTablename())).get(Port.getColumnInfo("PORT_ID"));
        pParams.put("portid", mPortID);
        SMISCimkeyPortToDBMapper mapper = new SMISCimkeyPortToDBMapper();
        MapperResult result2 = mapper.persist(pConn, pParams, pScanID);
        MapperResult mReturnResult = result1.addMapperResult(result2);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }

    private class SMISCimkeyPortToDBMapper
    extends DBAttributeMapper {
        public SMISCimkeyPortToDBMapper() {
            ColumnInfo svid = CimkeyPort.getColumnInfo("PORT_ID");
            svid.setIsPrimaryKey();
            MapperInfo svIDInfo = new MapperInfo(svid);
            ColumnInfo portAutoID = CimkeyPort.getColumnInfo("CIMKEY_PORT_ID");
            portAutoID.setAutoGenerated();
            svIDInfo.setDerivedColumn(portAutoID);
            this.m_htAttribToMapperInfo.put("portid", svIDInfo);
            ColumnInfo nsid = CimkeyPort.getColumnInfo("CIM_NAMESPACE_ID");
            nsid.setIsPrimaryKey();
            MapperInfo nsIDInfo = new MapperInfo(nsid);
            nsIDInfo.setDerivedColumn(portAutoID);
            this.m_htAttribToMapperInfo.put("ref_toplevelsystem_cimom2namespaceid", nsIDInfo);
            this.m_htAttribToMapperInfo.put(SMIS11CIM_FCPortSMLToDBMapper.sSYSTEMNAME, new MapperInfo(CimkeyPort.getColumnInfo("SYSTEM_NAMES_ID")));
            this.m_htAttribToMapperInfo.put("creationclassname", new MapperInfo(CimkeyPort.getColumnInfo("CREATION_CLASS_NAME_ID")));
            this.m_htAttribToMapperInfo.put("systemcreationclassname", new MapperInfo(CimkeyPort.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
            this.m_htAttribToMapperInfo.put(SMIS11CIM_FCPortSMLToDBMapper.sDEVICEID, new MapperInfo(CimkeyPort.getColumnInfo("DEVICE_ID")));
            this.m_htAttribToMapperInfo.put(SMIS11CIM_FCPortSMLToDBMapper.sACTIVE, new MapperInfo(CimkeyPort.getColumnInfo("ACTIVE")));
        }

        public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
            String mActive = (String)pParams.get(SMIS11CIM_FCPortSMLToDBMapper.sACTIVE);
            if (mActive == null) {
                pParams.put(SMIS11CIM_FCPortSMLToDBMapper.sACTIVE, "1");
            }
            MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
            return mReturnResult;
        }
    }
}

