/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMIS11CIM_TapeDriveToDBMapper
extends DBAttributeMapper {
    public static final String sPERMANENTADDRESS = "permanentaddress";
    public static final String sNAME = "name";
    public static final String sNAMEFORMAT = "nameformat";
    public static final String sDISPLAYICONNAME = "displayiconname";
    public static final String sSCSISUPPORTED = "scsisupported";
    public static final String sPLATFORMTYPE = "platformtype";
    public static final String sRNIDTYPE = "rnidtype";
    public static final String sTAPELIBRARYID = "ref_toplevelsystem_id";
    public static final String sSYSTEMNAME = "systemname";
    public static final String sDEVICEID = "deviceid";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sNEEDSCLEANING = "needscleaning";
    public static final String sMOUNTCOUNT = "mountcount";
    public static final String sAVAILABILITY = "availability";
    public static final String sPOWERONHOURS = "poweronhours";
    public static final String sTOTALPOWERONHOURS = "totalpoweronhours";
    public static final String sELEMENTNAME = "elementname";
    public static final String sFIRMWARE_VERSION = "firmware_version";
    public static final String sCREATIONCLASSNAME = "creationclassname";
    public static final String sSYSTEMCREATIONCLASSNAME = "systemcreationclassname";
    public static final String sDISPLAYNAME = "displayname";
    public static final String sNODE_ID = "ref_node_id";
    public static final String sLIBRARYID = "ref_toplevelsystem_id";
    public static final String sLOCATIONID = "ref_tape_location_id";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_TapeDrive";
        String mSMIS = "1.1.0";
        String mDeviceType = "GENERIC_TAPE_LIBRARY";
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mCIMClass = "CIM_MediaAccessDevice";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public SMIS11CIM_TapeDriveToDBMapper() {
        ColumnInfo mLibraryIDInfo = TapeDrive.getColumnInfo("TAPE_LIBRARY_ID");
        mLibraryIDInfo.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(mLibraryIDInfo));
        ColumnInfo mDeviceIDInfo = TapeDrive.getColumnInfo("DEVICE_ID");
        mDeviceIDInfo.setIsPrimaryKey();
        MapperInfo mDeviceIDMapperInfo = new MapperInfo(mDeviceIDInfo);
        ColumnInfo mDriveIdColumn = TapeDrive.getColumnInfo("TAPE_DRIVE_ID");
        mDriveIdColumn.setAutoGenerated();
        mDeviceIDMapperInfo.setDerivedColumn(mDriveIdColumn);
        this.m_htAttribToMapperInfo.put(sDEVICEID, mDeviceIDMapperInfo);
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS, new MapperInfo(TapeDrive.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(sMOUNTCOUNT, new MapperInfo(TapeDrive.getColumnInfo("MOUNT_COUNT")));
        this.m_htAttribToMapperInfo.put(sAVAILABILITY, new MapperInfo(TapeDrive.getColumnInfo("AVAILABILITY")));
        this.m_htAttribToMapperInfo.put(sPOWERONHOURS, new MapperInfo(TapeDrive.getColumnInfo("POWER_ON_HOURS")));
        this.m_htAttribToMapperInfo.put(sTOTALPOWERONHOURS, new MapperInfo(TapeDrive.getColumnInfo("TOTAL_POWER_ON_HOURS")));
        this.m_htAttribToMapperInfo.put(sELEMENTNAME, new MapperInfo(TapeDrive.getColumnInfo("ELEMENT_NAME")));
        this.m_dataConverter.addSimpleDataConversion(sNEEDSCLEANING, "Boolean");
        this.m_htAttribToMapperInfo.put(sNEEDSCLEANING, new MapperInfo(TapeDrive.getColumnInfo("NEEDS_CLEANING")));
        this.m_htAttribToMapperInfo.put(sFIRMWARE_VERSION, new MapperInfo(TapeDrive.getColumnInfo("FIRMWARE_VERSION")));
        this.m_htAttribToMapperInfo.put(sNODE_ID, new MapperInfo(TapeDrive.getColumnInfo("NODE_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMNAME, new MapperInfo(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")));
        this.m_htAttribToMapperInfo.put(sLOCATIONID, new MapperInfo(TapeDrive.getColumnInfo("LOCATION_ID")));
        this.m_htAttribToMapperInfo.put(sCREATIONCLASSNAME, new MapperInfo(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMCREATIONCLASSNAME, new MapperInfo(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMNAME, new MapperInfo(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")));
        this.m_htAttribToMapperInfo.put(sDISPLAYNAME, new MapperInfo(TapeDrive.getColumnInfo("DISPLAY_NAME")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String opstatus = (String)pParams.get(sOPERATIONALSTATUS);
        if (opstatus != null) {
            Vector opArray = SMIS11CIM_TapeDriveToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put(sOPERATIONALSTATUS, opstatus);
            } else {
                pParams.remove(sOPERATIONALSTATUS);
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                pParams.put("CONSOLIDATED_STATUS".toLowerCase(), opstatus);
            }
        }
        if (pParams.get(sDISPLAYNAME) == null) {
            String mDisplayName = (String)pParams.get("ref_toplevelsystem_name");
            pParams.put(sDISPLAYNAME, mDisplayName);
        }
        MapperResult mResult = new MapperResult();
        if (pParams.get(sNODE_ID) == null && pParams.get("SCSI") == null) {
            NodeMapper mapper = new NodeMapper();
            mResult = mapper.persist(pConn, pParams, pScanID);
            pParams.putAll(mResult.getKeyReferences());
        }
        mResult.addMapperResult(super.persist(pConn, pParams, pScanID));
        mResult.addKeyReference("ref_device_id", TapeDrive.getColumnInfo("DEVICE_ID"));
        mResult.addKeyReference("ref_system_names_id", TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"));
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mResult);
        return mResult;
    }

    private class NodeMapper
    extends DBAttributeMapper {
        public NodeMapper() {
            ColumnInfo mNameFormatInfo = Node.getColumnInfo("NAME_FORMAT");
            mNameFormatInfo.setIsPrimaryKey();
            this.m_dataConverter.addSimpleDataConversion(SMIS11CIM_TapeDriveToDBMapper.sNAMEFORMAT, "Name_Format");
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeDriveToDBMapper.sNAMEFORMAT, new MapperInfo(mNameFormatInfo));
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeDriveToDBMapper.sDISPLAYNAME, new MapperInfo(Node.getColumnInfo("DISPLAY_NAME")));
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeDriveToDBMapper.sDISPLAYICONNAME, new MapperInfo(Node.getColumnInfo("DISPLAY_ICON_TYPE")));
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeDriveToDBMapper.sOPERATIONALSTATUS, new MapperInfo(Node.getColumnInfo("OPERATIONAL_STATUS")));
            this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(Node.getColumnInfo("CONSOLIDATED_STATUS")));
            this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(Node.getColumnInfo("TAPE_LIBRARY_ID")));
            ColumnInfo mNameColumn = Node.getColumnInfo("NAME");
            mNameColumn.setIsPrimaryKey();
            MapperInfo mNameMapperInfo = new MapperInfo(mNameColumn);
            ColumnInfo mNodeIdColumn = Node.getColumnInfo("NODE_ID");
            mNodeIdColumn.setAutoGenerated();
            mNameMapperInfo.setDerivedColumn(mNodeIdColumn);
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeDriveToDBMapper.sDEVICEID, mNameMapperInfo);
        }

        public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
            String nameFormat;
            String rnidType;
            String platformType;
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
            String scsiSupported = (String)pParams.get(SMIS11CIM_TapeDriveToDBMapper.sSCSISUPPORTED);
            if (scsiSupported == null) {
                pParams.put(SMIS11CIM_TapeDriveToDBMapper.sSCSISUPPORTED, "1");
            }
            if ((platformType = (String)pParams.get(SMIS11CIM_TapeDriveToDBMapper.sPLATFORMTYPE)) == null) {
                pParams.put(SMIS11CIM_TapeDriveToDBMapper.sPLATFORMTYPE, "1");
            }
            if ((rnidType = (String)pParams.get(SMIS11CIM_TapeDriveToDBMapper.sRNIDTYPE)) == null) {
                pParams.put(SMIS11CIM_TapeDriveToDBMapper.sRNIDTYPE, "1");
            }
            if ((nameFormat = (String)pParams.get(SMIS11CIM_TapeDriveToDBMapper.sNAMEFORMAT)) == null) {
                pParams.put(SMIS11CIM_TapeDriveToDBMapper.sNAMEFORMAT, "FC_WWN");
            }
            MapperResult mNodeMapperResult = super.persist(pConn, pParams, pScanID);
            mNodeMapperResult.addKeyReference(SMIS11CIM_TapeDriveToDBMapper.sNODE_ID, Node.getColumnInfo("NODE_ID"));
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mNodeMapperResult);
            return mNodeMapperResult;
        }
    }
}

