/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.Dedicated;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMIS11CIM_TapeLibraryToDBMapper
extends DBAttributeMapper {
    public static final String sNAME = "name";
    public static final String sNAMEFORMAT = "nameformat";
    public static final String sCREATIONCLASSNAME = "creationclassname";
    public static final String sELEMENTNAME = "elementname";
    public static final String sPRIMARYOWNERNAME = "primaryownername";
    public static final String sPRIMARYOWNERCONTACT = "primaryownercontact";
    public static final String sDETECTABLE = "detectable";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sCONSOLIDATEDSTATUS = "consolidatedstatus";
    public static final String sPROPAGATEDSTATUS = "propagatedstatus";
    public static final String sDESCRIPTION = "description";
    public static final String sDISPLAYNAME = "displayname";
    public static final String sACCESSINFO = "accessinfo";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_ComputerSystem";
        String mSMIS = "1.1.0";
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = Dedicated.getValue(Dedicated.MEDIA_LIBRARY);
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMIS11CIM_TapeLibraryToDBMapper() {
        this.m_dataConverter.addSimpleDataConversion(sNAMEFORMAT, "SMISName_Format");
        ColumnInfo mNameFormatColumn = TapeLibrary.getColumnInfo("NAME_FORMAT");
        mNameFormatColumn.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put(sNAMEFORMAT, new MapperInfo(mNameFormatColumn));
        this.m_htAttribToMapperInfo.put(sELEMENTNAME, new MapperInfo(TapeLibrary.getColumnInfo("ELEMENT_NAME")));
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS, new MapperInfo(TapeLibrary.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(sDESCRIPTION, new MapperInfo(TapeLibrary.getColumnInfo("DESCRIPTION")));
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(TapeLibrary.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(sPRIMARYOWNERNAME, new MapperInfo(TapeLibrary.getColumnInfo("PRIMARY_OWNER_NAME")));
        this.m_htAttribToMapperInfo.put(sPRIMARYOWNERCONTACT, new MapperInfo(TapeLibrary.getColumnInfo("PRIMARY_OWNER_CONTACT")));
        this.m_htAttribToMapperInfo.put(sDETECTABLE, new MapperInfo(TapeLibrary.getColumnInfo("DETECTABLE")));
        this.m_htAttribToMapperInfo.put(sCONSOLIDATEDSTATUS, new MapperInfo(TapeLibrary.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(sPROPAGATEDSTATUS, new MapperInfo(TapeLibrary.getColumnInfo("PROPAGATED_STATUS")));
        this.m_htAttribToMapperInfo.put(sDISPLAYNAME, new MapperInfo(TapeLibrary.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put(sACCESSINFO, new MapperInfo(TapeLibrary.getColumnInfo("ACCESS_INFO")));
        this.m_htAttribToMapperInfo.put(sCREATIONCLASSNAME, new MapperInfo(TapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")));
        ColumnInfo mNameColumn = TapeLibrary.getColumnInfo("NAME");
        mNameColumn.setIsPrimaryKey();
        MapperInfo mNameMapperInfo = new MapperInfo(mNameColumn);
        ColumnInfo mTapeLibraryIdColumn = TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID");
        mTapeLibraryIdColumn.setAutoGenerated();
        mNameMapperInfo.setDerivedColumn(mTapeLibraryIdColumn);
        this.m_htAttribToMapperInfo.put(sNAME, mNameMapperInfo);
    }

    public String toString() {
        return this.getClass().toString();
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String nameformat;
        String name;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String opstatus = (String)pParams.get(sOPERATIONALSTATUS);
        if (opstatus != null) {
            Vector opArray = SMIS11CIM_TapeLibraryToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put(sOPERATIONALSTATUS, opstatus);
            } else {
                pParams.remove(sOPERATIONALSTATUS);
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                pParams.put("CONSOLIDATED_STATUS".toLowerCase(), opstatus);
            }
        }
        if ((pParams.get(sDISPLAYNAME) == null || ((String)pParams.get(sDISPLAYNAME)).length() == 0) && (name = (String)pParams.get(sNAME)) != null) {
            pParams.put(sDISPLAYNAME, name);
        }
        if (pParams.get(sACCESSINFO) != null && ((String)pParams.get(sACCESSINFO)).length() > 0 && !((String)pParams.get(sACCESSINFO)).toLowerCase().startsWith("http")) {
            String accessinfo = "http://" + (String)pParams.get(sACCESSINFO);
            pParams.put(sACCESSINFO, accessinfo);
        }
        if ((nameformat = (String)pParams.get(sNAMEFORMAT)) != null) {
            pParams.put("nameformat2", nameformat);
        }
        MapperResult mLibraryResult = super.persist(pConn, pParams, pScanID);
        Hashtable mAllRowsLibrary = mLibraryResult.getAllRows();
        String mLibraryID = (String)((Hashtable)mAllRowsLibrary.get("T_RES_TAPE_LIBRARY")).get(TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"));
        pParams.put("libraryid", mLibraryID);
        SMISCimkeyTapeLibraryToDBMapper mCIMKeyMapper = new SMISCimkeyTapeLibraryToDBMapper();
        MapperResult mResultCIMKey = mCIMKeyMapper.persist(pConn, pParams, pScanID);
        MapperResult mReturnResult = mLibraryResult.addMapperResult(mResultCIMKey);
        mReturnResult.addKeyReference("ref_toplevelsystem_id", TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"));
        mReturnResult.addKeyReference("ref_toplevelsystem_name", TapeLibrary.getColumnInfo("NAME"));
        mReturnResult.addKeyReference("ref_toplevelsystem_nameformat", TapeLibrary.getColumnInfo("NAME_FORMAT"));
        mReturnResult.addKeyReference("ref_tape_library_id", TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"));
        try {
            mReturnResult.addKeyReference("ref_toplevelsystem_cimom2namespaceid", CimkeyTapeLibrary.getColumnInfo("CIM_NAMESPACE_ID"));
        }
        catch (Exception e) {
            this.logInfo(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Library Mapper called w/o cimom2namespace creation - Firmware mapping!");
        }
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }

    private class SMISCimkeyTapeLibraryToDBMapper
    extends DBAttributeMapper {
        public SMISCimkeyTapeLibraryToDBMapper() {
            ColumnInfo mLibraryname = CimkeyTapeLibrary.getColumnInfo("NAME");
            mLibraryname.setIsPrimaryKey();
            MapperInfo mLibraryMapperInfo = new MapperInfo(mLibraryname);
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeLibraryToDBMapper.sNAME, mLibraryMapperInfo);
            ColumnInfo mLibraryID = CimkeyTapeLibrary.getColumnInfo("TAPE_LIBRARY_ID");
            mLibraryID.setIsPrimaryKey();
            MapperInfo mLibraryIDMapperInfo = new MapperInfo(mLibraryID);
            ColumnInfo mCIMKeyIDInfo = CimkeyTapeLibrary.getColumnInfo("CIMKEY_TAPE_LIBRARY_ID");
            mCIMKeyIDInfo.setAutoGenerated();
            mLibraryIDMapperInfo.setDerivedColumn(mCIMKeyIDInfo);
            this.m_htAttribToMapperInfo.put("libraryid", mLibraryIDMapperInfo);
            this.m_dataConverter.addSimpleDataConversion("nameformat2", "SMISName_Format");
            this.m_htAttribToMapperInfo.put("nameformat2", new MapperInfo(CimkeyTapeLibrary.getColumnInfo("NAME_FORMAT")));
            ColumnInfo mNSID = CimkeyTapeLibrary.getColumnInfo("CIM_NAMESPACE_ID");
            mNSID.setIsPrimaryKey();
            MapperInfo nsidMapperInfo = new MapperInfo(mNSID);
            nsidMapperInfo.setDerivedColumn(mCIMKeyIDInfo);
            this.m_htAttribToMapperInfo.put("cimnamespaceid", nsidMapperInfo);
            this.m_htAttribToMapperInfo.put(SMIS11CIM_TapeLibraryToDBMapper.sCREATIONCLASSNAME, new MapperInfo(CimkeyTapeLibrary.getColumnInfo("CREATION_CLASS_NAME_ID")));
        }

        public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
            Hashtable lookup = new Hashtable();
            String val = (String)pParams.get("ref_serviceurl");
            if (val != null) {
                RegisteredCimom helper = new RegisteredCimom();
                helper.setServiceUrl(val);
                boolean retval = helper.retrieve(pConn);
                if (retval) {
                    int cimomid = helper.getRegCimomId();
                    val = (String)pParams.get("ref_namespace");
                    if (val != null) {
                        Cimom2namespace helperc2n = new Cimom2namespace();
                        helperc2n.setCimomId(cimomid);
                        helperc2n.setNamespace(val);
                        retval = helperc2n.retrieve(pConn);
                        if (retval) {
                            pParams.put("cimnamespaceid", new String(helperc2n.getCimNamespaceId() + ""));
                            MapperResult mResult = super.persist(pConn, pParams, pScanID);
                            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mResult);
                            return mResult;
                        }
                    }
                }
            }
            MapperResult mResult = new MapperResult();
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mResult);
            return mResult;
        }
    }
}

