/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.Dedicated;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMIS11CIM_TapeLibraryToDBMapper;

public class SMIS11IBMTSSML3494_TapeLibraryToDBMapper
extends SMIS11CIM_TapeLibraryToDBMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSSML3494_TapeLibrary";
        String mSMIS = "1.1.0";
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = Dedicated.getValue(Dedicated.MEDIA_LIBRARY);
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public String toString() {
        return this.getClass().toString();
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mAlias = (String)pParams.get("name");
        String mIP = (String)pParams.get("elementname");
        pParams.put("displayname", this.createDisplayName(mIP, mAlias));
        MapperResult mLibraryResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mLibraryResult);
        return mLibraryResult;
    }

    private String createDisplayName(String pIP, String pAlias) {
        if (pIP == null || pAlias == null || pIP.length() < 1 || pIP.length() < 1) {
            this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "persisting 3494 top level systems not properly possible - IP and/or Alias is missing!");
            return "Tape-3494-NOTSET-IBM";
        }
        return "Tape-3494-" + pIP + ":" + pAlias + "-IBM";
    }
}

