/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.Dedicated;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMIS11CIM_TapeLibraryToDBMapper;

public class SMIS11IBMTSSML3583_TapeLibraryToDBMapper
extends SMIS11CIM_TapeLibraryToDBMapper {
    public static final String CR = "(C) Copyright IBM Corp. 2005.";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSSML3583_TapeLibrary";
        String mSMIS = "1.1.0";
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = Dedicated.getValue(Dedicated.MEDIA_LIBRARY);
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public String toString() {
        return this.getClass().toString();
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mIP = (String)pParams.get("name");
        pParams.put("displayname", this.createDisplayName(mIP));
        MapperResult mLibraryResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mLibraryResult);
        return mLibraryResult;
    }

    private String createDisplayName(String pIP) {
        if (pIP == null || pIP.length() < 1 || pIP.length() < 1) {
            this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "persisting 3583 top level systems not properly possible - IP is missing!");
            return "Tape-3583-NOTSET-IBM";
        }
        return "Tape-3583-" + pIP + "-IBM";
    }
}

