/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMIS11CIM_ChangerDeviceToDBMapper;

public class SMIS11IBMTSSML3584_ChangerDeviceToDBMapper
extends SMIS11CIM_ChangerDeviceToDBMapper {
    public static final String sPERMANENTADDRESS = "permanentaddress";
    public static final String sNAME = "name";
    public static final String sNAMEFORMAT = "nameformat";
    public static final String sDISPLAYNAME = "displayname";
    public static final String sDISPLAYICONNAME = "displayiconname";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sDEVICEID = "deviceid";
    public static final String sSYSTEMNAME = "systemname";
    public static final String sSCSISUPPORTED = "scsisupported";
    public static final String sPLATFORMTYPE = "platformtype";
    public static final String sRNIDTYPE = "rnidtype";
    public static final String sTAPELIBRARYID = "ref_toplevelsystem_id";
    public static final String sLOCATIONID = "ref_tape_location_id";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSSML3584_ChangerDevice";
        String mSMIS = "1.1.0";
        String mDeviceType = "3584";
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mAgentVersion = "1.1.1";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public SMIS11IBMTSSML3584_ChangerDeviceToDBMapper() {
        this.m_htAttribToMapperInfo.remove(sLOCATIONID);
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String bSCSI;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mDeviceID = (String)pParams.get(sDEVICEID);
        String mWWNN = this.extractWWPNFromName(mDeviceID);
        String mDN = this.createDisplayName(mWWNN);
        boolean mCreateNode = true;
        if (pParams.get("SCSI") != null && (bSCSI = (String)pParams.get("SCSI")).equalsIgnoreCase("true")) {
            mDN = mDN + " (SCSI)";
            mCreateNode = false;
            mWWNN = "0000000000000000";
        }
        pParams.put(sDISPLAYNAME, mDN);
        NodeMapper mNodeMapper = new NodeMapper();
        Hashtable<String, String> mNodeHT = new Hashtable<String, String>();
        mNodeHT.put(sPERMANENTADDRESS, mWWNN);
        mNodeHT.put(sDISPLAYNAME, mDN);
        mNodeHT.put(sTAPELIBRARYID, (String)pParams.get(sTAPELIBRARYID));
        MapperResult mNodeMapperResult = mNodeMapper.persist(pConn, mNodeHT, pScanID);
        Hashtable mNodeResultHT = mNodeMapperResult.getAllRows();
        String mNodeID = (String)((Hashtable)mNodeResultHT.get(Node.getTablename())).get(Node.getColumnInfo("NODE_ID"));
        pParams.put("ref_node_id", mNodeID);
        MapperResult mLibraryResult = super.persist(pConn, pParams, pScanID);
        mLibraryResult.addMapperResult(mNodeMapperResult);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mLibraryResult);
        return mLibraryResult;
    }

    private String createDisplayName(String pWWNN) {
        if (pWWNN != null && pWWNN.length() > 0) {
            int bLength = pWWNN.length();
            pWWNN = pWWNN.substring(7, bLength);
            return pWWNN;
        }
        return "";
    }

    private String extractWWPNFromName(String pUniqueID) {
        if (pUniqueID != null && pUniqueID.length() > 0) {
            String bWWPN = pUniqueID.substring(pUniqueID.indexOf(":") + 1, pUniqueID.length());
            bWWPN = bWWPN.replaceAll(" ", "");
            return bWWPN;
        }
        return "";
    }

    private class NodeMapper
    extends DBAttributeMapper {
        public NodeMapper() {
            ColumnInfo mNameFormatInfo = Node.getColumnInfo("NAME_FORMAT");
            mNameFormatInfo.setIsPrimaryKey();
            this.m_dataConverter.addSimpleDataConversion(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sNAMEFORMAT, "Name_Format");
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sNAMEFORMAT, new MapperInfo(mNameFormatInfo));
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sDISPLAYNAME, new MapperInfo(Node.getColumnInfo("DISPLAY_NAME")));
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sDISPLAYICONNAME, new MapperInfo(Node.getColumnInfo("DISPLAY_ICON_TYPE")));
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sOPERATIONALSTATUS, new MapperInfo(Node.getColumnInfo("OPERATIONAL_STATUS")));
            this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(Node.getColumnInfo("CONSOLIDATED_STATUS")));
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sTAPELIBRARYID, new MapperInfo(Node.getColumnInfo("TAPE_LIBRARY_ID")));
            ColumnInfo mNameColumn = Node.getColumnInfo("NAME");
            mNameColumn.setIsPrimaryKey();
            MapperInfo mNameMapperInfo = new MapperInfo(mNameColumn);
            ColumnInfo mNodeIdColumn = Node.getColumnInfo("NODE_ID");
            mNodeIdColumn.setAutoGenerated();
            mNameMapperInfo.setDerivedColumn(mNodeIdColumn);
            this.m_htAttribToMapperInfo.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sPERMANENTADDRESS, mNameMapperInfo);
        }

        public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
            String nameFormat;
            String rnidType;
            String platformType;
            String scsiSupported;
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
            String opstatus = (String)pParams.get(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sOPERATIONALSTATUS);
            if (opstatus != null) {
                Vector opArray = NodeMapper.processArrayvalues(opstatus);
                if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                    pParams.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sOPERATIONALSTATUS, opstatus);
                } else {
                    pParams.remove(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sOPERATIONALSTATUS);
                }
                opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
                if (opstatus != null) {
                    pParams.put("CONSOLIDATED_STATUS".toLowerCase(), opstatus);
                }
            }
            if ((scsiSupported = (String)pParams.get(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sSCSISUPPORTED)) == null) {
                pParams.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sSCSISUPPORTED, "1");
            }
            if ((platformType = (String)pParams.get(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sPLATFORMTYPE)) == null) {
                pParams.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sPLATFORMTYPE, "1");
            }
            if ((rnidType = (String)pParams.get(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sRNIDTYPE)) == null) {
                pParams.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sRNIDTYPE, "1");
            }
            if ((nameFormat = (String)pParams.get(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sNAMEFORMAT)) == null) {
                pParams.put(SMIS11IBMTSSML3584_ChangerDeviceToDBMapper.sNAMEFORMAT, "FC_WWN");
            }
            MapperResult mNodeMapperResult = super.persist(pConn, pParams, pScanID);
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mNodeMapperResult);
            return mNodeMapperResult;
        }
    }
}

