/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.Physicalvolume2extent;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_DiskDriveToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_DiskDrive";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.1.0";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3};
    }

    public SMISCIM_DiskDriveToDBMapper() {
        this.m_htAttribToMapperInfo.put("manufacturer", new MapperInfo(PhysicalVolume.getColumnInfo("VENDOR_ID")));
        this.m_htAttribToMapperInfo.put("model", new MapperInfo(PhysicalVolume.getColumnInfo("MODEL_ID")));
        this.m_htAttribToMapperInfo.put("mountcount", new MapperInfo(PhysicalVolume.getColumnInfo("USE_COUNT")));
        this.m_htAttribToMapperInfo.put("elementname", new MapperInfo(PhysicalVolume.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put("name", new MapperInfo(PhysicalVolume.getColumnInfo("NAME")));
        this.m_htAttribToMapperInfo.put("operationalstatus", new MapperInfo(PhysicalVolume.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(PhysicalVolume.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put("firmwarelevel", new MapperInfo(PhysicalVolume.getColumnInfo("FIRMWARE_REV")));
        ColumnInfo phname = PhysicalVolume.getColumnInfo("DEVICE_ID");
        phname.setIsPrimaryKey();
        MapperInfo phnameMapperInfo = new MapperInfo(phname);
        ColumnInfo phIdInfo = PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID");
        phIdInfo.setAutoGenerated();
        phnameMapperInfo.setDerivedColumn(phIdInfo);
        this.m_htAttribToMapperInfo.put("deviceid", phnameMapperInfo);
        ColumnInfo systemName = PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID");
        systemName.setIsPrimaryKey();
        MapperInfo systemnameMapper = new MapperInfo(systemName);
        systemnameMapper.setDerivedColumn(phIdInfo);
        this.m_htAttribToMapperInfo.put("systemname", systemnameMapper);
        this.m_htAttribToMapperInfo.put("creationclassname", new MapperInfo(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put("systemcreationclassname", new MapperInfo(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(PhysicalVolume.getColumnInfo("SUBSYSTEM_ID")));
        this.m_htAttribToMapperInfo.put("ref_diskgroup_id", new MapperInfo(PhysicalVolume.getColumnInfo("DISK_GROUP_ID")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String opstatus = (String)pParams.get("operationalstatus");
        if (opstatus != null) {
            Vector opArray = SMISCIM_DiskDriveToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put("operationalstatus", opstatus);
            } else {
                pParams.remove("operationalstatus");
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                pParams.put("CONSOLIDATED_STATUS".toLowerCase(), opstatus);
            }
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        mReturnResult.addKeyReference("ref_physicalvolume_id", PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID"));
        mReturnResult.addKeyReference("ref_physicalvolume_system_names_id", PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"));
        mReturnResult.addKeyReference("ref_physicalvolume_device_id", PhysicalVolume.getColumnInfo("DEVICE_ID"));
        if (pParams.get("ref_storageextent_id") != null) {
            pParams.putAll(mReturnResult.getKeyReferences());
            SMISPhysicalVolume2ExtentToDBMapper mDisk2ExtentMapper = new SMISPhysicalVolume2ExtentToDBMapper();
            MapperResult mDisk2ExtentResult = mDisk2ExtentMapper.persist(pConn, pParams, pScanID);
            mReturnResult.addMapperResult(mDisk2ExtentResult);
        }
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }

    private class SMISPhysicalVolume2ExtentToDBMapper
    extends DBAttributeMapper {
        public SMISPhysicalVolume2ExtentToDBMapper() {
            ColumnInfo mDiskID = Physicalvolume2extent.getColumnInfo("PHYSICAL_VOLUME_ID");
            mDiskID.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_physicalvolume_id", new MapperInfo(mDiskID));
            ColumnInfo mExtentID = Physicalvolume2extent.getColumnInfo("STORAGE_EXTENT_ID");
            mExtentID.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_storageextent_id", new MapperInfo(mExtentID));
        }
    }
}

