/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPort;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_FCPortToDBMapper
extends DBAttributeMapper {
    public static final String sSUBSYSTEMID = "ref_toplevelsystem_id";
    public static final String sDETECTABLE = "detectable";
    public static final String sDISPLAYNAME = "display_name";
    public static final String sDISPLAYICONTYPE = "display_icon_type";
    public static final String sRIOLOOPID = "rioloop";
    public static final String sNAMEFORMAT = "nameformat";
    public static final String sNETWORKADDRESSES = "networkaddresses";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sPORTNUMBER = "portnumber";
    public static final String sSPEED = "speed";
    public static final String sPORTTYPE = "porttype";
    public static final String sPERMANENTADDRESS = "permanentaddress";
    public static final String sNODENAME = "nodename";
    public static final String sACTIVE = "active";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_FCPort";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMISCIM_FCPortToDBMapper() {
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(Port.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put(sDETECTABLE, new MapperInfo(Port.getColumnInfo("DETECTABLE")));
        this.m_htAttribToMapperInfo.put(sDISPLAYNAME, new MapperInfo(Port.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put(sDISPLAYICONTYPE, new MapperInfo(Port.getColumnInfo("DISPLAY_ICON_TYPE")));
        this.m_htAttribToMapperInfo.put(sRIOLOOPID, new MapperInfo(Port.getColumnInfo("RIO_LOOP_ID")));
        this.m_dataConverter.addSimpleDataConversion(sNAMEFORMAT, "Name_Format");
        this.m_htAttribToMapperInfo.put(sNAMEFORMAT, new MapperInfo(Port.getColumnInfo("NAME_FORMAT")));
        this.m_htAttribToMapperInfo.put(sNETWORKADDRESSES, new MapperInfo(Port.getColumnInfo("NETWORK_ADDRESSES")));
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS, new MapperInfo(Port.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(sPORTNUMBER, new MapperInfo(Port.getColumnInfo("PORT_NUMBER")));
        this.m_htAttribToMapperInfo.put(sSPEED, new MapperInfo(Port.getColumnInfo("PORT_SPEED")));
        this.m_htAttribToMapperInfo.put(sPORTTYPE, new MapperInfo(Port.getColumnInfo("TYPE")));
        this.m_htAttribToMapperInfo.put(sSUBSYSTEMID, new MapperInfo(Port.getColumnInfo("SUBSYSTEM_ID")));
        ColumnInfo portname = Port.getColumnInfo("NAME");
        portname.setIsPrimaryKey();
        MapperInfo portnameMapperInfo = new MapperInfo(portname);
        ColumnInfo portIdInfo = Port.getColumnInfo("PORT_ID");
        portIdInfo.setAutoGenerated();
        portnameMapperInfo.setDerivedColumn(portIdInfo);
        this.m_htAttribToMapperInfo.put(sPERMANENTADDRESS, portnameMapperInfo);
        ColumnInfo nodeNameCompareColumn = Node.getColumnInfo("NAME");
        nodeNameCompareColumn.setForeignKeyConstraint();
        nodeNameCompareColumn.setIsPrimaryKey();
        ColumnInfo[] portNodeFKCols = new ColumnInfo[]{Port.getColumnInfo("NODE_ID")};
        MapperInfo nodemapper = new MapperInfo(nodeNameCompareColumn, portNodeFKCols);
        ColumnInfo portID = Node.getColumnInfo("NODE_ID");
        portID.setAutoGenerated();
        nodemapper.setDerivedColumn(portID);
        this.m_htAttribToMapperInfo.put(sNODENAME, nodemapper);
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String mNameFormat;
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        String mUsageRestriction = (String)htValues.get("usagerestriction");
        if (mUsageRestriction != null && mUsageRestriction.equals("3")) {
            this.logExit(this.myClassname, methodName, "Does not populate Back-End only Ports");
            return new MapperResult();
        }
        String opstatus = (String)htValues.get(sOPERATIONALSTATUS);
        if (opstatus != null) {
            Vector opArray = SMISCIM_FCPortToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                htValues.put(sOPERATIONALSTATUS, opstatus);
            } else {
                htValues.remove(sOPERATIONALSTATUS);
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                htValues.put("CONSOLIDATED_STATUS".toLowerCase(), opstatus);
            }
        }
        if ((mNameFormat = (String)htValues.get(sNAMEFORMAT)) == null) {
            htValues.put(sNAMEFORMAT, "fc_wwn");
        }
        try {
            long lSpeed = Long.parseLong((String)htValues.get(sSPEED));
        }
        catch (NumberFormatException numEx) {
            this.logInfo(this.myClassname, methodName, "Attempt to set a field, speed, of type BigInt with a too large value");
            htValues.remove(sSPEED);
        }
        String mWWPN = (String)htValues.get(sPERMANENTADDRESS);
        String loc = (String)htValues.get("loc");
        if (loc != null) {
            htValues.put(sDISPLAYNAME, loc);
        } else if (mWWPN != null) {
            htValues.put(sDISPLAYNAME, mWWPN);
        }
        MapperResult result1 = super.persist(conn, htValues, scanID);
        Hashtable mAllHTregCIMOM = result1.getAllRows();
        String mPortID = (String)((Hashtable)mAllHTregCIMOM.get(Port.getTablename())).get(Port.getColumnInfo("PORT_ID"));
        htValues.put("portid", mPortID);
        SMISCimkeyPortToDBMapper mapper = new SMISCimkeyPortToDBMapper();
        MapperResult result2 = mapper.persist(conn, htValues, scanID);
        if (htValues.get("ref_switch_wwn") != null) {
            SMISSwitch2PortToDBMapper mapper3 = new SMISSwitch2PortToDBMapper();
            result2.addMapperResult(mapper3.persist(conn, htValues, scanID));
        }
        MapperResult mReturnResult = result1.addMapperResult(result2);
        this.logExit(this.myClassname, methodName, mReturnResult);
        return mReturnResult;
    }

    private class SMISSwitch2PortToDBMapper
    extends DBAttributeMapper {
        public SMISSwitch2PortToDBMapper() {
            ColumnInfo ssIdInfo = Switch2port.getColumnInfo("SWITCH2PORT_ID");
            ssIdInfo.setAutoGenerated();
            ColumnInfo ssName = Switch2port.getColumnInfo("SWITCH_WWN");
            ssName.setIsPrimaryKey();
            MapperInfo ssnameMapperInfo = new MapperInfo(ssName);
            ssnameMapperInfo.setDerivedColumn(ssIdInfo);
            this.m_htAttribToMapperInfo.put("ref_switch_wwn", ssnameMapperInfo);
            ColumnInfo portID = Switch2port.getColumnInfo("PORT_ID");
            portID.setIsPrimaryKey();
            MapperInfo portIDMapperInfo = new MapperInfo(portID);
            portIDMapperInfo.setDerivedColumn(ssIdInfo);
            this.m_htAttribToMapperInfo.put("portid", portIDMapperInfo);
        }
    }

    private class SMISCimkeyPortToDBMapper
    extends DBAttributeMapper {
        public SMISCimkeyPortToDBMapper() {
            ColumnInfo svid = CimkeyPort.getColumnInfo("PORT_ID");
            svid.setIsPrimaryKey();
            MapperInfo svIDInfo = new MapperInfo(svid);
            ColumnInfo portAutoID = CimkeyPort.getColumnInfo("CIMKEY_PORT_ID");
            portAutoID.setAutoGenerated();
            svIDInfo.setDerivedColumn(portAutoID);
            this.m_htAttribToMapperInfo.put("portid", svIDInfo);
            ColumnInfo nsid = CimkeyPort.getColumnInfo("CIM_NAMESPACE_ID");
            nsid.setIsPrimaryKey();
            MapperInfo nsIDInfo = new MapperInfo(nsid);
            nsIDInfo.setDerivedColumn(portAutoID);
            this.m_htAttribToMapperInfo.put("cimnamespaceid", nsIDInfo);
            this.m_htAttribToMapperInfo.put("systemname", new MapperInfo(CimkeyPort.getColumnInfo("SYSTEM_NAMES_ID")));
            this.m_htAttribToMapperInfo.put("creationclassname", new MapperInfo(CimkeyPort.getColumnInfo("CREATION_CLASS_NAME_ID")));
            this.m_htAttribToMapperInfo.put("systemcreationclassname", new MapperInfo(CimkeyPort.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
            this.m_htAttribToMapperInfo.put("deviceid", new MapperInfo(CimkeyPort.getColumnInfo("DEVICE_ID")));
            this.m_htAttribToMapperInfo.put(SMISCIM_FCPortToDBMapper.sACTIVE, new MapperInfo(CimkeyPort.getColumnInfo("ACTIVE")));
        }

        public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
            String mActive = (String)pParams.get(SMISCIM_FCPortToDBMapper.sACTIVE);
            if (mActive == null) {
                pParams.put(SMISCIM_FCPortToDBMapper.sACTIVE, "1");
            }
            Hashtable lookup = new Hashtable();
            String val = (String)pParams.get("ref_serviceurl");
            if (val != null) {
                RegisteredCimom helper = new RegisteredCimom();
                helper.setServiceUrl(val);
                boolean retval = helper.retrieve(pConn);
                if (retval) {
                    int cimomid = helper.getRegCimomId();
                    val = (String)pParams.get("ref_namespace");
                    if (val != null) {
                        Cimom2namespace helperc2n = new Cimom2namespace();
                        helperc2n.setCimomId(cimomid);
                        helperc2n.setNamespace(val);
                        retval = helperc2n.retrieve(pConn);
                        if (retval) {
                            pParams.put("cimnamespaceid", new String(helperc2n.getCimNamespaceId() + ""));
                            MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
                            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
                            return mReturnResult;
                        }
                    }
                }
            }
            MapperResult mReturnResult = new MapperResult();
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
            return mReturnResult;
        }
    }
}

