/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extent;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_StorageExtentToDBMapper
extends DBAttributeMapper {
    public static final String sELEMENTNAME = "elementname";
    public static final String sCREATIONCLASSNAME = "creationclassname";
    public static final String sSYSTEMCREATIONCLASSNAME = "systemcreationclassname";
    public static final String sSYSTEMNAME = "systemname";
    public static final String sDEVICEID = "deviceid";
    public static final String sNAME = "name";
    public static final String sBLOCKSIZE = "blocksize";
    public static final String sNUMBEROFBLOCKS = "numberofblocks";
    public static final String sCONSUMABLEBLOCKS = "consumableblocks";
    public static final String sOPERATIONALSTATUS = "operationalstatus";
    public static final String sCAPACITY = "capacity";
    public static final String sFREECAPACITY = "freecapacity";
    public static final String sSUBSYSTEMID = "ref_toplevelsystem_id";
    public static final String sSTORAGEPOOLID = "ref_storagepool_id";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_StorageExtent";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.1.0";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3};
    }

    public SMISCIM_StorageExtentToDBMapper() {
        this.m_htAttribToMapperInfo.put(sCREATIONCLASSNAME, new MapperInfo(StorageExtent.getColumnInfo("CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMCREATIONCLASSNAME, new MapperInfo(StorageExtent.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put(sSYSTEMNAME, new MapperInfo(StorageExtent.getColumnInfo("SYSTEM_NAMES_ID")));
        ColumnInfo subsystemColInfo = StorageExtent.getColumnInfo("SUBSYSTEM_ID");
        subsystemColInfo.setIsPrimaryKey();
        MapperInfo subsystemMapperInfo = new MapperInfo(subsystemColInfo);
        ColumnInfo extentId = StorageExtent.getColumnInfo("STORAGE_EXTENT_ID");
        extentId.setAutoGenerated();
        subsystemMapperInfo.setDerivedColumn(extentId);
        this.m_htAttribToMapperInfo.put(sSUBSYSTEMID, subsystemMapperInfo);
        ColumnInfo deviceIDColInfo = StorageExtent.getColumnInfo("DEVICE_ID");
        deviceIDColInfo.setIsPrimaryKey();
        MapperInfo deviceIDMapperInfo = new MapperInfo(deviceIDColInfo);
        deviceIDMapperInfo.setDerivedColumn(extentId);
        this.m_htAttribToMapperInfo.put(sDEVICEID, deviceIDMapperInfo);
        this.m_htAttribToMapperInfo.put(sNAME, new MapperInfo(StorageExtent.getColumnInfo("NAME")));
        this.m_htAttribToMapperInfo.put("DISPLAY_NAME".toLowerCase(), new MapperInfo(StorageExtent.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put(sBLOCKSIZE, new MapperInfo(StorageExtent.getColumnInfo("BLOCK_SIZE")));
        this.m_htAttribToMapperInfo.put(sNUMBEROFBLOCKS, new MapperInfo(StorageExtent.getColumnInfo("NUM_OF_BLOCKS")));
        this.m_htAttribToMapperInfo.put(sCONSUMABLEBLOCKS, new MapperInfo(StorageExtent.getColumnInfo("CONSUMABLE_BLOCKS")));
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS, new MapperInfo(StorageExtent.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_dataConverter.addCalculationDataConversion(sCAPACITY, "/", "512");
        this.m_htAttribToMapperInfo.put(sCAPACITY, new MapperInfo(StorageExtent.getColumnInfo("TOTAL_CAPACITY")));
        this.m_dataConverter.addCalculationDataConversion(sFREECAPACITY, "/", "512");
        this.m_htAttribToMapperInfo.put(sFREECAPACITY, new MapperInfo(StorageExtent.getColumnInfo("FREE_SPACE")));
        this.m_htAttribToMapperInfo.put(sSTORAGEPOOLID, new MapperInfo(StorageExtent.getColumnInfo("POOL_ID")));
        this.m_htAttribToMapperInfo.put(sELEMENTNAME, new MapperInfo(StorageExtent.getColumnInfo("ELEMENT_NAME")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String opstatus;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String capacity = (String)pParams.get(sCAPACITY);
        String mblocksize = (String)pParams.get(sBLOCKSIZE);
        String mnumberofblocks = (String)pParams.get(sNUMBEROFBLOCKS);
        if (capacity == null && mblocksize != null && mnumberofblocks != null) {
            try {
                long blocksize = Long.parseLong((String)pParams.get(sBLOCKSIZE));
                long blocks = Long.parseLong((String)pParams.get(sNUMBEROFBLOCKS));
                capacity = Long.toString(blocksize * blocks);
                pParams.put(sCAPACITY, capacity);
            }
            catch (Exception e) {
                this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", e, "Wasn't able to calculate Extent Capacity");
            }
        }
        String freecapacity = (String)pParams.get(sFREECAPACITY);
        String mconsumableblocks = (String)pParams.get(sCONSUMABLEBLOCKS);
        if (freecapacity == null && mblocksize != null && mconsumableblocks != null) {
            try {
                long blocksize = Long.parseLong((String)pParams.get(sBLOCKSIZE));
                long blocks = Long.parseLong((String)pParams.get(sCONSUMABLEBLOCKS));
                freecapacity = Long.toString(blocksize * blocks);
                pParams.put(sFREECAPACITY, freecapacity);
            }
            catch (Exception e) {
                this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", e, "Wasn't able to calculate Extent FreeCapacity");
            }
        }
        String mDisplayName = (String)pParams.get("DISPLAY_NAME".toLowerCase());
        String mName = (String)pParams.get(sNAME);
        if (mDisplayName == null && mName != null) {
            pParams.put("DISPLAY_NAME".toLowerCase(), mName);
        }
        if ((opstatus = (String)pParams.get(sOPERATIONALSTATUS)) != null) {
            Vector opArray = SMISCIM_StorageExtentToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put(sOPERATIONALSTATUS, opstatus);
            } else {
                pParams.remove(sOPERATIONALSTATUS);
            }
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        mReturnResult.addKeyReference("ref_device_id", StorageExtent.getColumnInfo("DEVICE_ID"));
        mReturnResult.addKeyReference(sSUBSYSTEMID, StorageExtent.getColumnInfo("SUBSYSTEM_ID"));
        mReturnResult.addKeyReference("ref_storageextent_id", StorageExtent.getColumnInfo("STORAGE_EXTENT_ID"));
        if (pParams.get("ref_storagevolume_id") != null) {
            Hashtable mAllRows = mReturnResult.getAllRows();
            String mExtID = (String)((Hashtable)mAllRows.get(StorageExtent.getTablename())).get(StorageExtent.getColumnInfo("STORAGE_EXTENT_ID"));
            pParams.put("ref_storageextent_id", mExtID);
            SMISVolume2ExtentToDBMapper mapper = new SMISVolume2ExtentToDBMapper();
            mReturnResult.addMapperResult(mapper.persist(pConn, pParams, pScanID));
        }
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }

    private class SMISVolume2ExtentToDBMapper
    extends DBAttributeMapper {
        public SMISVolume2ExtentToDBMapper() {
            ColumnInfo svid = Volume2extent.getColumnInfo("VOLUME_ID");
            svid.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_storagevolume_id", new MapperInfo(svid));
            ColumnInfo extid = Volume2extent.getColumnInfo("STORAGE_EXTENT_ID");
            extid.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_storageextent_id", new MapperInfo(extid));
            this.m_htAttribToMapperInfo.put("extentcount", new MapperInfo(Volume2extent.getColumnInfo("TOTAL_NUM_EXTENTS")));
        }
    }
}

