/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_StorageVolumeToDBMapper;

public class SMISHPXP_StorageVolumeToDBMapper
extends SMISCIM_StorageVolumeToDBMapper {
    public SMISHPXP_StorageVolumeToDBMapper() {
        this.m_htAttribToMapperInfo.put("UNIQUE_ID".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("UNIQUE_ID")));
    }

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "HPXP_StorageVolume";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mElementName = (String)pParams.get("elementname");
        String mTopLevelCS = (String)pParams.get("ref_toplevelsystem_name");
        if (mElementName != null && mTopLevelCS != null && mElementName.trim().length() > 0 && mTopLevelCS.trim().length() > 0) {
            String deviceId = null;
            String ssSerialNumber = mTopLevelCS;
            int col = mElementName.indexOf(58);
            if (col > -1) {
                String lunTempName = mElementName.substring(0, col) + mElementName.substring(col + 1);
                deviceId = this.charHexToDecimal(lunTempName, 6);
            }
            if (ssSerialNumber != null && deviceId != null) {
                String uniqueId = ssSerialNumber + "/" + deviceId;
                pParams.put("UNIQUE_ID".toLowerCase(), uniqueId);
            } else {
                pParams.put("UNIQUE_ID".toLowerCase(), null);
            }
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }

    private String charHexToDecimal(String strIN, int outLen) {
        String inDecimal;
        if (strIN == null) {
            return null;
        }
        char[] work = new char[outLen];
        try {
            inDecimal = Integer.toString(Integer.parseInt(strIN, 16));
        }
        catch (NumberFormatException e) {
            return null;
        }
        int inLen = inDecimal.length();
        work = new char[outLen];
        int iDiff = outLen - inLen;
        int i = 0;
        int z = 0;
        if (iDiff > 0) {
            for (i = 0; i < iDiff; ++i) {
                work[i] = 48;
            }
        }
        while (i < outLen) {
            work[i] = inDecimal.charAt(z);
            ++z;
            ++i;
        }
        return String.valueOf(work);
    }
}

