/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_ComputerSystem_TopLevelToDBMapper;

public class SMISIBMTSESS_StorageSystemToDBMapper
extends SMISCIM_ComputerSystem_TopLevelToDBMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSESS_StorageSystem";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = "15";
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public SMISIBMTSESS_StorageSystemToDBMapper() {
        this.m_htAttribToMapperInfo.put("cache", new MapperInfo(StorageSubsystem.getColumnInfo("CACHE")));
        this.m_htAttribToMapperInfo.put("codelevel", new MapperInfo(StorageSubsystem.getColumnInfo("CODE_LEVEL")));
        this.m_htAttribToMapperInfo.put("nvs", new MapperInfo(StorageSubsystem.getColumnInfo("NVS")));
        this.m_htAttribToMapperInfo.put("otheridentifyinginfo", new MapperInfo(StorageSubsystem.getColumnInfo("IP_ADDRESS")));
        this.m_htAttribToMapperInfo.put("SERIAL_NUMBER".toLowerCase(), new MapperInfo(StorageSubsystem.getColumnInfo("SERIAL_NUMBER")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String serial;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String opstatus = (String)pParams.get("otheridentifyinginfo");
        if (opstatus != null) {
            Vector opArray = SMISIBMTSESS_StorageSystemToDBMapper.processArrayvalues(opstatus);
            pParams.put("otheridentifyinginfo", (String)opArray.firstElement());
        }
        if ((serial = (String)pParams.get("name")) != null) {
            String newSerial = new String();
            String newModel = new String();
            String newType = new String();
            String osType = new String();
            StringTokenizer tokens = new StringTokenizer(serial, ".");
            if (tokens.hasMoreTokens()) {
                newModel = tokens.nextToken();
            }
            if (tokens.hasMoreTokens()) {
                newSerial = tokens.nextToken();
            }
            if (newModel.equals("2105")) {
                newType = "ESS";
                osType = String.valueOf(12);
            } else if (newModel.equals("2107")) {
                newType = "DS8000";
                osType = String.valueOf(25);
            } else if (newModel.equals("1750")) {
                newType = "DS6000";
                osType = String.valueOf(27);
            } else {
                newType = "Unknown";
                osType = String.valueOf(26);
            }
            pParams.put("SERIAL_NUMBER".toLowerCase(), newSerial);
            pParams.put("TYPE".toLowerCase(), newType);
            pParams.put("elementname", newType + "-" + newModel + "-" + newSerial + "-IBM");
            if (pParams.get("OS_TYPE".toLowerCase()) == null) {
                pParams.put("OS_TYPE".toLowerCase(), osType);
            }
        }
        if (pParams.get("CACHE".toLowerCase()) != null) {
            try {
                String bCache = (String)pParams.get("CACHE".toLowerCase());
                if (bCache.indexOf(77) > -1) {
                    bCache = bCache.substring(0, bCache.indexOf("M"));
                    long megInBytes = Long.parseLong(bCache) * 1024L * 1024L;
                    bCache = megInBytes + "";
                } else if (bCache.indexOf(71) > -1) {
                    bCache = bCache.substring(0, bCache.indexOf("G"));
                    long gigInBytes = Long.parseLong(bCache) * 1024L * 1024L * 1024L;
                    bCache = gigInBytes + "";
                } else {
                    pParams.remove("CACHE".toLowerCase());
                }
                pParams.put("CACHE".toLowerCase(), bCache);
            }
            catch (Exception e) {
                pParams.remove("CACHE".toLowerCase());
            }
        }
        if (pParams.get("NVS".toLowerCase()) != null) {
            try {
                String bNVS = (String)pParams.get("NVS".toLowerCase());
                if (bNVS.indexOf(77) > -1) {
                    bNVS = bNVS.substring(0, bNVS.indexOf("M"));
                    long megInBytes = Long.parseLong(bNVS) * 1024L * 1024L;
                    bNVS = megInBytes + "";
                } else if (bNVS.indexOf(71) > -1) {
                    bNVS = bNVS.substring(0, bNVS.indexOf("G"));
                    long gigInBytes = Long.parseLong(bNVS) * 1024L * 1024L * 1024L;
                    bNVS = gigInBytes + "";
                } else {
                    pParams.remove("NVS".toLowerCase());
                }
                pParams.put("NVS".toLowerCase(), bNVS);
            }
            catch (Exception e) {
                pParams.remove("NVS".toLowerCase());
            }
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

