/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISIBMTSSVC_BackendControllerToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSSVC_BackendController";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public SMISIBMTSSVC_BackendControllerToDBMapper() {
        this.m_htAttribToMapperInfo.put("creationclassname", new MapperInfo(BackendController.getColumnInfo("CREATION_CLASS_NAME_ID")));
        this.m_htAttribToMapperInfo.put("systemcreationclassname", new MapperInfo(BackendController.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
        ColumnInfo deviceIDColInfo = BackendController.getColumnInfo("DEVICE_ID");
        deviceIDColInfo.setIsPrimaryKey();
        MapperInfo deviceIDInfo = new MapperInfo(deviceIDColInfo);
        ColumnInfo bcAutoID = BackendController.getColumnInfo("BACKEND_CONTROLLER_ID");
        bcAutoID.setAutoGenerated();
        deviceIDInfo.setDerivedColumn(bcAutoID);
        this.m_htAttribToMapperInfo.put("deviceid", deviceIDInfo);
        ColumnInfo systemNameColInfo = BackendController.getColumnInfo("SYSTEM_NAMES_ID");
        systemNameColInfo.setIsPrimaryKey();
        MapperInfo systemNameInfo = new MapperInfo(systemNameColInfo);
        systemNameInfo.setDerivedColumn(bcAutoID);
        this.m_htAttribToMapperInfo.put("systemname", systemNameInfo);
        this.m_htAttribToMapperInfo.put("vendorid", new MapperInfo(BackendController.getColumnInfo("VENDOR_ID")));
        this.m_htAttribToMapperInfo.put("wwnn", new MapperInfo(BackendController.getColumnInfo("NODE_WWN")));
        this.m_htAttribToMapperInfo.put("operationalstatus", new MapperInfo(BackendController.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put("wwpn", new MapperInfo(BackendController.getColumnInfo("PORT_WWNS")));
        this.m_htAttribToMapperInfo.put("productserialnumber", new MapperInfo(BackendController.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("wwpnpathcount", new MapperInfo(BackendController.getColumnInfo("WWPN_PATH_COUNT")));
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(BackendController.getColumnInfo("OWNING_SUBSYSTEM_ID")));
        this.m_htAttribToMapperInfo.put("ref_referenced_toplevelsystem_id", new MapperInfo(BackendController.getColumnInfo("REFERENCED_SUBSYSTEM_ID")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String opstatus = (String)pParams.get("operationalstatus");
        if (opstatus != null) {
            Vector opArray = SMISIBMTSSVC_BackendControllerToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put("operationalstatus", opstatus);
            } else {
                pParams.remove("operationalstatus");
            }
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        mReturnResult.addKeyReference("ref_backendcontroller_id", BackendController.getColumnInfo("BACKEND_CONTROLLER_ID"));
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

