/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_StorageVolumeToDBMapper;

public class SMISLSISSI_StorageVolumeToDBMapper
extends SMISCIM_StorageVolumeToDBMapper {
    public static final String sRAIDLEVEL = "raidlevel";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "LSISSI_StorageVolume";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.1.0";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3};
    }

    public SMISLSISSI_StorageVolumeToDBMapper() {
        this.m_htAttribToMapperInfo.put(sRAIDLEVEL, new MapperInfo(TResStorageVolumeTable.getColumnInfo("REDUNDANCY")));
        this.m_dataConverter.addSimpleDataConversion("isassigned", "Boolean");
        this.m_htAttribToMapperInfo.put("isassigned", new MapperInfo(StorageVolume.getColumnInfo("IS_ASSIGNED")));
        this.m_htAttribToMapperInfo.put("UNIQUE_ID".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("UNIQUE_ID")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mRaidLevel = (String)pParams.get(sRAIDLEVEL);
        if (mRaidLevel != null) {
            if ((mRaidLevel = mRaidLevel.toLowerCase()).indexOf("raid") > -1) {
                mRaidLevel = mRaidLevel.substring("raid".length(), mRaidLevel.length());
                pParams.put(sRAIDLEVEL, mRaidLevel);
            } else {
                try {
                    Integer.parseInt(mRaidLevel);
                    pParams.put(sRAIDLEVEL, mRaidLevel);
                }
                catch (Exception e) {
                    this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", e, "Could not persist raid level!");
                }
            }
        }
        String mSystemName = (String)pParams.get("systemname");
        String mDeviceID = (String)pParams.get("deviceid");
        if (mSystemName != null && mDeviceID != null) {
            String mUniqueID = mSystemName + "/" + mDeviceID.substring(8);
            pParams.put("UNIQUE_ID".toLowerCase(), mUniqueID);
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

