/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.MaskingInfo;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISMaskingInfoToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "MaskingInfo";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMISMaskingInfoToDBMapper() {
        ColumnInfo Id = MaskingInfo.getColumnInfo("MASKING_INFO_ID");
        Id.setAutoGenerated();
        Vector<String> columns = new Vector<String>();
        columns.add("COLLECTION_ID");
        columns.add("COLLECTION_NAME");
        columns.add("CONTOLLER_COP");
        columns.add("HOST_CAPTION");
        columns.add("HOST_ID");
        columns.add("HOST_ELEMENT_NAME");
        columns.add("SETTING_DATA_ID");
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo aInfo = MaskingInfo.getColumnInfo((String)columns.elementAt(i));
            MapperInfo a = new MapperInfo(aInfo);
            a.setDerivedColumn(Id);
            this.m_htAttribToMapperInfo.put(((String)columns.elementAt(i)).toLowerCase(), a);
        }
        ColumnInfo topId = MaskingInfo.getColumnInfo("SUBSYSTEM_ID");
        MapperInfo topIdInfo = new MapperInfo(topId);
        topIdInfo.setDerivedColumn(Id);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", topIdInfo);
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        mReturnResult.addKeyReference("ref_toplevelsystem_id", MaskingInfo.getColumnInfo("SUBSYSTEM_ID"));
        mReturnResult.addKeyReference("ref_masking_info_id", MaskingInfo.getColumnInfo("MASKING_INFO_ID"));
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

