/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_DiskDriveToDBMapper;

public class SMISONTAP_DiskDriveToDBMapper
extends SMISCIM_DiskDriveToDBMapper {
    public static final String CR = "(C) Copyright IBM Corp. 2005.";
    protected final String NETAPP = "NETWORK APPLIANCE";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "ONTAP_DiskDrive";
        String mSMIS = "1.1.0";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMISONTAP_DiskDriveToDBMapper() {
        this.m_htAttribToMapperInfo.put("serialnumber", new MapperInfo(PhysicalVolume.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("capacity", new MapperInfo(PhysicalVolume.getColumnInfo("CAPACITY")));
        this.m_htAttribToMapperInfo.put("displayname", new MapperInfo(PhysicalVolume.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put("subsystemserialno", new MapperInfo(PhysicalVolume.getColumnInfo("SUBSYSTEM_SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("devicetype", new MapperInfo(PhysicalVolume.getColumnInfo("DEVICE_TYPE")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        pParams.put("model", "NETWORK APPLIANCE");
        pParams.put("manufacturer", "NETWORK APPLIANCE");
        pParams.put("devicetype", "0");
        String mdeviceID = (String)pParams.get("deviceid");
        String dName = " ";
        int indx = mdeviceID.lastIndexOf(":") + 1;
        if (indx != -1) {
            dName = mdeviceID.substring(indx);
        }
        pParams.put("displayname", dName);
        String toplevel_sys = (String)pParams.get("ref_toplevelsystem_name");
        String subsys_serialno = " ";
        pParams.put("subsystemserialno", subsys_serialno);
        if (toplevel_sys != null) {
            indx = toplevel_sys.lastIndexOf(":") + 1;
            subsys_serialno = toplevel_sys.substring(indx);
            if (indx != -1) {
                pParams.put("subsystemserialno", subsys_serialno);
            }
        }
        this.fixup_deviceId(pConn, pParams);
        String devID = (String)pParams.get("deviceid");
        if (devID != null) {
            pParams.put("serialnumber", this.prep_serialno(devID, subsys_serialno));
        } else {
            pParams.put("serialnumber", "Not in CIM XML");
        }
        this.get_capacity(pConn, pParams);
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixup_deviceId(DBConnection pConn, Hashtable pParams) {
        this.logEntry(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
        PreparedStatement dbPS = null;
        ResultSet rs = null;
        boolean ret = false;
        String dev_serialno = " ";
        String sql = "select * from T_RES_PHYSICAL_VOLUME where SERIAL_NUMBER = ?";
        String upd_sql = "update T_RES_PHYSICAL_VOLUME set DEVICE_ID = ?, SYSTEM_NAMES_ID = ?, SUBSYSTEM_ID = ? where SERIAL_NUMBER = ?";
        String dName = (String)pParams.get("displayname");
        String SS_serialno = (String)pParams.get("subsystemserialno");
        String new_devId = (String)pParams.get("deviceid");
        String system_namesId = (String)pParams.get("ref_system_names_id");
        String subsystem_Id = (String)pParams.get("ref_toplevelsystem_id");
        if (new_devId == null) {
            this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "deviceId from SMIS is not present");
            this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
            return;
        }
        if (SS_serialno == null) {
            this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "subsystem serial number from SMIS is not present");
            this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
            return;
        }
        if (dName == null) {
            this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "device name from SMIS is not present");
            this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
            return;
        }
        if (system_namesId == null) {
            this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "system name from SMIS is not present");
            this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
            return;
        }
        if (subsystem_Id == null) {
            this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "subsystem Id from SMIS is not present");
            this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
            return;
        }
        if (dName != null && SS_serialno != null) {
            dev_serialno = SS_serialno + "/" + dName + ":" + this.NETAPP;
        }
        try {
            dbPS = pConn.getConnection().prepareStatement(sql);
            int count = 1;
            dbPS.setString(count, dev_serialno);
            rs = dbPS.executeQuery();
            if (rs.next() && rs.next()) {
                this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "More than 1 disk drive record matched");
                this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
                return;
            }
            count = 1;
            dbPS = pConn.getConnection().prepareStatement(upd_sql);
            dbPS.setString(count, new_devId);
            dbPS.setString(++count, system_namesId);
            dbPS.setString(++count, subsystem_Id);
            dbPS.setString(++count, dev_serialno);
            int traceResult = dbPS.executeUpdate();
        }
        catch (SQLException e) {
            this.logException(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", e, "Error retrieving capacity from storage extent table, continue without saving capacity.");
        }
        finally {
            if (dbPS != null) {
                try {
                    rs.close();
                    dbPS.close();
                }
                catch (Exception ignore) {}
            }
        }
        this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void get_capacity(DBConnection pConn, Hashtable pParams) {
        this.logEntry(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
        PreparedStatement dbPS = null;
        ResultSet rs = null;
        boolean ret = false;
        String devID = (String)pParams.get("deviceid");
        String sql = "select TOTAL_CAPACITY from T_RES_STORAGE_EXTENT where DEVICE_ID = ? and SUBSYSTEM_ID = ?";
        try {
            dbPS = pConn.getConnection().prepareStatement(sql);
            int count = 1;
            dbPS.setString(count, devID.substring(devID.lastIndexOf(":") + 1));
            String s = (String)pParams.get("ref_toplevelsystem_id");
            dbPS.setInt(++count, Integer.parseInt(s));
            rs = dbPS.executeQuery();
            if (rs.next()) {
                count = 1;
                long cap = rs.getLong(count);
                if (rs.next()) {
                    this.logInfo(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", "More than 1 storage extent record matched");
                    this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
                    return;
                }
                pParams.put("capacity", String.valueOf(cap));
                this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
                return;
            }
            this.logInfo(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", "Did not get a matchin storage extent record");
            this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
            return;
        }
        catch (SQLException e) {
            this.logException(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", e, "Error retrieving capacity from storage extent table, continue without saving capacity.");
        }
        finally {
            if (dbPS != null) {
                try {
                    rs.close();
                    dbPS.close();
                }
                catch (Exception ignore) {}
            }
        }
        this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{pConn, pParams});
    }

    /*
     * Enabled aggressive block sorting
     */
    private String prep_serialno(String devID, String subsys_serial) {
        this.logEntry(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{devID});
        int end_comp_id = 0;
        int strt_device_name = 0;
        int strt_comp_id = devID.indexOf(":");
        if (strt_comp_id == -1) {
            this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{devID});
            return "Missing 1st :";
        }
        if ((end_comp_id = devID.indexOf(":", ++strt_comp_id)) == -1) {
            this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{devID});
            return "Missing 2nd :";
        }
        strt_device_name = devID.indexOf(":", end_comp_id + 1);
        if (strt_device_name == -1) {
            this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{devID});
            return "Missing 3rd :";
        }
        String name = subsys_serial + "/" + devID.substring(++strt_device_name) + ":NETWORK APPLIANCE";
        this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{devID});
        return name;
    }
}

