/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_StorageVolumeToDBMapper;

public class SMISONTAP_StorageVolumeToDBMapper
extends SMISCIM_StorageVolumeToDBMapper {
    public SMISONTAP_StorageVolumeToDBMapper() {
        this.m_htAttribToMapperInfo.put("UNIQUE_ID".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("UNIQUE_ID")));
    }

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "ONTAP_StorageVolume";
        String mSMIS = "1.1.0";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mSystemName = (String)pParams.get("ref_toplevelsystem_name");
        String mdeviceID = (String)pParams.get("deviceid");
        int indx = mdeviceID.lastIndexOf(":");
        String dName = "";
        if (indx != -1) {
            dName = mdeviceID.substring(1, indx);
        }
        String uniqueName = "";
        try {
            if (dName != null) {
                pParams.put("DISPLAY_NAME".toLowerCase(), dName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (mSystemName != null) {
                int col = mSystemName.lastIndexOf(58);
                uniqueName = mSystemName.substring(col + 1).trim();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (mdeviceID != null) {
                int col = mdeviceID.indexOf(58);
                uniqueName = uniqueName + "/" + mdeviceID.substring(col + 1).trim();
                pParams.put("UNIQUE_ID".toLowerCase(), uniqueName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

