/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISSwitchToDBMapper
extends DBAttributeMapper {
    private static final String sNAMEFORMAT = "nameformat";
    private static final String sNAME = "name";
    private static final String sOPERATIONALSTATUS = "operationalstatus";
    private static final String sCONSOLIDATEDSTATUS = "consolidatedstatus";
    private static final String sSWITCHNAME = "switchname";
    private static final String sCIMNAMESPACEID = "CIM_NAMESPACE_ID";
    private static final String sCREATIONCLASSNAME = "creationclassname";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_ComputerSystem";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = "5";
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMISSwitchToDBMapper() {
        ColumnInfo switchWwn = Switch.getColumnInfo("SWITCH_WWN");
        switchWwn.setIsPrimaryKey();
        MapperInfo switchMapper = new MapperInfo(switchWwn);
        ColumnInfo switchId = Switch.getColumnInfo("SWITCH_ID");
        switchId.setAutoGenerated();
        switchMapper.setDerivedColumn(switchId);
        this.m_htAttribToMapperInfo.put(sNAME.toLowerCase(), switchMapper);
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS.toLowerCase(), new MapperInfo(Switch.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(sCONSOLIDATEDSTATUS.toLowerCase(), new MapperInfo(Switch.getColumnInfo("CONSOLIDATED_STATUS")));
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String name;
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        if (conn == null || htValues == null) {
            throw new SQLException("SMISSwitchToDBMapper requires non-null values for the provided DBConnection and hashtable.");
        }
        String format = (String)htValues.get(sNAMEFORMAT.toLowerCase());
        if (format == null || !format.equalsIgnoreCase("14") && !format.equalsIgnoreCase("WWN")) {
            return new MapperResult();
        }
        String opstatus = (String)htValues.get(sOPERATIONALSTATUS);
        if (opstatus != null) {
            Vector opArray = SMISSwitchToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                htValues.put(sOPERATIONALSTATUS, opstatus);
            } else {
                htValues.remove(sOPERATIONALSTATUS);
            }
            opstatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue(opArray);
            if (opstatus != null) {
                htValues.put(sCONSOLIDATEDSTATUS.toLowerCase(), opstatus);
            }
        }
        if ((name = (String)htValues.get(sNAME.toLowerCase())) != null) {
            htValues.put(sSWITCHNAME.toLowerCase(), name);
        }
        MapperResult mSwitchResult = super.persist(conn, htValues, scanID);
        SMISCimkeySwitchToDBMapper mCIMKeyMapper = new SMISCimkeySwitchToDBMapper();
        MapperResult mResultCIMKey = mCIMKeyMapper.persist(conn, htValues, scanID);
        MapperResult mReturnResult = mSwitchResult.addMapperResult(mResultCIMKey);
        mSwitchResult.addKeyReference("ref_toplevelsystem_id", Switch.getColumnInfo("SWITCH_ID"));
        mSwitchResult.addKeyReference("ref_switch_wwn", Switch.getColumnInfo("SWITCH_WWN"));
        try {
            mSwitchResult.addKeyReference("ref_toplevelsystem_cimom2namespaceid", CimkeySwitch.getColumnInfo(sCIMNAMESPACEID));
        }
        catch (Exception e) {
            this.logInfo(this.myClassname, methodName, "CIMOM2NAMESPACEID could not be persisted - namespace ref might not have been passed in!");
        }
        this.logExit(this.myClassname, methodName, mSwitchResult);
        return mSwitchResult;
    }

    private class SMISCimkeySwitchToDBMapper
    extends DBAttributeMapper {
        public SMISCimkeySwitchToDBMapper() {
            ColumnInfo mSwitchName = CimkeySwitch.getColumnInfo("NAME");
            mSwitchName.setIsPrimaryKey();
            MapperInfo mSwitchNameMapperInfo = new MapperInfo(mSwitchName);
            this.m_htAttribToMapperInfo.put(SMISSwitchToDBMapper.sNAME, mSwitchNameMapperInfo);
            ColumnInfo mWWN = CimkeySwitch.getColumnInfo("SWITCH_WWN");
            mWWN.setIsPrimaryKey();
            MapperInfo mWWNMapperInfo = new MapperInfo(mWWN);
            ColumnInfo mCIMKeyIDInfo = CimkeySwitch.getColumnInfo("CIMKEY_SWITCH_ID");
            mCIMKeyIDInfo.setAutoGenerated();
            mWWNMapperInfo.setDerivedColumn(mCIMKeyIDInfo);
            this.m_htAttribToMapperInfo.put(SMISSwitchToDBMapper.sSWITCHNAME, mWWNMapperInfo);
            this.m_dataConverter.addSimpleDataConversion(SMISSwitchToDBMapper.sNAMEFORMAT, "SMISName_Format");
            this.m_htAttribToMapperInfo.put(SMISSwitchToDBMapper.sNAMEFORMAT, new MapperInfo(CimkeySwitch.getColumnInfo("NAME_FORMAT")));
            ColumnInfo mNSID = CimkeySwitch.getColumnInfo(SMISSwitchToDBMapper.sCIMNAMESPACEID);
            mNSID.setIsPrimaryKey();
            MapperInfo nsidMapperInfo = new MapperInfo(mNSID);
            nsidMapperInfo.setDerivedColumn(mCIMKeyIDInfo);
            this.m_htAttribToMapperInfo.put("cimnamespaceid", nsidMapperInfo);
            this.m_htAttribToMapperInfo.put(SMISSwitchToDBMapper.sCREATIONCLASSNAME, new MapperInfo(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")));
        }

        public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
            Hashtable lookup = new Hashtable();
            String val = (String)pParams.get("ref_serviceurl");
            if (val != null) {
                RegisteredCimom helper = new RegisteredCimom();
                helper.setServiceUrl(val);
                boolean retval = helper.retrieve(pConn);
                if (retval) {
                    int cimomid = helper.getRegCimomId();
                    val = (String)pParams.get("ref_namespace");
                    if (val != null) {
                        Cimom2namespace helperc2n = new Cimom2namespace();
                        helperc2n.setCimomId(cimomid);
                        helperc2n.setNamespace(val);
                        retval = helperc2n.retrieve(pConn);
                        if (retval) {
                            pParams.put("cimnamespaceid", new String(helperc2n.getCimNamespaceId() + ""));
                            MapperResult mResult = super.persist(pConn, pParams, pScanID);
                            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mResult);
                            return mResult;
                        }
                    }
                }
            }
            MapperResult mResult = new MapperResult();
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mResult);
            return mResult;
        }
    }
}

