/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SanXmlToDBMapper
extends DBAttributeMapper {
    private static final String PHYSICALINFRASTRUCTURE = "PhysicalInfrastructure";
    private static final String ZONECAP = "Zone Capability";
    private static final String ACTIVE = "Active";
    private static final String SANWWN = "San WWN";
    private static final String NAME = "Name";
    private static final String OP_STATUS = "State";
    private static final String CON_STATUS = "Con Status";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "SanXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SanXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml", ":", 2);
        this.m_dataConverter.addSimpleDataConversion(PHYSICALINFRASTRUCTURE.toLowerCase(), "Boolean");
        this.m_dataConverter.addSimpleDataConversion(ZONECAP.toLowerCase(), "SAN_Zone_Capabilities");
        this.m_dataConverter.addSimpleDataConversion(ACTIVE.toLowerCase(), "Boolean");
        this.m_htAttribToMapperInfo.put(SANWWN.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("SAN_WWN")));
        this.m_htAttribToMapperInfo.put(ZONECAP.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("SUPPORTS_ZONING")));
        this.m_htAttribToMapperInfo.put(ACTIVE.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("ACTIVE")));
        this.m_htAttribToMapperInfo.put(PHYSICALINFRASTRUCTURE.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("IS_PHYSICAL")));
        this.m_htAttribToMapperInfo.put(NAME.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("NAME")));
        this.m_htAttribToMapperInfo.put(OP_STATUS.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(CON_STATUS.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("CONSOLIDATED_STATUS")));
        ColumnInfo fabricWwn = Fabric.getColumnInfo("FABRIC_WWN");
        fabricWwn.setIsPrimaryKey();
        MapperInfo fabricMapper = new MapperInfo(fabricWwn);
        ColumnInfo fabricId = Fabric.getColumnInfo("FABRIC_ID");
        fabricId.setAutoGenerated();
        fabricMapper.setDerivedColumn(fabricId);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), fabricMapper);
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        String sniaVal = (String)htValues.get(OP_STATUS);
        if (sniaVal != null) {
            String[] smisValArr = this.convertSNIAOPStatToBitArrValue(sniaVal);
            htValues.put(OP_STATUS, smisValArr[0]);
            Vector<String> vOpStat = new Vector<String>();
            vOpStat.add(smisValArr[1]);
            String conState = DBConstants.convertOperationalstatusArrayToConsolidatedValue(vOpStat);
            if (conState != null) {
                htValues.put(CON_STATUS, conState);
            }
        }
        MapperResult mr = super.persist(conn, htValues, scanID);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

