/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.logging;

import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.AuditConfigRequest;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;

public class AuditConfigHandler {
    public static void handle(Request request, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(AuditConfigHandler.class.getName(), "handle", "request, response");
        }
        if (RequestChecker.isDesiredType(AuditConfigRequest.class, request, response)) {
            AuditConfigRequest data = (AuditConfigRequest)request.requestData;
            try {
                if (data.doSet) {
                    TraceLoggerFactory.setAuditConfig(data.configMap, data.requestCode);
                } else {
                    response.responseData = TraceLoggerFactory.getAuditConfig(data.requestCode);
                }
                response.status = 0;
            }
            catch (LocalizableException exception) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(AuditConfigHandler.class.getName(), "handle", exception);
                }
                response.errorMessage = exception.getMessage();
                response.status = (short)12;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(AuditConfigHandler.class.getName(), "handle");
        }
    }
}

