/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.request;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class SocketRegistry {
    private static boolean isActive;
    private static List registeredSockets;

    public static void activate() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SocketRegistry.class.getName(), "activate", "");
        }
        registeredSockets = new LinkedList();
        isActive = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(SocketRegistry.class.getName(), "activate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deactivate() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SocketRegistry.class.getName(), "deactivate", "");
        }
        if (!isActive) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SocketRegistry.class.getName(), "deactivate");
            }
            return;
        }
        List list = null;
        Class<SocketRegistry> clazz = SocketRegistry.class;
        synchronized (SocketRegistry.class) {
            boolean wasActive = isActive;
            if (wasActive) {
                isActive = false;
                list = registeredSockets;
                registeredSockets = null;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (wasActive && list != null) {
                for (Socket socket : list) {
                    try {
                        socket.close();
                    }
                    catch (IOException ignored) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.exception(SocketRegistry.class.getName(), "deactivate", ignored);
                    }
                }
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SocketRegistry.class.getName(), "deactivate");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Socket connect(String host, int port) throws UnknownHostException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SocketRegistry.class.getName(), "connect", "host, port");
        }
        Socket result = null;
        if (!isActive) {
            Socket traceResult = result;
            if (!TraceLogger.enableTrace) return traceResult;
            TraceLogger.exit(SocketRegistry.class.getName(), "connect", traceResult);
            return traceResult;
        }
        try {
            result = new Socket(host, port);
        }
        catch (UnknownHostException e1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(SocketRegistry.class.getName(), "connect", e1);
            }
            if (!TraceLogger.enableTrace) throw e1;
            TraceLogger.exit(SocketRegistry.class.getName(), "connect");
            throw e1;
        }
        catch (IOException e2) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(SocketRegistry.class.getName(), "connect", e2);
            }
            MessageLog.logException("GEN0040E", e2, host, new Integer(port));
        }
        if (result != null) {
            Class<SocketRegistry> e2 = SocketRegistry.class;
            // MONITORENTER : org.eclipse.aperi.request.SocketRegistry.class
            if (isActive) {
                registeredSockets.add(result);
            } else {
                block14: {
                    try {
                        result.close();
                    }
                    catch (IOException ignored) {
                        if (!TraceLogger.enableTrace) break block14;
                        TraceLogger.exception(SocketRegistry.class.getName(), "connect", ignored);
                    }
                }
                result = null;
            }
            // MONITOREXIT : e2
        }
        Socket traceResult = result;
        if (!TraceLogger.enableTrace) return traceResult;
        TraceLogger.exit(SocketRegistry.class.getName(), "connect", traceResult);
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Socket socket) throws IOException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SocketRegistry.class.getName(), "close", "socket");
        }
        Class<SocketRegistry> clazz = SocketRegistry.class;
        synchronized (SocketRegistry.class) {
            if (isActive) {
                registeredSockets.remove(socket);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            socket.close();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SocketRegistry.class.getName(), "close");
            }
            return;
        }
    }

    static {
        SocketRegistry.activate();
    }
}

