/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.request;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ReadObjectException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.common.WriteObjectException;
import org.eclipse.aperi.common.WriteObjectIOException;
import org.eclipse.aperi.request.Mogrifier;
import org.eclipse.aperi.request.NameListPacker;
import org.eclipse.aperi.request.NameListUnpacker;
import org.eclipse.aperi.request.Pack;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.ReusableObjectPool;
import org.eclipse.aperi.request.SocketRegistry;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class SocketTransceiver
extends Transceiver {
    protected static final int SENDER_TIMEOUT = 60;
    protected static final int RECEIVER_TIMEOUT = 60;
    private static final int POOLSIZE = 10;
    private static ReusableObjectPool pool = new ReusableObjectPool(10);
    private static String requestMachineName;
    private String hostName;
    private Socket socket;
    private int timeoutInSeconds;
    private InputStream inputStream = null;
    private ObjectInputStream objectInputStream;
    private OutputStream outputStream = null;
    private ObjectOutputStream objectOutputStream;
    private static Mogrifier nameListPacker;
    private static Mogrifier nameListUnpacker;

    private static boolean shouldTransform(Object obj) {
        return obj instanceof CreateHeader || obj instanceof Pack;
    }

    private static void transformSerializable(Object obj, Mogrifier mogrifier) {
        Field[] fields = obj.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if ((fields[i].getModifiers() & 8) != 0) continue;
            try {
                Object fieldValue = fields[i].get(obj);
                if (!mogrifier.transformable(fieldValue)) continue;
                fieldValue = mogrifier.transform(fieldValue);
                fields[i].set(obj, fieldValue);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static void packSerializable(Object obj) {
        if (obj instanceof CreateHeader) {
            SocketTransceiver.transformSerializable(obj, nameListPacker);
        }
        if (obj instanceof Pack) {
            ((Pack)obj).pack();
        }
    }

    private static void unpackSerializable(Object obj) {
        if (obj instanceof CreateHeader) {
            SocketTransceiver.transformSerializable(obj, nameListUnpacker);
        }
        if (obj instanceof Pack) {
            ((Pack)obj).unpack();
        }
    }

    private String getPeerHostName() {
        String peer = this.hostName;
        if (peer == null && this.socket != null) {
            peer = this.socket.getInetAddress().getHostAddress();
        }
        return peer;
    }

    private void logError(String id) {
        MessageLog.logMessage(id, this.getPeerHostName());
    }

    private void logError(String id, Throwable e) {
        this.logError(id);
        if (!(e instanceof LocalizableException)) {
            MessageLog.getThreadLog().println("                         " + e.getMessage());
        } else {
            LocalizableException ex = (LocalizableException)e;
            ex.print();
        }
    }

    private void logError(String id, String additionalMessage) {
        this.logError(id);
        MessageLog.getThreadLog().println("                         " + additionalMessage);
    }

    public SocketTransceiver(Socket pSocket, String pHostName, int timeoutInSeconds) {
        this.init(pSocket, pHostName, timeoutInSeconds);
    }

    public SocketTransceiver(Socket pSocket, String pHostName) {
        this.init(pSocket, pHostName, 60);
    }

    public SocketTransceiver(Socket pSocket) {
        this.init(pSocket, null, 60);
    }

    protected void init(Socket pSocket, String pHostName, int pTimeoutInSeconds) {
        this.socket = pSocket;
        this.hostName = pHostName;
        this.timeoutInSeconds = pTimeoutInSeconds;
        if (this.timeoutInSeconds > 0) {
            try {
                this.socket.setSoTimeout(this.timeoutInSeconds * 1000);
            }
            catch (SocketException e) {
                this.logError("GEN0033W", e);
            }
        }
    }

    public static SocketTransceiver getSocketTransceiver(Socket pSocket, String pHostName, int timeoutInSeconds) {
        SocketTransceiver transceiver = (SocketTransceiver)pool.getObject();
        if (transceiver == null) {
            return new SocketTransceiver(pSocket, pHostName, timeoutInSeconds);
        }
        transceiver.init(pSocket, pHostName, timeoutInSeconds);
        return transceiver;
    }

    public static SocketTransceiver getSocketTransceiver(Socket pSocket, String pHostName) {
        return SocketTransceiver.getSocketTransceiver(pSocket, pHostName, 60);
    }

    public static SocketTransceiver getSocketTransceiver(Socket pSocket) {
        return SocketTransceiver.getSocketTransceiver(pSocket, null, 60);
    }

    public void returnTransceiver() {
        pool.returnObject(this);
    }

    protected void clear() {
        this.socket = null;
        this.hostName = null;
        this.objectInputStream = null;
        this.objectOutputStream = null;
        this.timeoutInSeconds = -1;
        this.outputStream = null;
        this.inputStream = null;
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    private void obtainInputStream() {
        if (this.inputStream != null) {
            return;
        }
        try {
            this.inputStream = new BufferedInputStream(this.socket.getInputStream());
        }
        catch (IOException e) {
            this.logError("GEN0005E", e);
        }
    }

    private void obtainObjectInputStream(InputStream in) throws ObjectStreamException, IOException {
        if (this.objectInputStream == null) {
            this.objectInputStream = new ObjectInputStream(in);
        }
    }

    private void obtainOutputStream() {
        if (this.outputStream != null) {
            return;
        }
        try {
            this.outputStream = this.socket.getOutputStream();
        }
        catch (IOException e) {
            this.logError("GEN0006E", e);
        }
    }

    private void obtainObjectOutputStream(OutputStream out) throws IOException {
        if (this.objectOutputStream == null && out != null) {
            this.objectOutputStream = new ObjectOutputStream(out);
        }
    }

    private Object readObject(Request request) throws ReadObjectException {
        Object result = null;
        if (this.inputStream == null) {
            this.obtainInputStream();
        }
        try {
            if (this.objectInputStream == null) {
                this.obtainObjectInputStream(this.inputStream);
            }
            result = this.objectInputStream.readObject();
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{this.getPeerHostName()};
            throw new ReadObjectException("GEN0015E", args, e.toString());
        }
        catch (IOException e) {
            Object[] args = new Object[]{this.getPeerHostName()};
            throw new ReadObjectException("GEN0008E", args, e.toString());
        }
        catch (Exception e) {
            Object[] args = new Object[]{this.getPeerHostName()};
            e.printStackTrace();
            throw new ReadObjectException("GEN0008E", args, e.toString());
        }
        return result;
    }

    public Request receiveRequest() {
        Request result = null;
        this.obtainInputStream();
        Object uncast = null;
        try {
            uncast = this.readObject(null);
        }
        catch (ReadObjectException e) {
            MessageLog.logException(e);
        }
        if (uncast == null) {
            return null;
        }
        try {
            result = (Request)uncast;
        }
        catch (ClassCastException e) {
            result = null;
        }
        if (result == null) {
            return null;
        }
        this.hostName = result.machineName;
        if (SocketTransceiver.shouldTransform(result.requestData)) {
            SocketTransceiver.unpackSerializable(result.requestData);
        }
        return result;
    }

    public Object receiveData(Request request) {
        Object result = null;
        try {
            this.checkTwoPhase(request);
            result = this.readObject(request);
        }
        catch (ReadObjectException roE) {
            Object[] peer = new String[]{this.getPeerHostName()};
            StorageException e = new StorageException("GEN0323E", peer);
            e.addException(roE);
            MessageLog.logException(e);
        }
        catch (LocalizableException e) {
            this.logError("GEN0024I", e);
            return null;
        }
        catch (Error e) {
            MessageLog.logMessage("GEN0173E", request.getClass());
            this.logRequestInfo(request);
            throw e;
        }
        if (result == null) {
            MessageLog.logMessage("GEN7070I", request.toString());
        } else if (SocketTransceiver.shouldTransform(result)) {
            SocketTransceiver.unpackSerializable(result);
        }
        return result;
    }

    public boolean writeObject(Object object, int targetCID) {
        boolean result = false;
        try {
            this.obtainOutputStream();
            result = this.writeObject(object, null);
        }
        catch (WriteObjectException e) {
            Object[] args = new Object[]{this.getPeerHostName()};
            StorageException sE = new StorageException("GEN0325E", args);
            sE.addException(e);
            MessageLog.logException(sE);
        }
        return result;
    }

    public boolean writeObject(Object object, Request request) throws WriteObjectException {
        boolean result = false;
        try {
            this.obtainOutputStream();
            this.obtainObjectOutputStream(this.outputStream);
            if (this.objectOutputStream == null) {
                String host = this.getPeerHostName();
                throw new IOException("Cannot get output stream to host " + host);
            }
            this.objectOutputStream.writeObject(object);
            this.objectOutputStream.flush();
            result = true;
        }
        catch (ObjectStreamException e) {
            Object[] args = new Object[]{this.getPeerHostName()};
            throw new WriteObjectException("GEN0009E", args, null, e);
        }
        catch (IOException e) {
            Object[] args = new Object[]{this.getPeerHostName()};
            throw new WriteObjectIOException("GEN0010E", args, null, e);
        }
        catch (Error e) {
            MessageLog.logMessage("GEN0177E", e.getClass());
            if (object instanceof Request) {
                this.logRequestInfo((Request)object);
            }
            MessageLog.logMessage("GEN0175E", object.getClass());
            if (object instanceof Response && (object = ((Response)object).responseData) != null) {
                MessageLog.logMessage("GEN0176E", object.getClass());
            }
            throw e;
        }
        return result;
    }

    private void logTransmitExplanation(Request request, int phase) {
        if (phase == 0) {
            MessageLog.logMessage("GEN7071I", request.toString());
        } else {
            MessageLog.logMessage("GEN7072I", request.toString(), new Integer(phase));
        }
    }

    private Response doPhase(Request request, Object toWrite, int phase) throws StorageException {
        Object uncast = null;
        try {
            this.writeObject(toWrite, request);
        }
        catch (StorageException e) {
            try {
                this.readObject(request);
            }
            catch (StorageException expected) {
                // empty catch block
            }
            throw e;
        }
        uncast = this.readObject(request);
        if (uncast == null) {
            this.logTransmitExplanation(request, phase);
            return null;
        }
        Response result = null;
        try {
            result = (Response)uncast;
        }
        catch (ClassCastException e) {
            this.logError("GEN0014E", e);
            this.logTransmitExplanation(request, phase);
        }
        if (result == null) {
            return result;
        }
        if (result.status != 0 && result.status != 96) {
            this.logError("GEN0018I");
            this.logReceivedResponse(result);
            this.logTransmitExplanation(request, phase);
        }
        if (result.status <= 4) {
            try {
                this.checkReceivedResponse(request, phase, result);
                if (SocketTransceiver.shouldTransform(result.responseData)) {
                    SocketTransceiver.unpackSerializable(result.responseData);
                }
            }
            catch (LocalizableException e) {
                this.logError("GEN0024I", e);
                result.status = (short)12;
            }
        }
        return result;
    }

    public Response transmitRequest(Request request, Object requestData) {
        Object rd;
        int phase;
        this.obtainOutputStream();
        if (request.machineName == null) {
            request.machineName = requestMachineName;
        }
        if (requestData == null) {
            phase = 0;
            rd = request.requestData;
        } else {
            phase = 1;
            rd = requestData;
        }
        boolean needXform = SocketTransceiver.shouldTransform(rd);
        if (needXform) {
            SocketTransceiver.packSerializable(rd);
        }
        Response response = null;
        try {
            response = this.doPhase(request, request, phase);
            if (requestData != null && response != null && response.status != 96 && response.status <= 4) {
                phase = 2;
                response = this.doPhase(request, requestData, phase);
            }
        }
        catch (StorageException sE) {
            String host = this.getPeerHostName();
            MessageLog.logMessage("GEN7073E", request.toString(), host);
            MessageLog.logException(sE);
            response = null;
        }
        catch (Error e) {
            MessageLog.logMessage("GEN0173E", request.getClass());
            this.logRequestInfo(request);
            throw e;
        }
        if (needXform) {
            SocketTransceiver.unpackSerializable(rd);
        }
        return response;
    }

    public boolean transmitResponse(Request request, Response response) {
        if (response.status != 0) {
            this.logResponse(request, response);
        }
        try {
            this.checkResponseToSend(request, response);
        }
        catch (LocalizableException e) {
            this.logError("GEN0024I", e);
            return false;
        }
        if (response.responseData instanceof NameList) {
            response.responseData = NameList.packList((NameList)response.responseData);
        }
        if (SocketTransceiver.shouldTransform(response.responseData)) {
            SocketTransceiver.packSerializable(response.responseData);
        }
        boolean result = false;
        try {
            result = this.writeObject((Object)response, request);
        }
        catch (WriteObjectException e) {
            MessageLog.logException(e);
        }
        catch (Error e) {
            MessageLog.logMessage("GEN0177E", e.getClass());
            this.logRequestInfo(request);
            MessageLog.logMessage("GEN0175E", request.getClass());
            throw e;
        }
        if (!result) {
            MessageLog.logMessage("GEN7074I", request.toString());
        }
        return result;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public boolean close() {
        boolean result;
        IOException ex;
        block9: {
            ex = null;
            if (this.objectOutputStream != null) {
                try {
                    this.objectOutputStream.close();
                }
                catch (IOException e) {
                    ex = e;
                }
            }
            if (this.socket != null) {
                try {
                    if (Variables.whoAmI == 2) {
                        SocketRegistry.close(this.socket);
                    } else {
                        this.socket.close();
                    }
                }
                catch (IOException e) {
                    if (ex != null) break block9;
                    ex = e;
                }
            }
        }
        boolean bl = result = ex == null;
        if (!result) {
            this.logError("GEN0021E", MessageLog.getMessageNoID("AGT0017E"));
        }
        this.clear();
        return result;
    }

    private void logRequestInfo(Request request) {
        if (request == null) {
            return;
        }
        MessageLog.logMessage("GEN7075E", request.toString());
        if (request.requestData == null) {
            return;
        }
        MessageLog.logMessage("GEN0174E", request.requestData.getClass());
        if (request.requestData instanceof GuiReportReq) {
            GuiReportReq grr = (GuiReportReq)request.requestData;
            MessageLog.logMessage("GEN0178E", Integer.toString(grr.reportType), Integer.toString(grr.reportSubtype));
        } else if (request.requestData instanceof GuiListReq) {
            GuiListReq glr = (GuiListReq)request.requestData;
            MessageLog.logMessage("GEN0179E", Integer.toString(glr.listRequested));
        }
    }

    static {
        try {
            requestMachineName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            requestMachineName = "unknown";
        }
        nameListPacker = new NameListPacker();
        nameListUnpacker = new NameListUnpacker();
    }
}

