/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.cmdline;

import java.text.BreakIterator;
import java.util.Vector;
import org.eclipse.aperi.sanmgmt.cmdline.Column;
import org.eclipse.aperi.sanmgmt.cmdline.ColumnManager;

public class BlockFormatter {
    static final boolean DEBUG = false;
    static final String NEWLINE = "\n";
    static final String BLANK = " ";
    static final char SPACE = ' ';
    static StringBuffer debugColumnManager;
    String seperator = " ";
    ColumnManager cm = ColumnManager.getManager();
    Column column;
    Vector columns = new Vector();
    BreakIterator charBreak = BreakIterator.getCharacterInstance();
    BreakIterator wordBreak = BreakIterator.getWordInstance();
    StringBuffer output = new StringBuffer();
    StringBuffer pad = new StringBuffer();

    private void init() {
        this.seperator = BLANK;
    }

    public String format(String[] input, int[] width) throws Exception {
        return this.format(input, width, this.seperator);
    }

    public String format(String[] input, int[] width, String seperator) throws Exception {
        int i;
        this.init();
        if (input.length != width.length || input.length == 0) {
            throw new Exception("Invalid input");
        }
        if (seperator != null) {
            this.seperator = seperator;
        }
        this.columns.removeAllElements();
        for (int i2 = 0; i2 < input.length; ++i2) {
            this.column = this.cm.getColumn();
            this.column.initColumn(input[i2], width[i2]);
            this.columns.add(this.column);
            this.column = null;
        }
        int nColumnsCompleted = 0;
        boolean done = false;
        this.output.setLength(0);
        while (!done) {
            nColumnsCompleted = 0;
            for (i = 0; i < this.columns.size(); ++i) {
                int substringEnd;
                int substringBegin;
                this.column = (Column)this.columns.get(i);
                if (this.column.isAtEnd()) {
                    this.output.append(this.getPadding(this.column.getWidth()));
                    ++nColumnsCompleted;
                } else if (this.column.getEnd() - this.column.getCurrBegin() <= this.column.getWidth()) {
                    substringBegin = this.column.getCurrBegin();
                    substringEnd = this.column.getEnd();
                    this.output.append(this.column.getText().substring(substringBegin, substringEnd));
                    this.output.append(this.getPadding(this.column.getWidth() - (substringEnd - substringBegin)));
                    this.column.isAtEnd(true);
                    ++nColumnsCompleted;
                } else {
                    int findBreakBefore = this.column.getCurrBegin() + this.column.getWidth();
                    this.wordBreak.setText(this.column.getText());
                    int breakPoint = this.wordBreak.preceding(findBreakBefore);
                    if (breakPoint > this.column.getCurrBegin() && breakPoint != -1) {
                        substringBegin = this.column.getCurrBegin();
                        substringEnd = breakPoint;
                        this.output.append(this.column.getText().substring(substringBegin, substringEnd));
                        this.output.append(this.getPadding(this.column.getWidth() - (substringEnd - substringBegin)));
                        this.column.setCurrBegin(substringEnd);
                    } else {
                        this.charBreak.setText(this.column.getText());
                        breakPoint = this.charBreak.preceding(findBreakBefore);
                        if (breakPoint > this.column.getCurrBegin() && breakPoint != -1) {
                            substringBegin = this.column.getCurrBegin();
                            substringEnd = breakPoint;
                            this.output.append(this.column.getText().substring(substringBegin, substringEnd));
                            this.output.append(this.getPadding(this.column.getWidth() - (substringEnd - substringBegin)));
                            this.column.setCurrBegin(substringEnd);
                        } else {
                            throw new Exception("Formatting failed");
                        }
                    }
                }
                if (i == this.columns.size() - 1) continue;
                this.output.append(seperator);
            }
            this.output.append(NEWLINE);
            if (nColumnsCompleted < this.columns.size()) continue;
            done = true;
        }
        for (i = 0; i < this.columns.size(); ++i) {
            this.cm.returnColumn((Column)this.columns.get(i));
        }
        return this.output.toString();
    }

    private StringBuffer getPadding(int length) {
        this.pad.setLength(0);
        for (int i = 0; i < length; ++i) {
            this.pad.append(' ');
        }
        return this.pad;
    }
}

