/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.dbconnparms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.cmdline.BlockFormatter;
import org.eclipse.aperi.sanmgmt.dbconnparms.DBAccess;
import org.eclipse.aperi.sanmgmt.dbconnparms.data.DBConnPoolParms;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.ICallback;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.MiddlewareCrypto;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.util.SRMCrypto;
import org.sblim.wbem.util.GlobalProperties;

public class ConfigService
implements IConfigService,
IService,
ICliDispatcher {
    private static final long serialVersionUID = 20001130L;
    private static String className = "ConfigService";
    private DBConnPoolParms dbPoolParms = new DBConnPoolParms();
    private Properties dbProps = new Properties();
    private Properties setupProps = new Properties();
    private Properties userProps = new Properties();
    private Properties internalProps = new Properties();
    private Properties schedulerProps = new Properties();
    private Properties allTpcProps = new Properties();
    protected static ILogger traceLogger = null;
    protected static ILogger messageLogger = null;
    static final String TRACE_NAME = "aperi.logger.trace.dbparms";
    static final String MESSAGE_NAME = "aperi.logger.message.dbparms";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.dbconnparms.resources.SANDBParmsService";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.dbconnparms.resources.SANDBParmsText";
    private ResourceBundle rb = null;
    private static final String description = "Generic services for getting and saving application properties";
    public Status status = new Status(5, 9);
    public String propBaseFn = null;
    private boolean isManager = false;
    private Hashtable registerTable = new Hashtable();
    public static final String dbFile = "tsnmdbparms.properties";
    public static final String userFile = "user.properties";
    public static final String setupFile = "setup.properties";
    public static final String internalFile = "internal.properties";

    public native int[] exec(String var1, String[] var2, String[] var3, String var4, String var5, String var6, int var7, boolean var8, boolean var9);

    public ConfigService() {
        this.rb = ResourceBundle.getBundle(TEXT_BUNDLENAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        messageLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        messageLogger.setMessageFile(BUNDLENAME);
        className = this.getClass().getName();
    }

    public String getName() {
        return "ConfigService";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("ConfigService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("ConfigService_Description");
    }

    public DBConnPoolParms getParms() {
        return this.dbPoolParms;
    }

    public String getVersion() {
        return "5.0.0";
    }

    private void updateDB(String key, String value) throws SQLException {
        DBAccess dba = new DBAccess();
        dba.updateDB(key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readConnectionProps(String propFn, Properties loadProps) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "readConnectionProps", "entered");
        }
        int retCode = 0;
        FileInputStream in = null;
        try {
            if (this.isManager && (propFn == null || propFn.length() == 0)) {
                DBAccess dba = new DBAccess();
                dba.getProperties(null, loadProps);
            } else if (new File(propFn).exists()) {
                in = new FileInputStream(propFn);
                loadProps.load(in);
            }
            if (traceLogger.isLogging()) {
                String savePw = this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbPassword");
                if (savePw != null) {
                    this.dbProps.put("tivoli.sanmgmt.jdbc.dbPassword", "********");
                }
                for (String string : loadProps.keySet()) {
                    String value = loadProps.getProperty(string);
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, this, "readConnectionProps", "SAN DB Connection parm: " + string + " = " + value);
                }
                if (savePw != null) {
                    this.dbProps.put("tivoli.sanmgmt.jdbc.dbPassword", savePw);
                }
            }
            messageLogger.message(IRecordType.TYPE_INFO, (Object)className, "readConnectionProps", "DBParms_successfulReadingParms", propFn);
        }
        catch (Exception e) {
            messageLogger.message(IRecordType.TYPE_ERR, (Object)className, "readConnectionProps", "DBParms_errorReadingParms", propFn);
            messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "readConnectionProps", e);
            retCode = -1;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "readConnectionProps", e);
                }
            }
            in = null;
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "readConnectionProps", "exited");
            }
        }
        return retCode;
    }

    public boolean shutdown() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "shutdown", "entered");
        }
        this.status.setRunStatus(11);
        if (this.isManager) {
            DBAccess dba = new DBAccess();
            dba.closeDS();
        }
        this.status.setRunStatus(10);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "shutdown", "exited");
        }
        return true;
    }

    public boolean startup() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "startup", "entered");
        }
        boolean startOK = true;
        this.propBaseFn = Variables.getConfigurationDirectory() + "/";
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, this, "startup", "reading parms from " + this.propBaseFn);
        }
        int retCode1 = this.readConnectionProps(this.propBaseFn + setupFile, this.setupProps);
        this.processSetupParms();
        this.readConnectionProps(this.propBaseFn + userFile, this.userProps);
        this.processUserParms();
        String type = this.setupProps.getProperty("tsnm.type", "");
        if (type.equals("manager")) {
            this.isManager = true;
        }
        int retCode2 = 0;
        int retCode3 = 0;
        int retCode4 = 0;
        if (this.isManager) {
            retCode2 = this.readConnectionProps(this.propBaseFn + dbFile, this.dbProps);
            this.processDBParms();
            DBAccess dba = new DBAccess();
            retCode3 = this.readConnectionProps(this.propBaseFn + internalFile, this.internalProps);
            this.processInternalParms();
            retCode4 = this.readConnectionProps(null, this.allTpcProps);
        }
        if (retCode1 + retCode2 + retCode3 + retCode4 != 0) {
            this.status.setRunStatus(2);
            startOK = false;
        } else {
            this.status.setRunStatus(8);
            messageLogger.message(IRecordType.TYPE_INFO, this, "startup", "SANDBParmsService_ready");
        }
        if (this.isManager) {
            String id = this.getProperty("server_id", "database");
            String password = this.getProperty("installationPass", "setup");
            DBAccess dba = new DBAccess();
            dba.syncInstallPassword(id, password);
            this.setCIMClientProperties();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "startup", "exiting");
        }
        return startOK;
    }

    private void setFabricProperties(String fileName, String keyName, String keyValue) {
        block9: {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setFabricProperties", "entered");
            }
            if (this.isManager && (fileName == null || fileName.trim().length() == 0)) {
                try {
                    this.updateDB(keyName, keyValue);
                }
                catch (SQLException e) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "setFabricProperties-updateDB", e);
                    }
                    break block9;
                }
            }
            File f = new File(fileName);
            if (f.exists()) {
                try {
                    FileInputStream fin = new FileInputStream(f);
                    Properties p = new Properties();
                    p.load(fin);
                    fin.close();
                    p.setProperty(keyName, keyValue);
                    FileOutputStream fo = new FileOutputStream(f);
                    p.store(fo, "Fabric properties file");
                    fo.close();
                }
                catch (Exception e) {
                    if (!traceLogger.isLogging()) break block9;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "dispatch(setAuthenticationPw)", e);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setFabricProperties", "exited");
        }
    }

    public String setAuthenticationPw(String pw) {
        String output;
        block5: {
            output = "";
            String fabricPropertiesFile = "";
            String defaultAppDir = System.getProperty("default.appdir", "");
            int step = 0;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setAuthenticationPw", "entered");
            }
            try {
                String encryptedPw = SRMCrypto.encrypt(pw);
                ++step;
                this.setProperty("installationPass", "setup", encryptedPw);
                ++step;
                MiddlewareCrypto.setPassword(encryptedPw);
                String id = this.getProperty("server_id", "database");
                if (this.isManager) {
                    DBAccess dba = new DBAccess();
                    dba.syncInstallPassword(id, encryptedPw);
                }
                output = this.rb.getString("installationPass_OK");
            }
            catch (Exception e) {
                output = step > 1 ? this.rb.getString("setAuthNotOK2") : this.rb.getString("setAuthNotOK1");
                if (!traceLogger.isLogging()) break block5;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "dispatch(setAuthenticationPw)", e);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setAuthenticationPw", "exited");
        }
        return output;
    }

    private String setPw(String pw) {
        String output;
        block4: {
            output = "";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setPw", "entered");
            }
            try {
                String encryptedPw = SRMCrypto.encrypt(pw);
                this.setProperty("tivoli.sanmgmt.jdbc.dbPassword", "database", encryptedPw);
                this.dbPoolParms.setPassword(encryptedPw);
                output = this.rb.getString("setOk");
            }
            catch (Exception e) {
                if (!traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "dispatch(setPw)", e);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setPw", "exited");
        }
        return output;
    }

    private String setSinglePw(String[] args) {
        String option = args[0].toLowerCase();
        String output = this.rb.getString("invalid");
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setSinglePw", "entered");
        }
        if (option.equals("-all")) {
            output = this.setAuthenticationPw(args[1]);
            output = this.isManager ? output + "\n" + this.setPw(args[1]) : output + "\n" + this.rb.getString("notManager");
        }
        if (option.equals("-db2")) {
            output = this.setPw(args[1]);
        }
        if (option.equals("-auth")) {
            output = this.setAuthenticationPw(args[1]);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setSinglePw", "exited");
        }
        return output;
    }

    private String setPassword(String methodName, String[] args) {
        String output = "";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setPassword", "entered");
        }
        if (methodName.toLowerCase().equals("setauthenticationpw")) {
            output = args.length != 1 ? this.rb.getString("invalid") : this.setAuthenticationPw(args[0]);
        }
        if (methodName.toLowerCase().equals("setpw")) {
            output = args.length != 1 ? this.rb.getString("invalid") : this.setPw(args[0]);
        }
        if (methodName.toLowerCase().equals("setsinglepw")) {
            output = args.length != 2 ? this.rb.getString("invalid") : this.setSinglePw(args);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setPassword", "exited");
        }
        return output;
    }

    /*
     * Unable to fully structure code
     */
    public String dispatch(String methodName, String[] args) {
        if (ConfigService.traceLogger.isLogging()) {
            ConfigService.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "dispatch", "entered");
        }
        output = "";
        if ((methodName = methodName.toLowerCase()).equals("setauthenticationpw")) {
            output = this.setPassword(methodName, args);
        } else if (methodName.equals("help")) {
            try {
                fmt = new BlockFormatter();
                twoColumnMessageString1 = new String[]{"display", this.rb.getString("help5")};
                twoColumnMessageString2 = new String[]{"get", this.rb.getString("help6")};
                twoColumnMessageString3 = new String[]{"set", this.rb.getString("help7") + " " + this.rb.getString("valid")};
                twoColumnMessageString4 = new String[]{"setPw", this.rb.getString("help9")};
                twoColumnMessageString5 = new String[]{"setAuthenticationPw", this.rb.getString("help11")};
                twoColumnMessageString6 = new String[]{"setSinglePw", this.rb.getString("help13")};
                options = new int[]{20, 53};
                output = this.rb.getString("header") + "\n" + this.rb.getString("header1") + "\n" + "\n" + this.rb.getString("help") + "\n" + this.rb.getString("help1") + "\n" + this.rb.getString("help2") + "\n" + this.rb.getString("help3") + "\n" + this.rb.getString("help8") + "\n" + this.rb.getString("help10") + "\n" + this.rb.getString("help12") + "\n" + "\n" + this.rb.getString("help15") + "\n" + "\n" + this.rb.getString("help4") + "\n" + fmt.format(twoColumnMessageString1, options) + fmt.format(twoColumnMessageString2, options) + fmt.format(twoColumnMessageString3, options) + fmt.format(twoColumnMessageString4, options) + fmt.format(twoColumnMessageString5, options) + fmt.format(twoColumnMessageString6, options);
            }
            catch (Exception e) {
                if (ConfigService.traceLogger.isLogging()) {
                    ConfigService.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "dispatch(help)", e);
                }
            }
        } else {
            if (this.isManager) {
                if (methodName.equals("set")) {
                    if (args.length != 2) {
                        output = this.rb.getString("invalid");
                    } else {
                        tempStr = args[0].toLowerCase();
                        if (tempStr.equals("snmptrapport") || tempStr.equals("hostpollinginterval") || tempStr.equals("snmpcommunityname") || tempStr.equals("fullattributescan") || tempStr.equals("srmurl") || tempStr.equals("outbandagentmonitorinterval") || tempStr.equals("snmpwritecommunityname") || tempStr.equals("snmpdefaults") || tempStr.equals("snmptimeouttracing") || tempStr.equals("snmptrace") || tempStr.equals("snmpretrycount") || tempStr.equals("snmpinitialtimeout") || tempStr.equals("performswitchping") || tempStr.equals("itsanmcapabilityscanretrycount") || tempStr.equals("itsanmqueryretrycount") || tempStr.equals("itsanmretrydelay")) {
                            valOk = true;
                            if (tempStr.equals("fullattributescan")) {
                                tempVal = args[1].toLowerCase();
                                valOk = tempVal.equals("never") != false || tempVal.equals("always") != false || tempVal.equals("pollnow") != false || tempVal.equals("timebased") != false || tempVal.equals("pollnowandtimebased") != false;
                            }
                            if (tempStr.equals("performswitchping")) {
                                tempVal = args[1].toLowerCase();
                                valOk = tempVal.equals("y") != false || tempVal.equals("n") != false || tempVal.equals("yes") != false || tempVal.equals("no") != false;
                            }
                            if (tempStr.equals("snmptrace") || tempStr.equals("snmptimeouttracing")) {
                                tempVal = args[1].toLowerCase();
                                valOk = tempVal.equals("on") != false || tempVal.equals("off") != false;
                            }
                            output = valOk ? ((ret = this.setProperty(args[0], "user", args[1])) == 0 ? this.rb.getString("saved") : this.rb.getString("errorSaving")) : this.rb.getString("badValue") + " " + this.rb.getString("valid1");
                        } else {
                            output = this.rb.getString("badProperty") + " " + this.rb.getString("valid");
                        }
                    }
                } else if (methodName.equals("get")) {
                    if (args.length != 1) {
                        output = this.rb.getString("invalid");
                    } else {
                        temp = this.getProperty(args[0], "user");
                        output = this.rb.getString("gotOk") + temp;
                    }
                } else if (methodName.equals("display")) {
                    try {
                        options = new int[]{40, 20};
                        tempStr = null;
                        twoColumnMessageString = new String[]{null, null};
                        fmt = new BlockFormatter();
                        output = this.rb.getString("header") + "\n" + this.rb.getString("header1") + "\n" + "\n" + this.rb.getString("displayHeader") + "\n";
                        e = this.userProps.keys();
                        while (e.hasMoreElements()) {
                            twoColumnMessageString[0] = tempStr = e.nextElement().toString();
                            twoColumnMessageString[1] = this.userProps.getProperty(tempStr);
                            output = output + fmt.format(twoColumnMessageString, options);
                        }
                    }
                    catch (Exception e) {
                        if (!ConfigService.traceLogger.isLogging()) ** GOTO lbl85
                        ConfigService.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "dispatch(display)", e);
                    }
                } else if (methodName.equals("setpw") || methodName.equals("setsinglepw")) {
                    output = this.setPassword(methodName, args);
                } else if (methodName.equals("setsnmpdefaults")) {
                    ret = this.setProperty("SnmpTimeoutTracing", "user", "OFF");
                    ret += this.setProperty("SnmpTrace", "user", "OFF");
                    ret += this.setProperty("SnmpRetryCount", "user", "3");
                    ret += this.setProperty("SnmpInitialTimeout", "user", "1000");
                    ret += this.setProperty("PerformSwitchPing", "user", "NO");
                    ret += this.setProperty("ITSANMCapabilityScanRetryCount", "user", "1");
                    ret += this.setProperty("ITSANMQueryRetryCount", "user", "2");
                    output = (ret += this.setProperty("ITSANMRetryDelay", "user", "100")) == 0 ? this.rb.getString("saved") : this.rb.getString("errorSaving");
                } else {
                    output = this.rb.getString("badCommand");
                }
            } else {
                output = this.rb.getString("notManager");
            }
lbl85:
            // 12 sources

            if (ConfigService.traceLogger.isLogging()) {
                ConfigService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "disptach", "exited");
            }
        }
        return output;
    }

    public void processSetupParms() {
    }

    public void processUserParms() {
    }

    public void processInternalParms() {
    }

    public void processDBParms() {
        int poolMax;
        int poolMin;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "processDBParms", "entered");
        }
        try {
            poolMin = Integer.parseInt(this.dbProps.getProperty("tivoli.sanmgmt.jdbc.conpool.min", "2"));
        }
        catch (Exception e) {
            poolMin = 2;
        }
        this.dbPoolParms.setPoolMin(poolMin);
        try {
            poolMax = Integer.parseInt(this.dbProps.getProperty("tivoli.sanmgmt.jdbc.conpool.max", "10"));
        }
        catch (Exception e) {
            poolMax = 10;
        }
        this.dbPoolParms.setPoolMax(poolMax);
        String dbType = this.dbProps.getProperty("tivoli.sanmgmt.jdbc.database");
        this.dbPoolParms.setDbType(dbType);
        String netDriver = this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbDriver");
        this.dbPoolParms.setDriver(netDriver);
        String tempUrl = this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbURL");
        this.dbPoolParms.setUrl(tempUrl);
        boolean linux = false;
        String osName = System.getProperty("os.name");
        traceLogger.text(IRecordType.TYPE_INFO, this, "processDBParms", osName);
        if (osName.toLowerCase().startsWith("linux")) {
            linux = true;
            traceLogger.text(IRecordType.TYPE_INFO, this, "processDBParms", "Linux Fabric Manager");
        } else {
            traceLogger.text(IRecordType.TYPE_INFO, this, "processDBParms", "Win or AIX Fabric Manager");
        }
        if (dbType.equalsIgnoreCase("db2") && !linux) {
            this.dbPoolParms.setAppDriver("COM.ibm.db2.jdbc.app.DB2Driver");
            if (this.dbPoolParms.getDriver().regionMatches(17, "app", 0, 3)) {
                this.dbPoolParms.setAppUrl(tempUrl);
            } else {
                int lastIndex = tempUrl.lastIndexOf(":");
                int lastIndex1 = tempUrl.lastIndexOf("/");
                String appUrl = tempUrl.substring(0, lastIndex + 1) + tempUrl.substring(lastIndex1 + 1);
                this.dbPoolParms.setAppUrl(appUrl);
            }
        } else {
            this.dbPoolParms.setAppDriver(netDriver);
            this.dbPoolParms.setAppUrl(tempUrl);
        }
        this.dbPoolParms.setUser(this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbUser"));
        this.dbPoolParms.setSchema(this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbSchema"));
        String password = null;
        String temp = this.dbProps.getProperty("tivoli.sanmgmt.jdbc.dbPassword");
        try {
            if (temp != null) {
                password = SRMCrypto.decrypt(temp);
            }
        }
        catch (Exception e) {
            messageLogger.message(IRecordType.TYPE_ERR, className, "processDBParms", "DBParms_errorDecryptingPassword");
            messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "processDBParms", e);
        }
        this.dbPoolParms.setPassword(password);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "processDBParms", "exiting");
        }
    }

    public void processTpcParms() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Properties props, String fn) {
        int ret = 0;
        if (this.isManager && (fn == null || fn.trim().length() == 0)) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = (String)props.get(key);
                try {
                    this.updateDB(key, value);
                }
                catch (SQLException e) {
                    ret = -1;
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "flush", e);
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "flush", e);
                }
            }
        } else {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.propBaseFn + fn);
                props.store(out, "Saved file");
            }
            catch (IOException ioe) {
                messageLogger.message(IRecordType.TYPE_ERR, (Object)className, "flush", "DBParms_errorSavingProperties", this.propBaseFn + fn);
                messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "flush", ioe);
                ret = -1;
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "flush", ioe);
                }
            }
        }
        return ret;
    }

    public String getDescription() {
        return description;
    }

    public Status getStatus() {
        return this.status;
    }

    public Properties getProperties(String group) {
        return (Properties)this.getPrivateProperties(group).clone();
    }

    private Properties getPrivateProperties(String group) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getPrivateProperties", "entered");
        }
        Properties retProp = new Properties();
        if (group.equals("user")) {
            retProp = this.userProps;
        } else if (group.equals("setup")) {
            retProp = this.setupProps;
        } else if (group.equals("database")) {
            retProp = this.dbProps;
        } else if (group.equals("internal")) {
            retProp = this.internalProps;
        } else if (this.isManager) {
            DBAccess dba = new DBAccess();
            retProp = dba.getProperties(group, retProp);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getPrivateProperties", "exiting");
        }
        return retProp;
    }

    public String getProperty(String name, String group) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getProperty", "entered");
        }
        String prop = null;
        String propName = name;
        if (group.equals("user")) {
            propName = this.getPropertyName(this.userProps, name);
            prop = this.userProps.getProperty(propName);
        } else if (group.equals("setup")) {
            propName = this.getPropertyName(this.setupProps, name);
            prop = this.setupProps.getProperty(propName);
        } else if (group.equals("database")) {
            propName = this.getPropertyName(this.dbProps, name);
            prop = this.dbProps.getProperty(propName);
        } else if (group.equals("internal")) {
            propName = this.getPropertyName(this.internalProps, name);
            prop = this.internalProps.getProperty(propName);
        } else if (this.isManager) {
            propName = this.getPropertyName(this.allTpcProps, name);
            DBAccess dba = new DBAccess();
            prop = dba.readDB(propName);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getProperty", "exiting");
        }
        return prop;
    }

    public int setProperty(String name, String group, String value) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setProperty", "entered");
        }
        int ret = -1;
        String propName = name;
        if (group.equals("user")) {
            propName = this.getPropertyName(this.userProps, name);
            this.userProps.put(propName, value);
            ret = this.flush(this.userProps, userFile);
        } else if (group.equals("setup")) {
            propName = this.getPropertyName(this.setupProps, name);
            this.setupProps.put(propName, value);
            ret = this.flush(this.setupProps, setupFile);
        } else if (group.equals("database")) {
            propName = this.getPropertyName(this.dbProps, name);
            this.dbProps.put(propName, value);
            ret = this.flush(this.dbProps, dbFile);
        } else if (group.equals("internal")) {
            propName = this.getPropertyName(this.internalProps, name);
            this.internalProps.put(propName, value);
            ret = this.flush(this.internalProps, internalFile);
        } else if (this.isManager) {
            block16: {
                propName = this.getPropertyName(this.allTpcProps, name);
                this.allTpcProps.put(propName, value);
                DBAccess dba = new DBAccess();
                ret = 0;
                try {
                    dba.updateDB(propName, value, group);
                }
                catch (SQLException e) {
                    ret = -1;
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "setProperty", e);
                    if (!traceLogger.isLogging()) break block16;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "setProperty", e);
                }
            }
            if (group.equals("CIM")) {
                this.setCIMClientProperties();
            }
        } else {
            ret = -2;
        }
        if (ret == 0) {
            this.notify(propName, group, value);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setProperty", "exited");
        }
        return ret;
    }

    private String getPropertyName(Properties props, String name) {
        String actualName = name;
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (!propName.equalsIgnoreCase(name)) continue;
            actualName = propName;
            break;
        }
        return actualName;
    }

    public ArrayList getKeys(String group) {
        ArrayList<String> array = new ArrayList<String>();
        Properties props = null;
        Enumeration<Object> e = null;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getKeys", "entered");
        }
        if (group.equals("user")) {
            props = this.userProps;
        } else if (group.equals("setup")) {
            props = this.setupProps;
        } else if (group.equals("database")) {
            props = this.dbProps;
        } else if (group.equals("internal")) {
            props = this.internalProps;
        } else if (this.isManager) {
            DBAccess dba = new DBAccess();
            props = dba.getProperties(null, props);
        } else {
            return array;
        }
        e = props.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String temp = (String)e.nextElement();
            array.add(i, temp);
            ++i;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getKeys", "exited");
        }
        return array;
    }

    public int remove(String name, String group) {
        int ret = -1;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "remove", "entered");
        }
        if (group.equals("user")) {
            this.userProps.remove(name);
            ret = this.flush(this.userProps, userFile);
        } else if (group.equals("setup")) {
            this.setupProps.remove(name);
            ret = this.flush(this.setupProps, setupFile);
        } else if (group.equals("database")) {
            this.dbProps.remove(name);
            ret = this.flush(this.dbProps, dbFile);
        } else if (group.equals("internal")) {
            this.internalProps.remove(name);
            ret = this.flush(this.internalProps, internalFile);
        } else if (this.isManager) {
            block15: {
                this.allTpcProps.remove(name);
                DBAccess dba = new DBAccess();
                try {
                    dba.removeDB(name);
                }
                catch (SQLException e) {
                    ret = -1;
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "remove", e);
                    if (!traceLogger.isLogging()) break block15;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "remove", e);
                }
            }
            if (group.equals("CIM")) {
                this.setCIMClientProperties();
            }
        } else {
            ret = -2;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "remove", "exited");
        }
        return ret;
    }

    public int register(String name, String group, String callbackURL, String callbackClass) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "register", "entered");
        }
        Vector tempVector = new Vector();
        String[] array = new String[]{callbackURL, callbackClass};
        String key = (name + "?" + group).toLowerCase();
        if (this.registerTable.containsKey(key)) {
            tempVector = (Vector)this.registerTable.get(key);
            boolean foundCallback = false;
            for (int i = 0; i < tempVector.size(); ++i) {
                String[] tempArray = (String[])tempVector.elementAt(i);
                if (!tempArray[0].equals(callbackURL) || !tempArray[1].equals(callbackClass)) continue;
                foundCallback = true;
                break;
            }
            if (!foundCallback) {
                tempVector.addElement(array);
                this.registerTable.put(key, tempVector);
            }
        } else {
            tempVector.addElement(array);
            this.registerTable.put(key, tempVector);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "register", "exited");
        }
        return 0;
    }

    public int deRegister(String name, String group, String callbackURL, String callbackClass) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "deRegister", "entered");
        }
        Vector tempVector = new Vector();
        String key = (name + "?" + group).toLowerCase();
        int retCode = -1;
        if (this.registerTable.containsKey(key)) {
            tempVector = (Vector)this.registerTable.get(key);
            for (int i = 0; i < tempVector.size(); ++i) {
                String[] tempArray = (String[])tempVector.elementAt(i);
                if (!(tempArray[0].equals(callbackURL) & tempArray[1].equals(callbackClass))) continue;
                tempVector.removeElementAt(i);
                if (tempVector.size() == 0) continue;
                --i;
            }
            if (tempVector.size() != 0) {
                this.registerTable.put(key, tempVector);
            } else {
                this.registerTable.remove(key);
            }
            retCode = 0;
        } else {
            messageLogger.message(IRecordType.TYPE_ERR, (Object)className, "deRegister", "DBParms_errorRemovingCallback", key);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "deRegister", "exited");
        }
        return retCode;
    }

    private boolean notify(String name, String group, String value) {
        String key;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "notify", "entered");
        }
        if (this.registerTable.containsKey(key = (name + "?" + group).toLowerCase())) {
            Vector tempVector = (Vector)this.registerTable.get(key);
            for (int i = 0; i < tempVector.size(); ++i) {
                String[] tempArray = (String[])tempVector.elementAt(i);
                ICallback icb = (ICallback)ConnectorClient.getService((String)tempArray[0], ICallback.class, (String)tempArray[1]);
                icb.propCallback(name, group, value);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "notify", "exited");
        }
        return true;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> roleMap = new Hashtable<String, Integer>();
        roleMap.put("dispatch", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("display", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("getProperty", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("getProperties", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("setProperty", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("setAuthenticationPw", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("remove", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("register", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("deRegister", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("getKeys", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("getParms", new Integer(RoleChecker.APERI_ADMIN));
        roleMap.put("getFcdeParms", new Integer(RoleChecker.APERI_ADMIN));
        return roleMap;
    }

    private void setCIMClientProperties() {
        String methodName = "setCIMClientProperties";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setCIMClientProperties", "entered");
        }
        Properties cimP = this.getProperties("CIM");
        GlobalProperties.loadProperties((Properties)cimP);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setCIMClientProperties", "exited");
        }
    }
}

