/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.logging;

import com.ibm.log.FileHandler;
import com.ibm.log.LogComponent;
import com.ibm.log.LogEventListener;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.LogManager;
import com.ibm.log.mgr.PropertyFileDataStore;
import com.ibm.log.util.LogException;
import java.io.File;
import java.io.IOException;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.DisabledLogger;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.JLogObjectPool;

public class LogManagerFactory {
    public static final String JOB_CONTROL = "control";
    private static final String MAIN_LOGGER = "aperi.logger.message";
    private static final String JOB_LOGGER = "aperi.logger.message.JobLogger";
    private static final String JOB_LOGGER_HANDLER = "aperi.handler.file.JobLoggerHandler";
    public static final String JOB_LOG_NAME_EXT = ".log";
    public static final String HANDLER_TAG = "Pooled handler";
    private static JLogObjectPool loggerPool = null;
    private static JLogObjectPool handlerPool = null;
    private static LogManager lm = null;
    private static LogManagerFactory lmf = null;
    private static final String DISABLE_LOGGING_KEY = "org.eclipse.aperi.sanmgmt.logging.disable";
    private static final boolean loggingDisabled = System.getProperty("org.eclipse.aperi.sanmgmt.logging.disable", "").equals("true");

    private LogManagerFactory() {
        if (!loggingDisabled) {
            try {
                PropertyFileDataStore pfds = null;
                String loggingConfigFile = Variables.getConfigurationDirectory() + File.separator + "logging.properties";
                pfds = new PropertyFileDataStore(loggingConfigFile);
                this.init(pfds);
            }
            catch (LogException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ILogger getMessageLogger(String name) {
        ILogger logger = null;
        if (!loggingDisabled) {
            if (lmf == null) {
                lmf = new LogManagerFactory();
            }
            logger = (ILogger)lm.getLogger(name);
        } else {
            logger = new DisabledLogger();
        }
        return logger;
    }

    public static String getLogFileName(ILogger logger) {
        return ((FileHandler)logger.getLogEventListeners()[0]).getFileDir() + File.separator + ((FileHandler)logger.getLogEventListeners()[0]).getFileName();
    }

    public static ILogger getTraceLogger(String name) {
        ILogger logger = null;
        if (!loggingDisabled) {
            if (lmf == null) {
                lmf = new LogManagerFactory();
            }
            logger = (ILogger)lm.getLogger(name);
        } else {
            logger = new DisabledLogger();
        }
        return logger;
    }

    public void init(PropertyFileDataStore ds) {
        lm = LogManager.getManagerWithMergedDataStore((DataStore)ds, (boolean)false);
        loggerPool = new JLogObjectPool(lm, JOB_LOGGER);
        handlerPool = new JLogObjectPool(lm, JOB_LOGGER_HANDLER);
    }

    public static ILogger getJobLogger(String prefix, String deviceServerRunId, String jobNumber) throws LogException, IOException {
        return LogManagerFactory.getJobLogger("msg", prefix, deviceServerRunId, jobNumber);
    }

    public static ILogger getJobLogger(String prefix, String type, String deviceServerRunId, String jobNumber) throws LogException, IOException {
        if (lmf == null) {
            lmf = new LogManagerFactory();
        }
        FileHandler handler = (FileHandler)handlerPool.getLogComponent();
        String jobName = prefix + "." + type + "." + deviceServerRunId + "." + jobNumber + JOB_LOG_NAME_EXT;
        jobName = jobName.replace('\\', '_');
        jobName = jobName.replace('/', '_');
        jobName = jobName.replace(':', '_');
        jobName = jobName.replace('*', '_');
        jobName = jobName.replace('?', '_');
        jobName = jobName.replace('\"', '_');
        jobName = jobName.replace('<', '_');
        jobName = jobName.replace('>', '_');
        jobName = jobName.replace('|', '_');
        handler.setFileName(jobName);
        handler.setDescription(HANDLER_TAG);
        ILogger logger = (ILogger)loggerPool.getLogComponent();
        logger.addLogEventListener((LogEventListener)handler);
        return logger;
    }

    public static void returnJobLogger(ILogger jobLogger) {
        LogEventListener[] listeners = jobLogger.getLogEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof FileHandler) || !listeners[i].getDescription().equals(HANDLER_TAG)) continue;
            jobLogger.removeLogEventListener(listeners[i]);
            FileHandler fh = (FileHandler)listeners[i];
            fh.close();
            handlerPool.returnLogComponent((LogComponent)fh);
        }
        loggerPool.returnLogComponent((LogComponent)jobLogger);
    }
}

