/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.providers.RPCJavaProvider;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.NullUserException;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Roles;
import org.eclipse.aperi.sanmgmt.middleware.data.SOAPNotAuthorizedException;
import org.eclipse.aperi.sanmgmt.middleware.data.SOAPNotLicensedException;

public class RPCSecureJavaProvider
extends RPCJavaProvider {
    private static Hashtable roles = new Hashtable();
    private static ThreadLocal threadLocal = new ThreadLocal();
    private static ILogger auditLogger;
    private static final String BUNDLE_NAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";
    private static final String className;

    public static void setRoleMapping(String service, String function, Integer roles) {
        RPCSecureJavaProvider.roles.put(service + function, roles);
    }

    public void locate(DeploymentDescriptor dd, Envelope env, Call call, String methodName, String targetObjectURI, SOAPContext reqContext) throws SOAPException {
        super.locate(dd, env, call, methodName, targetObjectURI, reqContext);
        HttpServletRequest hsr = (HttpServletRequest)reqContext.getProperty(Constants.BAG_HTTPSERVLETREQUEST);
        this.isAuthorized(hsr, targetObjectURI, methodName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void isAuthorized(HttpServletRequest hsr, String service, String method) throws SOAPNotAuthorizedException, SOAPNotLicensedException, NullUserException {
        if (hsr.getSession().getValue("isSystemUser") != null) return;
        boolean ok = false;
        if (hsr.getRemoteUser() == null) {
            if (!"DeviceServiceManager".equals(this.targetObjectURI)) throw new NullUserException(Constants.FAULT_CODE_SERVER, "Service " + service + " Method " + method);
            if (!"handshake".equals(method)) throw new NullUserException(Constants.FAULT_CODE_SERVER, "Service " + service + " Method " + method);
            return;
        }
        ok = this.checkAuthorization(hsr, service, method);
        if (ok) return;
        Object[] params = new String[]{(String)this.session.getValue("userName"), this.targetObjectURI, service + "." + method};
        if (auditLogger == null) throw new SOAPNotAuthorizedException(Constants.FAULT_CODE_SERVER, "Not authorized");
        if (!auditLogger.isLogging()) throw new SOAPNotAuthorizedException(Constants.FAULT_CODE_SERVER, "Not authorized");
        auditLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, this.methodName, "TSNMServiceManager_UnauthorizedRequest", params);
        throw new SOAPNotAuthorizedException(Constants.FAULT_CODE_SERVER, "Not authorized");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkAuthorization(HttpServletRequest hsr, String service, String method) throws SOAPNotAuthorizedException {
        String methodName = "checkAuthorization";
        boolean isAuthorized = false;
        if (Roles.getPassthrough()) {
            return true;
        }
        Integer requiredRole = (Integer)roles.get(service + method);
        if (requiredRole != null) {
            try {
                Roles roleCache = Roles.getInstance();
                if (roleCache == null) return isAuthorized;
                int usersRole = roleCache.getUserRoles(hsr.getRemoteUser());
                if (!RoleChecker.isUserInRole(usersRole, requiredRole)) return isAuthorized;
                return true;
            }
            catch (SQLException ex) {
                this.logRoleAndLicenseError(service, method, methodName, "TSNMServiceManager_UnauthorizedRequest", hsr.getRemoteUser(), hsr.getRemoteHost());
                throw new SOAPNotAuthorizedException(Constants.FAULT_CODE_SERVER, "Role authorization was unretrivable from the repository");
            }
        }
        this.logRoleAndLicenseError(service, method, methodName, "TSNMServiceManager_UnauthorizedRequest", hsr.getRemoteUser(), hsr.getRemoteHost());
        throw new SOAPNotAuthorizedException(Constants.FAULT_CODE_SERVER, "Not registered");
    }

    private void logRoleAndLicenseError(String service, String method, String methodName, String key, String user, String host) {
        ILogger traceLogger;
        Object[] params = new String[]{user, host, service + "." + method};
        if (auditLogger != null && auditLogger.isLogging()) {
            auditLogger.message(IRecordType.TYPE_ERROR, (Object)className, methodName, key, params);
        }
        if ((traceLogger = LogManagerFactory.getTraceLogger("aperi.logger.trace.TSNMServiceManager")) != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, key, params);
        }
    }

    public void invoke(SOAPContext requestContext, SOAPContext responseContext) throws SOAPException {
        HttpServletRequest hsr = (HttpServletRequest)requestContext.getProperty(Constants.BAG_HTTPSERVLETREQUEST);
        if (hsr.getRemoteUser() != null) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            properties.put("USER", hsr.getRemoteUser());
            try {
                properties.put("ROLE", new Integer(Roles.getInstance().getUserRoles(hsr.getRemoteUser())));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (hsr.getRemoteHost() != null) {
                properties.put("HOST", hsr.getRemoteHost());
            }
            RPCSecureJavaProvider.addUserProperties(properties);
        }
        super.invoke(requestContext, responseContext);
    }

    public static Map getUserProperties() {
        Hashtable result = null;
        try {
            result = (Hashtable)threadLocal.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result == null) {
            result = new Hashtable();
        }
        return result;
    }

    public static void addUserProperties(Map properties) {
        Hashtable current = null;
        try {
            current = (Hashtable)threadLocal.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (current == null) {
            current = new Hashtable();
            threadLocal.set(current);
        }
        current.putAll(properties);
    }

    static {
        className = RPCSecureJavaProvider.class.getName();
        auditLogger = LogManagerFactory.getMessageLogger("aperi.logger.message.audit");
        auditLogger.setMessageFile(BUNDLE_NAME);
    }
}

