/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.objects.AuthRoles;
import org.eclipse.aperi.sanmgmt.middleware.data.GroupData;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleData;

public final class Roles {
    private static Roles instance;
    private static boolean passthrough;
    private static Hashtable roleMap;
    private static Hashtable baseMap;
    public static final int INVALID_USER = -1;
    public static final int INVALID_PASSWORD = -2;
    private static String UPDATE_BY_ROLE_ID;
    private static String INSERT_BY_ROLE_ID;
    private static String DELETE_BY_ROLE_ID;
    public static final int API_ERROR = -2;
    public static final int RIGHTS_ALREADY_ENABLED = 0;
    public static final int RIGHTS_NOT_ENABLED = 1;
    public static final int SUCCESS = 2;
    public static final String SE_SERVICE_LOGON_NAME = "SeServiceLogonRight";

    private static native int isValidUser(String var0, String var1);

    private static native boolean isGroupMember(String var0, String var1, int var2);

    private static native boolean isValidGroup(String var0, int var1);

    private static native int checkAccountRights(String var0, String[] var1, boolean var2);

    private static native String localAdminGroup();

    private static native String retrieveNativeLog();

    private Roles() {
    }

    public static Roles getInstance() throws SQLException {
        if (instance == null) {
            try {
                instance = new Roles();
                Roles.refresh();
            }
            catch (SQLException ex) {
                instance = null;
                throw ex;
            }
        }
        return instance;
    }

    public static boolean getPassthrough() {
        return passthrough;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() throws SQLException {
        DBConnection connection = null;
        DBCursor cursor = null;
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            connection = (DBConnection)ds.getPooledConnection();
            roleMap.clear();
            cursor = AuthRoles.getCursor(connection, null, null);
            if (cursor != null) {
                AuthRoles dbHelper = null;
                while (cursor.next()) {
                    dbHelper = ((AuthRoles.AuthRolesCursor)cursor).getObject();
                    if (dbHelper == null) continue;
                    Integer key = new Integer(dbHelper.getRoleId());
                    RoleData value = new RoleData(dbHelper.getRoleName(), dbHelper.getGroupName(), (int)dbHelper.getGroupType());
                    roleMap.put(key, value);
                }
            }
        }
        finally {
            try {
                if (cursor != null) {
                    cursor.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean update(RoleData[] roleData) throws SQLException {
        boolean status;
        block34: {
            SQLException ignored2222;
            DBPreparedStatement updStmt;
            DBPreparedStatement insStmt;
            DBPreparedStatement delStmt;
            DBConnection connection;
            block30: {
                connection = null;
                delStmt = null;
                insStmt = null;
                updStmt = null;
                status = false;
                for (int i = 0; i < roleData.length; ++i) {
                    if (roleData[i] != null && (roleData[i].getGroupName() == null || this.isValidRoleData(roleData[i]))) continue;
                    return status;
                }
                DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
                connection = (DBConnection)ds.getPooledConnection();
                delStmt = connection.prepareStatement(DELETE_BY_ROLE_ID);
                insStmt = connection.prepareStatement(INSERT_BY_ROLE_ID);
                updStmt = connection.prepareStatement(UPDATE_BY_ROLE_ID);
                for (int i = 0; i < roleData.length; ++i) {
                    int roleID = RoleChecker.getRoleID(roleData[i].getRoleName());
                    String roleName = roleData[i].getRoleName();
                    String groupName = roleData[i].getGroupName();
                    int groupType = roleData[i].getGroupType();
                    RoleData cachedData = (RoleData)roleMap.get(new Integer(roleID));
                    if (groupName == null) {
                        if (cachedData == null) continue;
                        delStmt.setInt(1, roleID);
                        delStmt.executeUpdate();
                        continue;
                    }
                    if (cachedData == null) {
                        insStmt.setString(1, roleName);
                        insStmt.setString(2, groupName);
                        insStmt.setInt(3, groupType);
                        insStmt.setInt(4, roleID);
                        insStmt.executeUpdate();
                        continue;
                    }
                    if (groupName.compareTo(cachedData.getGroupName()) == 0) continue;
                    updStmt.setString(1, roleName);
                    updStmt.setString(2, groupName);
                    updStmt.setInt(3, groupType);
                    updStmt.setInt(4, roleID);
                    updStmt.executeUpdate();
                }
                connection.commit();
                Roles.refresh();
                status = true;
                Object var15_17 = null;
                if (delStmt == null) break block30;
                try {
                    delStmt.close();
                }
                catch (SQLException ignored2222) {
                    ignored2222.printStackTrace();
                }
                delStmt = null;
            }
            if (insStmt != null) {
                try {
                    insStmt.close();
                }
                catch (SQLException ignored2222) {
                    ignored2222.printStackTrace();
                }
                insStmt = null;
            }
            if (updStmt != null) {
                try {
                    updStmt.close();
                }
                catch (SQLException ignored2222) {
                    ignored2222.printStackTrace();
                }
                updStmt = null;
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block34;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break block34;
            {
                catch (SQLException ex) {
                    try {
                        if (connection != null) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException ex1) {
                        ex1.printStackTrace();
                    }
                    ex.printStackTrace();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                SQLException ignored2222;
                Object var15_18 = null;
                if (delStmt != null) {
                    try {
                        delStmt.close();
                    }
                    catch (SQLException ignored2222) {
                        ignored2222.printStackTrace();
                    }
                    delStmt = null;
                }
                if (insStmt != null) {
                    try {
                        insStmt.close();
                    }
                    catch (SQLException ignored2222) {
                        ignored2222.printStackTrace();
                    }
                    insStmt = null;
                }
                if (updStmt != null) {
                    try {
                        updStmt.close();
                    }
                    catch (SQLException ignored2222) {
                        ignored2222.printStackTrace();
                    }
                    updStmt = null;
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
        return status;
    }

    public int getUserRoles(String user) {
        int userRoles;
        block7: {
            userRoles = 0;
            try {
                if (passthrough) {
                    userRoles = RoleChecker.SUPERUSER;
                    break block7;
                }
                if (roleMap.isEmpty()) {
                    String adminGroupName = null;
                    adminGroupName = System.getProperty("os.name").startsWith("Win") ? "Administrators" : "adm";
                    if (Roles.isGroupMember(user, adminGroupName, GroupData.LOCAL_GROUP)) {
                        userRoles = RoleChecker.SUPERUSER;
                    }
                    break block7;
                }
                Enumeration e = roleMap.keys();
                while (e.hasMoreElements()) {
                    int groupType;
                    Object key = e.nextElement();
                    RoleData roleData = (RoleData)roleMap.get(key);
                    String groupName = roleData.getGroupName();
                    if (groupName == null || !Roles.isGroupMember(user, groupName, groupType = roleData.getGroupType())) continue;
                    int value = (Integer)key;
                    if (value == RoleChecker.SUPERUSER) {
                        userRoles = value;
                        break;
                    }
                    userRoles |= value;
                }
            }
            catch (UnsatisfiedLinkError ex) {
                ex.printStackTrace();
            }
        }
        return userRoles;
    }

    public boolean isValidRoleData(RoleData roleData) {
        boolean isValid = false;
        try {
            if (roleData != null && RoleChecker.getRoleID(roleData.getRoleName()) > 0) {
                String groupName = roleData.getGroupName();
                int groupType = roleData.getGroupType();
                if (groupName != null && roleData.isValidType(groupType)) {
                    isValid = Roles.isValidGroup(groupName, groupType);
                }
            }
        }
        catch (UnsatisfiedLinkError ex) {
            ex.printStackTrace();
        }
        return isValid;
    }

    public Hashtable getRoleMap() {
        return roleMap;
    }

    public Hashtable getFullRoleMap() {
        Hashtable mergeMap = new Hashtable(baseMap);
        mergeMap.putAll(roleMap);
        return mergeMap;
    }

    public static boolean checkLocalGroup(String groupName) {
        return Roles.checkLocalGroup(groupName, GroupData.LOCAL_GROUP);
    }

    public static boolean checkLocalGroup(String groupName, int groupType) {
        boolean isValid = false;
        try {
            isValid = Roles.isValidGroup(groupName, groupType);
        }
        catch (UnsatisfiedLinkError ex) {
            ex.printStackTrace();
        }
        return isValid;
    }

    public static int validateLogin(String userName, String password) {
        int rc = -1;
        try {
            rc = userName != null ? (password != null ? Roles.isValidUser(userName, password) : -2) : -1;
        }
        catch (UnsatisfiedLinkError ex) {
            ex.printStackTrace();
        }
        return rc;
    }

    public static int validateAccountRights(String accountName, String[] rights, boolean enable) {
        int rc = -1;
        try {
            if (accountName != null) {
                rc = Roles.checkAccountRights(accountName, rights, enable);
            }
        }
        catch (UnsatisfiedLinkError ex) {
            ex.printStackTrace();
        }
        return rc;
    }

    public static String nativeLog() {
        String nativeLog = "";
        boolean doLogging = false;
        if (doLogging && System.getProperty("os.name").startsWith("Win")) {
            try {
                nativeLog = Roles.retrieveNativeLog();
            }
            catch (UnsatisfiedLinkError ex) {
                ex.printStackTrace();
            }
        }
        return nativeLog;
    }

    public static String administratorsGroup() {
        String s = "";
        if (System.getProperty("os.name").startsWith("Win")) {
            try {
                s = Roles.localAdminGroup();
            }
            catch (UnsatisfiedLinkError ex) {
                ex.printStackTrace();
            }
        }
        return s;
    }

    public static boolean validateUserMembership(String user, String group, int groupType) {
        boolean result = false;
        try {
            result = Roles.isGroupMember(user, group, groupType);
        }
        catch (UnsatisfiedLinkError ex) {
            ex.printStackTrace();
        }
        return result;
    }

    static {
        try {
            System.loadLibrary("Common");
        }
        catch (UnsatisfiedLinkError ex) {
            ex.printStackTrace();
            System.out.println(ex.getMessage());
            ex.printStackTrace(System.out);
        }
        instance = null;
        passthrough = false;
        if (System.getProperty("tpc.roles.check.passthrough") != null) {
            passthrough = true;
        }
        roleMap = new Hashtable();
        baseMap = new Hashtable();
        baseMap.put(new Integer(RoleChecker.SUPERUSER), new RoleData(RoleChecker.SUPERUSER, null));
        baseMap.put(new Integer(RoleChecker.APERI_ADMIN), new RoleData(RoleChecker.APERI_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.DISK_ADMIN), new RoleData(RoleChecker.DISK_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.DISK_VIEWER), new RoleData(RoleChecker.DISK_VIEWER, null));
        baseMap.put(new Integer(RoleChecker.FABRIC_ADMIN), new RoleData(RoleChecker.FABRIC_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.FABRIC_VIEWER), new RoleData(RoleChecker.FABRIC_VIEWER, null));
        baseMap.put(new Integer(RoleChecker.DATA_ADMIN), new RoleData(RoleChecker.DATA_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.DATA_VIEWER), new RoleData(RoleChecker.DATA_VIEWER, null));
        baseMap.put(new Integer(RoleChecker.TAPE_ADMIN), new RoleData(RoleChecker.TAPE_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.TAPE_VIEWER), new RoleData(RoleChecker.TAPE_VIEWER, null));
        UPDATE_BY_ROLE_ID = "UPDATE t_res_auth_roles SET role_name=?, group_name=?, group_type=? where role_id=?";
        INSERT_BY_ROLE_ID = "INSERT into t_res_auth_roles (role_name, group_name, group_type, role_id) values (?,?,?,?)";
        DELETE_BY_ROLE_ID = "DELETE from t_res_auth_roles where role_id=?";
    }
}

