/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.Command;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.IZoneControlAgent;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.ZoneDefSaxParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class ZoneControlAgent
implements IZoneControlAgent {
    protected boolean activateOnCommit = false;
    protected static ILogger msgLogger = null;
    protected static ILogger traceLogger = null;
    protected HashMap SANtoZoneDef = new HashMap();
    protected Hashtable SANtoNewZoneDef = new Hashtable();
    private String defaultZoneSet = "unusedZS";
    protected HashMap SANtoCommands = new HashMap();
    static final String className = ZoneControlAgent.class.getName();
    protected Hashtable SANtoHandle = new Hashtable();

    public ZoneDefinition getOldZoneDefinition(String SAN) {
        String methodName = "getOldZoneDefinition";
        ZoneDefinition oldZoneDef = (ZoneDefinition)this.SANtoZoneDef.get(SAN);
        this.SANtoZoneDef.remove(SAN);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, this, methodName, "zone definition returned by getOldZoneDefinition is " + oldZoneDef);
        }
        return oldZoneDef;
    }

    public ZoneDefinition getNewZoneDefinition(String SAN) {
        String methodName = "getNewZoneDefinition";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        ZoneDefinition newZoneDef = (ZoneDefinition)this.SANtoNewZoneDef.get(SAN);
        this.SANtoNewZoneDef.remove(SAN);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, this, methodName, "zone definition returned by getNewZoneDefinition without making native calls is " + newZoneDef);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return newZoneDef;
    }

    public int readCurrentZoneDefinition(String SAN, ZoneDefinition currentZDef) throws Exception {
        int handle;
        String xmlZDef;
        String methodName = "readCurrentZoneDefinition";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        if ((xmlZDef = this.getCurrentZoningInfoNative(handle = ((Integer)this.SANtoHandle.get(SAN)).intValue())) == null) {
            return 1111;
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, this, methodName, "String returned by getCurrentZoningInfoNative is " + xmlZDef);
        }
        Object parser = null;
        XMLReader xmlReader = null;
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        spfactory.setValidating(true);
        SAXParser saxParser = spfactory.newSAXParser();
        xmlReader = saxParser.getXMLReader();
        ZoneDefSaxParser zdefp = new ZoneDefSaxParser(currentZDef);
        xmlReader.setContentHandler(zdefp);
        xmlReader.setErrorHandler(zdefp);
        StringReader reader = new StringReader(xmlZDef);
        InputSource tmp = new InputSource(reader);
        try {
            xmlReader.parse(tmp);
        }
        catch (SAXException e) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERR, this, methodName, "Parsing of Zoning Configuration XML failed for SAN " + SAN + ".\tZoneDef XML =\t" + xmlZDef);
            }
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_SAXParseException", SAN);
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            throw e;
        }
        xmlZDef = null;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return 0;
    }

    public int sendCommandArray(String SAN, Command[] commands) {
        String methodName = "sendCommandArray";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            Command cmd = new Command();
            for (int i = 0; i < commands.length; ++i) {
                cmd = commands[i];
                commandQueue.add(cmd);
            }
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 271111;
        }
        return 0;
    }

    protected int createDesiredZoneDefinition(ZoneDefinition oldZDef, ZoneDefinition newZDef, ArrayList commandQueue) {
        String methodName = "createDesiredZoneDefinition";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        Command cmd = new Command();
        block20: for (int i = 0; i < commandQueue.size(); ++i) {
            cmd = (Command)commandQueue.get(i);
            ArrayList params = cmd.getParams();
            switch (cmd.getType()) {
                case 2: {
                    String zoneSetName = (String)params.get(0);
                    ZoneSet zoneSet = newZDef.getZoneSet(zoneSetName);
                    if (zoneSet == null) {
                        return 201998;
                    }
                    newZDef.activateZoneSet(zoneSet);
                    continue block20;
                }
                case 14: {
                    String zoneName = (String)params.get(0);
                    String zoneAliasName = (String)params.get(1);
                    Zone zone = newZDef.getZone(zoneName);
                    ZoneAlias zoneAlias = newZDef.getZoneAlias(zoneAliasName);
                    if (zone == null || zoneAlias == null) {
                        return 101998;
                    }
                    newZDef.addAlias(zone, zoneAlias);
                    continue block20;
                }
                case 16: {
                    String zoneAliasName = (String)params.get(0);
                    String zoneMemberName = (String)params.get(1);
                    short zoneMemberType = (Short)params.get(2);
                    ZoneAlias zoneAlias = newZDef.getZoneAlias(zoneAliasName);
                    ZoneMember zoneMember = newZDef.getZoneMember(zoneMemberName, zoneMemberType);
                    if (zoneAlias == null || zoneMember == null) {
                        return 111998;
                    }
                    newZDef.addMember(zoneAlias, zoneMember);
                    continue block20;
                }
                case 12: {
                    String zoneName = (String)params.get(0);
                    String zoneMemberName = (String)params.get(1);
                    short zoneMemberType = (Short)params.get(2);
                    Zone zone = newZDef.getZone(zoneName);
                    ZoneMember zoneMember = newZDef.getZoneMember(zoneMemberName, zoneMemberType);
                    if (zone == null || zoneMember == null) {
                        return 91998;
                    }
                    newZDef.addMember(zone, zoneMember);
                    continue block20;
                }
                case 10: {
                    String zoneSetName = (String)params.get(0);
                    String zoneName = (String)params.get(1);
                    ZoneSet zoneSet = newZDef.getZoneSet(zoneSetName);
                    Zone zone = newZDef.getZone(zoneName);
                    if (zone == null || zoneSet == null) {
                        return 81998;
                    }
                    newZDef.addZone(zoneSet, zone);
                    continue block20;
                }
                case 8: {
                    String zoneAliasName = (String)params.get(0);
                    ZoneAlias[] aliases = newZDef.getAliases();
                    for (int craliasindex = 0; craliasindex < aliases.length; ++craliasindex) {
                        ZoneAlias testAlias = aliases[craliasindex];
                        if (!testAlias.getName().equalsIgnoreCase(zoneAliasName)) continue;
                        return 65002;
                    }
                    ZoneAlias zoneAlias = new ZoneAlias(zoneAliasName);
                    newZDef.addAlias(zoneAlias);
                    continue block20;
                }
                case 4: {
                    String zoneName = (String)params.get(0);
                    if (newZDef.getZone(zoneName) != null) {
                        return 55002;
                    }
                    Zone zone = new Zone(zoneName);
                    newZDef.addZone(zone);
                    continue block20;
                }
                case 6: {
                    Zone zone;
                    short enumType = (Short)params.get(0);
                    String id = (String)params.get(1);
                    short targType = (Short)params.get(2);
                    String targName = (String)params.get(3);
                    ZoneMember zoneMember = new ZoneMember(enumType, id);
                    if (targType == 0) {
                        zone = newZDef.getZone(targName);
                        if (zone == null) {
                            return 71998;
                        }
                        newZDef.addMember(zone, zoneMember);
                        continue block20;
                    }
                    if (targType != 1) continue block20;
                    ZoneAlias zoneAlias = newZDef.getZoneAlias(targName);
                    if (zoneAlias == null) {
                        return 71998;
                    }
                    newZDef.addMember(zoneAlias, zoneMember);
                    continue block20;
                }
                case 0: {
                    String zoneSetName = (String)params.get(0);
                    if (newZDef.getZoneSet(zoneSetName) != null) {
                        return 45002;
                    }
                    ZoneSet zoneSet = new ZoneSet(zoneSetName);
                    newZDef.addZoneSet(zoneSet);
                    continue block20;
                }
                case 3: {
                    newZDef.deactivateZoneSet();
                    continue block20;
                }
                case 9: {
                    String zoneAliasName = (String)params.get(0);
                    ZoneAlias zoneAlias = newZDef.getZoneAlias(zoneAliasName);
                    if (zoneAlias == null) {
                        if (!traceLogger.isLogging()) continue block20;
                        traceLogger.text(IRecordType.TYPE_WARN, this, methodName, "Tried to delete an Alias which does not exist: " + zoneAliasName);
                        continue block20;
                    }
                    newZDef.deleteAlias(zoneAlias);
                    continue block20;
                }
                case 5: {
                    String zoneName = (String)params.get(0);
                    Zone zone = newZDef.getZone(zoneName);
                    if (zone == null) {
                        if (!traceLogger.isLogging()) continue block20;
                        traceLogger.text(IRecordType.TYPE_WARN, this, methodName, "Tried to delete a Zone which does not exist: " + zoneName);
                        continue block20;
                    }
                    newZDef.deleteZone(zone);
                    continue block20;
                }
                case 7: {
                    String zoneMemberName = (String)params.get(0);
                    short zoneMemberType = (Short)params.get(1);
                    ZoneMember zoneMember = newZDef.getZoneMember(zoneMemberName, zoneMemberType);
                    if (zoneMember == null) {
                        if (!traceLogger.isLogging()) continue block20;
                        traceLogger.text(IRecordType.TYPE_WARN, this, methodName, "Tried to delete a ZoneMember which does not exist: " + zoneMemberName);
                        continue block20;
                    }
                    newZDef.deleteMember(zoneMember);
                    continue block20;
                }
                case 1: {
                    String zoneSetName = (String)params.get(0);
                    ZoneSet zoneSet = newZDef.getZoneSet(zoneSetName);
                    if (zoneSet == null) {
                        if (!traceLogger.isLogging()) continue block20;
                        traceLogger.text(IRecordType.TYPE_WARN, this, methodName, "Tried to delete a ZoneSet which does not exist: " + zoneSetName);
                        continue block20;
                    }
                    newZDef.deleteZoneSet(zoneSet);
                    continue block20;
                }
                case 15: {
                    String zoneName = (String)params.get(0);
                    String zoneAliasName = (String)params.get(1);
                    Zone zone = newZDef.getZone(zoneName);
                    ZoneAlias zoneAlias = newZDef.getZoneAlias(zoneAliasName);
                    if (zone == null || zoneAlias == null) {
                        return 131998;
                    }
                    newZDef.removeAlias(zone, zoneAlias);
                    continue block20;
                }
                case 17: {
                    String zoneAliasName = (String)params.get(0);
                    String zoneMemberName = (String)params.get(1);
                    short zoneMemberType = (Short)params.get(2);
                    ZoneAlias zoneAlias = newZDef.getZoneAlias(zoneAliasName);
                    ZoneMember zoneMember = newZDef.getZoneMember(zoneMemberName, zoneMemberType);
                    if (zoneAlias == null || zoneMember == null) {
                        return 151998;
                    }
                    newZDef.removeMember(zoneAlias, zoneMember);
                    continue block20;
                }
                case 13: {
                    String zoneName = (String)params.get(0);
                    String zoneMemberName = (String)params.get(1);
                    Zone zone = newZDef.getZone(zoneName);
                    short zoneMemberType = (Short)params.get(2);
                    ZoneMember zoneMember = newZDef.getZoneMember(zoneMemberName, zoneMemberType);
                    if (zone == null || zoneMember == null) {
                        return 141998;
                    }
                    newZDef.removeMember(zone, zoneMember);
                    continue block20;
                }
                case 11: {
                    String zoneSetName = (String)params.get(0);
                    String zoneName = (String)params.get(1);
                    ZoneSet zoneSet = newZDef.getZoneSet(zoneSetName);
                    Zone zone = newZDef.getZone(zoneName);
                    if (zone == null || zoneSet == null) {
                        return 121998;
                    }
                    newZDef.removeZone(zoneSet, zone);
                    continue block20;
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return 0;
    }

    public abstract int lock(String var1, String[] var2);

    public abstract int startTransaction(String var1);

    public int commitTransaction(String SAN) {
        String methodName = "commitTransaction";
        int status = 1111;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, className, methodName);
        }
        try {
            int handle = (Integer)this.SANtoHandle.get(SAN);
            ZoneDefinition oldZDef = new ZoneDefinition();
            try {
                status = this.readCurrentZoneDefinition(SAN, oldZDef);
                if (status != 0) {
                    return 251999;
                }
            }
            catch (SAXException se) {
                return 231999;
            }
            this.SANtoZoneDef.put(SAN, oldZDef);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.get(SAN);
            ZoneDefinition newZDef = (ZoneDefinition)oldZDef.clone();
            status = this.createDesiredZoneDefinition(oldZDef, newZDef, commandQueue);
            if (status != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, this, methodName, "Error occurred while creating logical ZoneDefinition for " + SAN);
                }
                return status;
            }
            this.setZoneTypesToDefault(oldZDef);
            this.setZoneTypesToDefault(newZDef);
            this.SANtoNewZoneDef.put(SAN, newZDef);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, this, methodName, "Old Zone Definition:\n " + oldZDef.toString());
                traceLogger.text(IRecordType.TYPE_MISC_DATA, this, methodName, "New Zone Definition:\n " + newZDef.toString());
            }
            status = this.activateOnCommit ? this.sendCommandsToSwitch(SAN, newZDef, oldZDef, 1) : this.sendCommandsToSwitch(SAN, newZDef, oldZDef, 0);
            this.activateOnCommit = false;
            if (status != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, this, methodName, "Error occurred while sending zoning commands to SAN " + SAN);
                }
                return status;
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            status = 231111;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
        return status;
    }

    public abstract int rollbackTransaction(String var1);

    public int release(String resource) {
        String methodName = "release";
        int status = 1111;
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            this.SANtoZoneDef.remove(resource);
            this.SANtoNewZoneDef.remove(resource);
            status = this.closeSessionNative((Integer)this.SANtoHandle.get(resource));
            if (status != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, this, methodName, "Failed to release resource " + resource + ".  Err = " + status);
                }
                this.SANtoHandle.remove(resource);
                return status;
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Released resource: " + resource);
            }
            this.SANtoHandle.remove(resource);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            status = 31111;
        }
        return status;
    }

    public int setZoneInfo(String SAN, ZoneDefinition definition, int zone_db_code) {
        String methodName = "setZoneInfo";
        int status = 1111;
        if (zone_db_code != 1 && zone_db_code != 0) {
            return 251000;
        }
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            int handle = (Integer)this.SANtoHandle.get(SAN);
            if (this.getCapabilities(SAN).getZcAgentType() == 0) {
                status = this.activateTransactionNative(handle);
                if (status != 0) {
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERR, this, methodName, "Unable to activate transaction with switch " + SAN + ".  Err = " + status);
                    }
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrStartTransaction", SAN);
                    return status;
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Started transaction with SAN: " + SAN);
                }
            }
            ZoneDefinition oldZDef = new ZoneDefinition();
            try {
                status = this.readCurrentZoneDefinition(SAN, oldZDef);
                if (status != 0) {
                    return 251999;
                }
            }
            catch (SAXException se) {
                return 251999;
            }
            this.SANtoZoneDef.put(SAN, oldZDef);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, this, methodName, "Old Zone Definition:\n " + oldZDef.toString());
                traceLogger.text(IRecordType.TYPE_MISC_DATA, this, methodName, "New Zone Definition:\n " + definition.toString());
            }
            this.setZoneTypesToDefault(oldZDef);
            this.setZoneTypesToDefault(definition);
            this.SANtoNewZoneDef.put(SAN, definition);
            status = this.sendCommandsToSwitch(SAN, definition, oldZDef, zone_db_code);
            if (status != 0) {
                return status;
            }
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            status = 251111;
        }
        return status;
    }

    public abstract int ping(String var1, String[] var2);

    public abstract ZoneCapabilities getCapabilities(String var1);

    public int createZoneSet(String SAN, String zoneSetName) {
        String methodName = "createZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneSetName);
            Command cmd = new Command(0, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 41111;
        }
        return 0;
    }

    public int createZone(String SAN, String zoneName, short zoneType, short zoneSubType) {
        String methodName = "createZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(zoneName);
            params.add(new Short(zoneType));
            params.add(new Short(zoneSubType));
            Command cmd = new Command(4, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 51111;
        }
        return 0;
    }

    public int createZoneAlias(String SAN, String zoneAliasName) {
        String methodName = "createZoneAlias";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneAliasName);
            Command cmd = new Command(8, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 61111;
        }
        return 0;
    }

    public int createZoneMemberSettingData(String SAN, short enumType, String id, short targType, String targName) {
        String methodName = "createZoneMemberSettingData";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(new Short(enumType));
            params.add(id);
            params.add(new Short(targType));
            params.add(targName);
            Command cmd = new Command(6, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 71111;
        }
        return 0;
    }

    public int addZoneToZoneSet(String SAN, String zoneSetName, String zoneName) {
        String methodName = "addZoneToZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneSetName);
            params.add(zoneName);
            Command cmd = new Command(10, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 81111;
        }
        return 0;
    }

    public int addZoneMemberToZone(String SAN, String zoneName, String zoneMemberName, short type) {
        String methodName = "addZoneMemberToZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(zoneName);
            params.add(zoneMemberName);
            params.add(new Short(type));
            Command cmd = new Command(12, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 91111;
        }
        return 0;
    }

    public int addZoneAliasToZone(String SAN, String zoneName, String zoneAliasName) {
        String methodName = "addZoneAliasToZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneName);
            params.add(zoneAliasName);
            Command cmd = new Command(14, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 101111;
        }
        return 0;
    }

    public int addZoneMemberToZoneAlias(String SAN, String zoneAliasName, String zoneMemberName, short type) {
        String methodName = "addZoneMemberToZoneAlias";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(zoneAliasName);
            params.add(zoneMemberName);
            params.add(new Short(type));
            Command cmd = new Command(16, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 111111;
        }
        return 0;
    }

    public int removeZoneFromZoneSet(String SAN, String zoneSetName, String zoneName) {
        String methodName = "removeZoneFromZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneSetName);
            params.add(zoneName);
            Command cmd = new Command(11, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 121111;
        }
        return 0;
    }

    public int removeZoneAliasFromZone(String SAN, String zoneName, String zoneAliasName) {
        String methodName = "removeZoneAliasFromZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneName);
            params.add(zoneAliasName);
            Command cmd = new Command(15, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 131111;
        }
        return 0;
    }

    public int removeZoneMemberFromZone(String SAN, String zoneName, String zoneMemberName, short type) {
        String methodName = "removeZoneMemberFromZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(zoneName);
            params.add(zoneMemberName);
            params.add(new Short(type));
            Command cmd = new Command(13, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 141111;
        }
        return 0;
    }

    public int removeZoneMemberFromZoneAlias(String SAN, String zoneAliasName, String zoneMemberName, short type) {
        String methodName = "removeZoneMemberFromZoneAlias";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(zoneAliasName);
            params.add(zoneMemberName);
            params.add(new Short(type));
            Command cmd = new Command(17, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 151111;
        }
        return 0;
    }

    public int deleteZoneMember(String SAN, String zoneMemberName, short type) {
        String methodName = "deleteZoneMember";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(zoneMemberName);
            params.add(new Short(type));
            Command cmd = new Command(7, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 161111;
        }
        return 0;
    }

    public int deleteZone(String SAN, String zoneName) {
        String methodName = "deleteZone";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneName);
            Command cmd = new Command(5, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 171111;
        }
        return 0;
    }

    public int deleteZoneSet(String SAN, String zoneSetName) {
        String methodName = "deleteZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneSetName);
            Command cmd = new Command(1, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 181111;
        }
        return 0;
    }

    public int deleteZoneAlias(String SAN, String zoneAliasName) {
        String methodName = "deleteZoneAlias";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneAliasName);
            Command cmd = new Command(9, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 191111;
        }
        return 0;
    }

    public int activateZoneSet(String SAN, String zoneSetName) {
        String methodName = "activateZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            this.activateOnCommit = true;
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneSetName);
            Command cmd = new Command(2, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 201111;
        }
        return 0;
    }

    public int deactivateZoneSet(String SAN, String zoneSetName) {
        String methodName = "deactivateZoneSet";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, className, methodName);
            }
            this.activateOnCommit = true;
            ArrayList<String> params = new ArrayList<String>();
            params.add(zoneSetName);
            Command cmd = new Command(3, params);
            ArrayList commandQueue = (ArrayList)this.SANtoCommands.remove(SAN);
            commandQueue.add(cmd);
            this.SANtoCommands.put(SAN, commandQueue);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, this, methodName, e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
            }
            return 211111;
        }
        return 0;
    }

    protected void findSameZoneEntities(ZoneDefinition definition1, ZoneDefinition definition2, HashMap likeZoneSetsMap, HashMap likeZoneAliasesMap, HashMap likeZonesMap) {
        String methodName = "findSameZoneEntities";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        ZoneSet[] zoneSets = definition1.getZoneSets();
        for (int i = 0; i < zoneSets.length; ++i) {
            Zone evalZone;
            int j;
            ArrayList otherUniqueZones;
            ArrayList uniqueZones;
            String zoneSetName = zoneSets[i].getName();
            if (definition2.getZoneSet(zoneSetName) == null) continue;
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Evaluating ZoneSet " + zoneSetName + " of both ZoneDefinitions for differences.");
            }
            if (definition2.isSameZoneSet(definition1, zoneSetName, uniqueZones = new ArrayList(), otherUniqueZones = new ArrayList())) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "ZoneSet " + zoneSetName + " is same in both ZoneDefinitions.");
                }
                likeZoneSetsMap.put(zoneSetName, zoneSets[i]);
                continue;
            }
            boolean is_different = false;
            for (j = 0; !is_different && j < uniqueZones.size(); ++j) {
                evalZone = (Zone)uniqueZones.get(j);
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Evaluating Zone " + evalZone.getName() + " in uniqueZones.");
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, evalZone.getName() + " has vendorType " + Short.toString(evalZone.getVendorType()));
                }
                if (evalZone.getVendorType() != 1) continue;
                is_different = true;
            }
            for (j = 0; !is_different && j < otherUniqueZones.size(); ++j) {
                evalZone = (Zone)otherUniqueZones.get(j);
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, "Evaluating Zone " + evalZone.getName() + " in otherUniqueZones.");
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, methodName, evalZone.getName() + " has vendorType " + Short.toString(evalZone.getVendorType()));
                }
                if (evalZone.getVendorType() != 1) continue;
                is_different = true;
            }
            if (is_different) continue;
            likeZoneSetsMap.put(zoneSetName, zoneSets[i]);
        }
        if (likeZoneAliasesMap != null) {
            ZoneAlias[] zoneAliases = definition1.getAliases();
            for (int j = 0; j < zoneAliases.length; ++j) {
                if (definition2.getZoneAlias(zoneAliases[j].getName()) == null || !definition2.isSameAlias(definition1, zoneAliases[j].getName())) continue;
                likeZoneAliasesMap.put(zoneAliases[j].getName(), zoneAliases[j]);
            }
        }
        Zone[] zones = definition1.getZones();
        for (int k = 0; k < zones.length; ++k) {
            if (definition2.getZone(zones[k].getName()) == null || !definition2.isSameZone(definition1, zones[k].getName(), zones[k].getVendorType())) continue;
            likeZonesMap.put(zones[k].getName(), zones[k]);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
        }
    }

    private void setZoneTypesToDefault(ZoneDefinition zdef) {
        Zone[] zones = zdef.getZones();
        for (int i = 0; i < zones.length; ++i) {
            zones[i].setSubType(new Integer(0).shortValue());
            zones[i].setType(new Integer(0).shortValue());
        }
    }

    protected abstract int sendCommandsToSwitch(String var1, ZoneDefinition var2, ZoneDefinition var3, int var4);

    protected abstract int activateTransactionNative(int var1);

    protected abstract int closeSessionNative(int var1);

    protected abstract String getCurrentZoningInfoNative(int var1);
}

