/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.util.Vector;

public class ThreadPool {
    private Vector idleThreads = new Vector();
    private Vector threadPool = new Vector();
    private Vector queue = new Vector();
    private static ThreadGroup group = new ThreadGroup("ThreadPoolGroup");
    private long idleTimeout = 5000L;
    private int maxPoolSize = 5;
    private int minPoolSize = 2;
    private int threadCounter = 0;
    private int priority = 5;
    private int cntr = 0;
    private boolean shutdown = false;
    private static ThreadPool instance;

    public ThreadPool() {
        this(2, 5);
    }

    private int getID() {
        ++this.cntr;
        if (this.cntr > 1000000) {
            this.cntr = 0;
        }
        return this.cntr;
    }

    public ThreadPool(int minPoolSize, int maxPoolSize) {
        this(minPoolSize, maxPoolSize, 5000);
    }

    public ThreadPool(int minPoolSize, int maxPoolSize, int idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        for (int i = 0; i < minPoolSize; ++i) {
            Worker worker = new Worker(this, "ThreadPool " + this.getID());
            this.idleThreads.add(worker);
            this.threadPool.add(worker);
            worker.start();
        }
    }

    public long getIdleTimeOutMs() {
        return this.idleThreads.size() <= this.minPoolSize ? -1L : this.idleTimeout;
    }

    public boolean execute(Runnable task) {
        return this.execute(task, true);
    }

    public boolean execute(Runnable task, boolean enqueue) {
        return this.execute(task, enqueue, false);
    }

    public synchronized boolean execute(Runnable task, boolean enqueue, boolean highPriority) {
        int totalIdle = this.idleThreads.size();
        if (totalIdle > 0) {
            Worker worker = (Worker)this.idleThreads.remove(totalIdle - 1);
            return worker.assignTask(task);
        }
        if (this.maxPoolSize == -1 || this.threadPool.size() <= this.maxPoolSize || highPriority) {
            Worker worker = new Worker(this, "ThreadPool " + this.getID());
            this.threadPool.add(worker);
            return worker.assignTask(task);
        }
        if (!enqueue) {
            return false;
        }
        this.queue.add(task);
        return true;
    }

    public ThreadGroup getGroup() {
        return group;
    }

    public synchronized boolean taskCompleted(Worker worker, boolean timeout) {
        if (this.shutdown) {
            return false;
        }
        if (this.queue.size() > 0) {
            this.idleThreads.remove(worker);
            worker.assignTask((Runnable)this.queue.remove(0));
            return true;
        }
        if (timeout && this.threadPool.size() > this.minPoolSize) {
            this.idleThreads.remove(worker);
            this.threadPool.remove(worker);
            return false;
        }
        if (this.maxPoolSize == -1 || this.threadPool.size() <= this.maxPoolSize) {
            if (!this.idleThreads.contains(worker)) {
                this.idleThreads.add(worker);
                return true;
            }
            return true;
        }
        return false;
    }

    private synchronized void removeThread(Worker worker) {
        if (worker != null && this.threadPool != null) {
            this.threadPool.remove(worker);
        }
    }

    public synchronized void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            if (this.idleThreads != null) {
                for (Worker worker : this.idleThreads) {
                    worker.kill();
                }
                this.idleThreads = null;
            }
            if (this.threadPool != null) {
                for (Worker worker : this.threadPool) {
                    worker.kill();
                }
                this.threadPool = null;
            }
        }
    }

    private class Worker
    extends Thread {
        private boolean alive;
        private boolean started;
        private ThreadPool pool;
        private Runnable task;

        public Worker(ThreadPool pool) {
            this(pool, "ThreadPool");
        }

        public Worker(ThreadPool pool, String name) {
            super(pool.getGroup(), name);
            this.alive = true;
            this.pool = pool;
            this.setDaemon(true);
        }

        public synchronized void start() {
            if (this.alive) {
                this.started = true;
                super.start();
            }
        }

        public synchronized void kill() {
            this.alive = false;
            this.started = false;
            this.notify();
        }

        public synchronized boolean assignTask(Runnable task) {
            if (this.alive) {
                this.task = task;
                if (!this.started) {
                    this.start();
                }
                this.notify();
                return true;
            }
            return false;
        }

        private synchronized Runnable waitForTask() {
            boolean timedout = false;
            while (this.alive) {
                if (this.task != null) {
                    Runnable tsk = this.task;
                    this.task = null;
                    return tsk;
                }
                this.alive = this.pool.taskCompleted(this, timedout);
                if (!this.alive || this.task != null) continue;
                try {
                    long idleTimeOut = this.pool.getIdleTimeOutMs();
                    timedout = false;
                    if (idleTimeOut > 0L) {
                        this.wait(idleTimeOut);
                        timedout = this.task == null;
                        continue;
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }

        public void run() {
            while (this.alive) {
                Runnable tsk = this.waitForTask();
                if (!this.alive) break;
                if (tsk == null) continue;
                try {
                    tsk.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            this.started = false;
            this.pool.removeThread(this);
        }
    }
}

