/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.net.Socket;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerGuiGotResponse;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestDispatcher;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestNode;
import org.eclipse.aperi.xmsg.MessageLog;

public class ViewerGuiSendRequest
implements Runnable {
    private Request request;
    private ViewerRequestDispatcher requestor;
    private ViewerRequestNode node;
    private Socket socket;
    private Object lock = new Object();
    private boolean canceled = false;

    public ViewerGuiSendRequest(Request pRequest, ViewerRequestDispatcher requestor) {
        this.request = pRequest;
        this.requestor = requestor;
        this.node = requestor.addToPending(this);
        this.node.request = pRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int status = 12;
        String errorMessage = null;
        Response response = null;
        ViewerGuiSendRequest viewerGuiSendRequest = this;
        synchronized (viewerGuiSendRequest) {
            if (this.canceled) {
                return;
            }
        }
        try {
            viewerGuiSendRequest = this;
            synchronized (viewerGuiSendRequest) {
                this.socket = new Socket(GuiClient.server, GuiClient.port);
            }
            SocketTransceiver t = new SocketTransceiver(this.socket, GuiClient.server, 1800);
            response = t.transmitRequest(this.request, null);
            t.close();
            ViewerGuiSendRequest viewerGuiSendRequest2 = this;
            synchronized (viewerGuiSendRequest2) {
                this.socket = null;
            }
            if (response == null) {
                status = 12;
                errorMessage = MessageLog.getMessage("GUI0022M", null);
            } else {
                status = response.status;
                errorMessage = response.getErrorMessage();
                if (response.responseData instanceof NameList[]) {
                    response.responseData = NameList.unpackList((NameList[])response.responseData);
                }
            }
        }
        catch (Exception e) {
            status = 12;
            errorMessage = MessageLog.getMessage("GUI0023M", null);
        }
        SwingUtilities.invokeLater(new ViewerGuiGotResponse((short)status, this.request, response, errorMessage, this.requestor, this.node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ViewerGuiSendRequest viewerGuiSendRequest = this;
        synchronized (viewerGuiSendRequest) {
            if (this.socket != null) {
                this.canceled = true;
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket = null;
            }
        }
    }
}

