/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL1;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL2;

public class ViewerSwitchL1
extends ViewerSwitchL2 {
    private static final boolean debug = false;
    public static final String SELECT_SWITCH = "SELECT \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_MODEL MODEL on \tT_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID WHERE    T_RES_SWITCH.PREFIX_ID = ? and    T_RES_SWITCH.SWITCH_ID = ? ";
    public static final String SELECT_SWITCH2HOST_FROM_SWITCH = "SELECT distinct \t SWITCH2HOST.HOST_PREFIX_ID PREFIX_ID, \t SWITCH2HOST.HOST_ID,\t SWITCH2HOST.PORT2PORT_ID PORT2PORT_ID,\t SWITCH2HOST.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2HOST SWITCH2HOST WHERE     SWITCH2HOST.SWITCH_PREFIX_ID = ? and \t SWITCH2HOST.SWITCH_ID = ? ";
    public static final String SELECT_SWITCH2SUBSYSTEM_FROM_SWITCH = "SELECT DISTINCT \tSWITCH2SUBSYSTEM.PORT2PORT_ID, \tSWITCH2SUBSYSTEM.SUBSYSTEM_PORT_ID PORT_ID, \tSWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID PREFIX_ID,\tSWITCH2SUBSYSTEM.SUBSYSTEM_ID,    SWITCH2SUBSYSTEM.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM WHERE    SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID =? and  \tSWITCH2SUBSYSTEM.SWITCH_ID = ? ";
    public static final String SELECT_SWITCH2TAPE_FROM_SWITCH = "SELECT DISTINCT \tSWITCH2TAPE.PORT2PORT_ID, \tSWITCH2TAPE.TAPE_PORT_ID PORT_ID, \tSWITCH2TAPE.TAPE_PREFIX_ID PREFIX_ID, \tSWITCH2TAPE.TAPE_LIBRARY_ID,    SWITCH2TAPE.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2TAPE SWITCH2TAPE WHERE    SWITCH2TAPE.SWITCH_PREFIX_ID = ? and \tSWITCH2TAPE.SWITCH_ID = ?";
    public static final String SELECT_SWITCH2OTHER_FROM_SWITCH = "SELECT DISTINCT \tSWITCH2OTHER.PORT2PORT_ID, \tSWITCH2OTHER.OTHER_PREFIX_ID PREFIX_ID, \tSWITCH2OTHER.OTHER_ID OTHER_ID,    SWITCH2OTHER.OTHER_PORT_ID PORT_ID,    SWITCH2OTHER.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2OTHER SWITCH2OTHER WHERE    SWITCH2OTHER.SWITCH_PREFIX_ID = ? and \tSWITCH2OTHER.SWITCH_ID = ? ";
    public static final String SELECT_SWITCH_FROM_SWITCH = "SELECT \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3  \t,SWITCH2SWITCH.SWITCH2_PORT_ID PORT_ID, \tSWITCH2SWITCH.PORT2PORT_ID PORT2PORT_ID FROM (select \n\t  SWITCH1.PREFIX_ID SWITCH_PREFIX_ID1, \n     SWITCH1.SWITCH_ID SWITCH_ID1, \n     SWITCH2PORT1.PORT_ID SWITCH1_PORT_ID, \n\t  SWITCH2.PREFIX_ID SWITCH_PREFIX_ID2, \n     SWITCH2.SWITCH_ID SWITCH_ID2,\n     SWITCH2PORT2.PORT_ID SWITCH2_PORT_ID, \n\t  PORT2PORT.PORT2PORT_ID PORT2PORT_ID,\n\t  PORT2PORT.DETECTABLE DETECTABLE \nFROM \nT_VIEW_PORT2PORT PORT2PORT, \n     T_VIEW_VSWITCH SWITCH2, T_VIEW_VSWITCH2PORT SWITCH2PORT1, T_VIEW_VSWITCH2PORT SWITCH2PORT2, \n\t  T_VIEW_VSWITCH SWITCH1 left outer join T_VIEW_VSWITCH SWITCH3 on \n     SWITCH1.SWITCH_WWN = SWITCH3.PARENT_SWITCH_WWN \nWHERE \n     SWITCH3.SWITCH_WWN is NULL and \n\t  SWITCH1.PREFIX_ID = SWITCH2PORT1.PREFIX_ID and \n\t  SWITCH1.SWITCH_ID = SWITCH2PORT1.SWITCH_ID and \n     SWITCH2PORT1.PORT_ID = PORT2PORT.PORT_ID1 and \n     PORT2PORT.PORT_ID2 = SWITCH2PORT2.PORT_ID and \n     SWITCH2PORT2.PREFIX_ID = SWITCH2.PREFIX_ID and \n\t  SWITCH2PORT2.SWITCH_ID = SWITCH2.SWITCH_ID \n) SWITCH2SWITCH, \tT_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\tT_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID WHERE \tT_RES_SWITCH.PREFIX_ID = SWITCH2SWITCH.SWITCH_PREFIX_ID2 and \tT_RES_SWITCH.SWITCH_ID = SWITCH2SWITCH.SWITCH_ID2 and    SWITCH2SWITCH.SWITCH_PREFIX_ID1 = ? and \tSWITCH2SWITCH.SWITCH_ID1 = ? ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphSwitch getSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixID, int switchId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSwitch gSwitch = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH);
            stmt.setString(1, prefixID);
            stmt.setInt(2, switchId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer switchIdNew = (Integer)resultSet.getObject("SWITCH_ID");
                if (switchIdNew == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch", "Switch ID is NULL");
                    continue;
                }
                String switchKey = prefixId + switchIdNew;
                gSwitch = (GraphSwitch)entityMap.get(switchKey);
                if (entityMap == null || gSwitch == null) {
                    gSwitch = new GraphSwitch(switchKey);
                    this.populator.populateSwitch(resultSet, gSwitch, true);
                    if (model != null) {
                        model.put(gSwitch);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(switchKey, gSwitch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch", "Duplicated Switch entry:" + switchKey);
            }
        }
        finally {
            block19: {
                block18: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block18;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block19;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch", e);
                }
            }
        }
        return gSwitch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2HostFromSwitch(Connection srmConnection, GraphModel model, HashMap entityMap, String prefixID, int switchId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSwitch gSwitch = (GraphSwitch)entityMap.get(prefixID + switchId);
        if (gSwitch == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "switch not found:server:" + switchId);
            }
            return;
        }
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_SWITCH2HOST_FROM_SWITCH);
            stmt.setString(1, prefixID);
            stmt.setInt(2, switchId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                if (hostId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "NULL column field HOST_ID from host");
                    continue;
                }
                String hostKey = prefixId + hostId;
                GraphComputer gHost = (GraphComputer)entityMap.get(hostKey);
                if (gHost == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "Host not found:" + hostKey);
                    continue;
                }
                String switch2serverKey = "port2port:" + prefixID + hostId + ',' + prefixId + switchId + ',' + port2portId;
                if (entityMap.get(switch2serverKey) == null) {
                    GraphSwitch2Computer switch2server = new GraphSwitch2Computer(switch2serverKey);
                    switch2server.setComputerID((GraphComputer.ID)gHost.getEntityID());
                    switch2server.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                    this.populator.populatePort2Port(resultSet, switch2server);
                    model.put(switch2server);
                    entityMap.put(switch2serverKey, switch2server);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "Duplicated :" + switch2serverKey);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHostFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixID, int switchId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphComputer gHost = null;
        GraphSwitch gSwitch = (GraphSwitch)entityMap.get(prefixID + switchId);
        if (gSwitch == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getHostFromSwitch", "Missing switch");
            }
            return;
        }
        boolean i = false;
        try {
            stmt = con.prepareStatement("SELECT DISTINCT \t\tT_RES_HOST.PREFIX_ID, \t    CASE WHEN T_RES_HOST.HOST_NAME IS NOT NULL THEN T_RES_HOST.HOST_NAME \t\t\t WHEN T_RES_HOST.HOST_URL IS NOT NULL THEN T_RES_HOST.HOST_URL \t\t\t ELSE CAST(T_RES_HOST.COMPUTER_ID as CHAR(10)) \t\tEND  DISPLAY_NAME,        T_RES_HOST.DEV_STATUS DEV_STATUS,        T_RES_HOST.DAT_STATUS DAT_STATUS, \t\tT_RES_HOST.HOST_NAME HOST_NAME, \t\tT_RES_HOST.COMPUTER_ID HOST_ID, \t\tT_RES_HOST.GUID GUID, \t\tT_RES_HOST.OS_TYPE OS_TYPE,\t\tT_RES_HOST.OS_VERSION OS_VERSION,\t\tT_RES_HOST.TIME_ZONE TIME_ZONE,\t\tT_RES_HOST.IP_ADDRESS IP_ADDRESS,\t\tT_RES_HOST.DETECTABLE DETECTABLE, \t\tT_RES_HOST.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_HOST.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HOST.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HOST.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_HOST.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_HOST.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VSWITCH2HOST SWITCH2HOST, \tT_VIEW_VHOST T_RES_HOST WHERE    T_RES_HOST.PREFIX_ID = SWITCH2HOST.HOST_PREFIX_ID and \tT_RES_HOST.COMPUTER_ID = SWITCH2HOST.HOST_ID and    SWITCH2HOST.SWITCH_PREFIX_ID = ? and \tSWITCH2HOST.SWITCH_ID = ? ");
            stmt.setString(1, prefixID);
            stmt.setInt(2, switchId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                if (hostId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getHostFromSwitch", "HOST_ID is NULL");
                    continue;
                }
                String hostKey = prefixId + hostId;
                if (entityMap == null || entityMap.get(hostKey) == null) {
                    gHost = new GraphComputer(hostKey);
                    this.populator.populateHost(resultSet, gHost);
                    if (model != null) {
                        model.put(gHost);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(hostKey, gHost);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getHost", "Duplicated Host entry:" + hostKey);
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getHost", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getHost", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSubsystemFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixID, int switchId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSubsystem gArray = null;
        GraphSwitch gSwitch = (GraphSwitch)entityMap.get(prefixID + switchId);
        if (gSwitch == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSubsystemFromSwitch", "Switch not found server:" + switchId);
            }
            return;
        }
        boolean i = false;
        try {
            stmt = con.prepareStatement("SELECT DISTINCT \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM, \t T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on \t T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\t T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE     SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID = ? and \t SWITCH2SUBSYSTEM.SWITCH_ID = ? and     SWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = T_RES_STORAGE_SUBSYSTEM.PREFIX_ID and \t SWITCH2SUBSYSTEM.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID ");
            stmt.setString(1, prefixID);
            stmt.setInt(2, switchId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer subsystemId = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                if (subsystemId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSubsystemFromSwitch", "SUBSYSTEM_ID is NULL");
                    continue;
                }
                String arrayKey = prefixId + subsystemId;
                if (entityMap == null || entityMap.get(arrayKey) == null) {
                    gArray = new GraphSubsystem(arrayKey);
                    this.populator.populateSubsystem(resultSet, gArray);
                    if (model != null) {
                        model.put(gArray);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(arrayKey, gArray);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSubsystemFromSwitch", "Duplicated Subsystem entry:" + arrayKey);
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSubsystem", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2SubsystemFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixID, int switchId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSubsystem gArray = null;
        GraphSwitch gSwitch = (GraphSwitch)entityMap.get(prefixID + switchId);
        if (gSwitch == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SubsystemFromSwitch", "Switch not found switch:" + switchId);
            }
            return;
        }
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH2SUBSYSTEM_FROM_SWITCH);
            stmt.setString(1, prefixID);
            stmt.setInt(2, switchId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                try {
                    String prefixId = (String)resultSet.getObject("PREFIX_ID");
                    Integer subsystemId = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                    Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                    if (subsystemId == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SubsystemFromSwitch", "SUBSYSTEM_ID is NULL");
                        continue;
                    }
                    String arrayKey = prefixId + subsystemId;
                    gArray = (GraphSubsystem)entityMap.get(arrayKey);
                    if (gArray != null) {
                        String switch2arrayKey = "port2port:" + port2portId;
                        GraphSwitch2Subsystem switch2array = (GraphSwitch2Subsystem)entityMap.get(switch2arrayKey);
                        if (switch2arrayKey == null) continue;
                        switch2array = new GraphSwitch2Subsystem(switch2arrayKey);
                        switch2array.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                        switch2array.setSubsystemID((GraphSubsystem.ID)gArray.getEntityID());
                        this.populator.populatePort2Port(resultSet, switch2array);
                        model.put(switch2array);
                        entityMap.put(switch2arrayKey, switch2array);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SubsystemFromSwitch", "Missing array entry:" + arrayKey);
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2SubsystemFromSwitch", e);
                }
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Subsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Subsystem", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTapeFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixID, int switchId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphTapeLibrary gTape = null;
        GraphSwitch gSwitch = (GraphSwitch)entityMap.get(prefixID + switchId);
        if (gSwitch == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getTapeFromSwitch", "Switch not found server:" + switchId);
            }
            return;
        }
        boolean i = false;
        try {
            stmt = con.prepareStatement("SELECT DISTINCT \t\tT_RES_TAPE_LIBRARY.PREFIX_ID, \t\tT_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID TAPE_LIBRARY_ID, \t\tCASE WHEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME)\t\t!= '' THEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME \t\t\t WHEN T_RES_TAPE_LIBRARY.DISPLAY_NAME IS NOT NULL THEN T_RES_TAPE_LIBRARY.DISPLAY_NAME \t\t\t ELSE T_RES_TAPE_LIBRARY.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_TAPE_LIBRARY.FIRMWARE_VERSION FIRMWARE_VERSION, \t\tT_RES_TAPE_LIBRARY.MAX_CARTRIDGES MAX_CARTRIDGES, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_TAPE_LIBRARY.SERIAL_NUMBER SERIAL_NUMBER, \t\tT_RES_TAPE_LIBRARY.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_TAPE_LIBRARY.DETECTABLE DETECTABLE, \t\tT_RES_TAPE_LIBRARY.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_TAPE_LIBRARY.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_TAPE_LIBRARY.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_TAPE_LIBRARY.TOTAL_DRIVES, \t\tT_RES_TAPE_LIBRARY.TOTAL_CARTRIDGES, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VSWITCH2TAPE SWITCH2TAPE,\t T_VIEW_VTAPE_LIBRARY T_RES_TAPE_LIBRARY left outer join T_RES_TAPE_FRAME on \t T_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID = T_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID left outer join T_RES_VENDOR VENDOR on \t T_RES_TAPE_LIBRARY.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\t T_RES_TAPE_LIBRARY.MODEL_ID = MODEL.MODEL_ID  WHERE     SWITCH2TAPE.SWITCH_PREFIX_ID = ? and \t SWITCH2TAPE.SWITCH_ID = ? and     SWITCH2TAPE.TAPE_PREFIX_ID = T_RES_TAPE_LIBRARY.PREFIX_ID and \t SWITCH2TAPE.TAPE_LIBRARY_ID = T_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID ");
            stmt.setString(1, prefixID);
            stmt.setInt(2, switchId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer tapeId = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                if (tapeId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getTapeFromSwitch", "TAPE_LIBRARY_ID is NULL");
                    continue;
                }
                String tapeKey = prefixId + tapeId;
                if (entityMap == null || entityMap.get(tapeKey) == null) {
                    gTape = new GraphTapeLibrary(tapeKey);
                    this.populator.populateTapeLibrary(resultSet, gTape);
                    if (model != null) {
                        model.put(gTape);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(tapeKey, gTape);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getTapeFromSwitch", "Duplicated Tape entry:" + tapeKey);
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getTape", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getTape", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2TapeFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixID, int switchId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphTapeLibrary gTape = null;
        GraphSwitch gSwitch = (GraphSwitch)entityMap.get(prefixID + switchId);
        if (gSwitch == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2TapeFromSwitch", "Switch not found switch:" + switchId);
            }
            return;
        }
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH2TAPE_FROM_SWITCH);
            stmt.setString(1, prefixID);
            stmt.setInt(2, switchId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                try {
                    String prefixId = (String)resultSet.getObject("PREFIX_ID");
                    Integer tapeId = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                    Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                    if (tapeId == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2TapeFromSwitch", "TAPE_LIBRARY_ID is NULL");
                        continue;
                    }
                    String tapeKey = prefixId + tapeId;
                    gTape = (GraphTapeLibrary)entityMap.get(tapeKey);
                    if (gTape != null) {
                        String switch2tapeKey = "port2port:" + port2portId;
                        GraphSwitch2TapeLibrary switch2tape = (GraphSwitch2TapeLibrary)entityMap.get(switch2tapeKey);
                        if (switch2tapeKey == null) continue;
                        switch2tape = new GraphSwitch2TapeLibrary(switch2tapeKey);
                        switch2tape.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                        switch2tape.setTapeLibraryID((GraphTapeLibrary.ID)gTape.getEntityID());
                        this.populator.populatePort2Port(resultSet, switch2tape);
                        model.put(switch2tape);
                        entityMap.put(switch2tapeKey, switch2tape);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2TapeFromSwitch", "Missing tape entry:" + tapeKey);
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2TapeFromSwitch", e);
                }
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Tape", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Tape", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOtherFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixID, int switchId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphOther gOther = null;
        GraphSwitch gSwitch = (GraphSwitch)entityMap.get(prefixID + switchId);
        if (gSwitch == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getOtherFromSwitch", "Missing switch");
            }
            return;
        }
        boolean i = false;
        try {
            stmt = con.prepareStatement("SELECT DISTINCT \tOTHER.PREFIX_ID PREFIX_ID, \tOTHER.OTHER_ID OTHER_ID, \tOTHER.DISPLAY_NAME DISPLAY_NAME, \tOTHER.PROPAGATED_STATUS PROPAGATED_STATUS, \tOTHER.DETECTABLE DETECTABLE, \tMODEL.MODEL_NAME MODEL, \tVENDOR.VENDOR_NAME VENDOR, \tOTHER.SERIAL_NUMBER SERIAL_NUMBER, \tOTHER.OTHER_TYPE DISPLAY_TYPE ,  \tSWITCH2OTHER.PORT2PORT_ID FROM T_VIEW_VOTHER OTHER left outer join T_RES_MODEL MODEL on\tOTHER.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on    OTHER.VENDOR_ID = VENDOR.VENDOR_ID, T_VIEW_VSWITCH2OTHER SWITCH2OTHER WHERE    SWITCH2OTHER.SWITCH_PREFIX_ID = ? and \tSWITCH2OTHER.SWITCH_ID = ? and    SWITCH2OTHER.OTHER_ID = OTHER.OTHER_ID and    SWITCH2OTHER.OTHER_PREFIX_ID = OTHER.PREFIX_ID ");
            stmt.setString(1, prefixID);
            stmt.setInt(2, switchId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer otherId = (Integer)resultSet.getObject("OTHER_ID");
                if (otherId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getOtherFromSwitch", "OTHER_ID is NULL");
                    continue;
                }
                String otherKey = prefixId + otherId;
                if (entityMap == null || entityMap.get(otherKey) == null) {
                    gOther = new GraphOther(otherKey);
                    this.populator.populateOther(resultSet, gOther);
                    if (model != null) {
                        model.put(gOther);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(otherKey, gOther);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getOther", "Duplicated Other entry:" + otherKey);
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getOther", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getOther", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2OtherFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixID, int switchId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphOther gOther = null;
        GraphSwitch gSwitch = (GraphSwitch)entityMap.get(prefixID + switchId);
        if (gSwitch == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2OtherFromSwitch", "Switch not found switch:" + switchId);
            }
            return;
        }
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH2OTHER_FROM_SWITCH);
            stmt.setString(1, prefixID);
            stmt.setInt(2, switchId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                try {
                    String prefixId = (String)resultSet.getObject("PREFIX_ID");
                    Integer otherId = (Integer)resultSet.getObject("OTHER_ID");
                    Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                    if (otherId == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2OtherFromSwitch", "OTHER_ID is NULL");
                        continue;
                    }
                    String otherKey = prefixId + otherId;
                    gOther = (GraphOther)entityMap.get(otherKey);
                    if (gOther != null) {
                        String switch2otherKey = "port2port:" + port2portId;
                        GraphSwitch2Other switch2other = (GraphSwitch2Other)entityMap.get(switch2otherKey);
                        if (switch2otherKey == null) continue;
                        switch2other = new GraphSwitch2Other(switch2otherKey);
                        switch2other.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                        switch2other.setOtherID((GraphOther.ID)gOther.getEntityID());
                        this.populator.populatePort2Port(resultSet, switch2other);
                        model.put(switch2other);
                        entityMap.put(switch2otherKey, switch2other);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2OtherFromSwitch", "Missing other entry:" + otherKey);
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2OtherFromSwitch", e);
                }
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Other", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Other", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2SwitchFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixID, int switchId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSwitch gSwitchTo = null;
        GraphSwitch gSwitchFrom = (GraphSwitch)entityMap.get(prefixID + switchId);
        if (gSwitchFrom == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SwitchFromSwitch", "Switch not found switch:" + switchId);
            }
            return;
        }
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH_FROM_SWITCH);
            stmt.setString(1, prefixID);
            stmt.setInt(2, switchId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                try {
                    String prefixId = (String)resultSet.getObject("PREFIX_ID");
                    Integer switchToId = (Integer)resultSet.getObject("SWITCH_ID");
                    Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                    if (switchToId == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SwitchFromSwitch", "SWITCH_ID is NULL");
                        continue;
                    }
                    String switchToKey = prefixId + switchToId;
                    gSwitchTo = (GraphSwitch)entityMap.get(switchToKey);
                    if (gSwitchTo == null) {
                        gSwitchTo = new GraphSwitch(switchToKey);
                        this.populator.populateSwitch(resultSet, gSwitchTo, true);
                        if (model != null) {
                            model.put(gSwitchTo);
                        }
                        if (entityMap != null) {
                            entityMap.put(switchToKey, gSwitchTo);
                        }
                    }
                    if (gSwitchTo != null) {
                        String switch2switchKey = "port2port:" + port2portId;
                        GraphSwitch2Switch switch2switch = (GraphSwitch2Switch)entityMap.get(switch2switchKey);
                        if (switch2switchKey == null) continue;
                        switch2switch = new GraphSwitch2Switch(switch2switchKey);
                        switch2switch.setSwitch1ID((GraphSwitch.ID)gSwitchFrom.getEntityID());
                        switch2switch.setSwitch2ID((GraphSwitch.ID)gSwitchTo.getEntityID());
                        this.populator.populatePort2Port(resultSet, switch2switch);
                        model.put(switch2switch);
                        entityMap.put(switch2switchKey, switch2switch);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SwitchFromSwitch", "Missing switch entry:" + switchToKey);
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2SwitchFromSwitch", e);
                }
            }
        }
        finally {
            block25: {
                block24: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block24;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Switch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block25;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Switch", e);
                }
            }
        }
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerSwitchL1.class.getName(), "commit", e);
            }
        }
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getView", "");
        }
        GraphModelSwitchL1 gModel = null;
        String switchId = null;
        GraphModel.MultiEntityID multiNodeModelID = (GraphModel.MultiEntityID)rqst.getModelID();
        Vector childFocusNodeIDV = multiNodeModelID.getChildFocusEntityIDs();
        HashMap entityMap = new HashMap();
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
            gModel = new GraphModelSwitchL1((GraphModelSwitchL1.ID)rqst.getModelID());
            for (GraphSwitch.ID arrayId : childFocusNodeIDV) {
                int switchIdInt;
                switchId = (String)arrayId.getID();
                int i = switchId.indexOf(58);
                String prefixId = switchId.substring(0, i + 1);
                if (this.getSwitch(con, gModel, entityMap, prefixId, switchIdInt = Integer.parseInt(switchId = switchId.substring(i + 1))) == null) continue;
                this.getSwitch2SwitchFromSwitch(con, gModel, entityMap, prefixId, switchIdInt);
                this.getHostFromSwitch(con, gModel, entityMap, prefixId, switchIdInt);
                this.getSwitch2HostFromSwitch(con, gModel, entityMap, prefixId, switchIdInt);
                this.getSubsystemFromSwitch(con, gModel, entityMap, prefixId, switchIdInt);
                this.getSwitch2SubsystemFromSwitch(con, gModel, entityMap, prefixId, switchIdInt);
                this.getTapeFromSwitch(con, gModel, entityMap, prefixId, switchIdInt);
                this.getSwitch2TapeFromSwitch(con, gModel, entityMap, prefixId, switchIdInt);
                this.getOtherFromSwitch(con, gModel, entityMap, prefixId, switchIdInt);
                this.getSwitch2OtherFromSwitch(con, gModel, entityMap, prefixId, switchIdInt);
                this.getSansFromSwitch(con, (GraphModel)gModel, entityMap, prefixId, switchIdInt);
                this.commit(con);
            }
            gModel.setWithZoneData(rqst.getModelID().isNeedZoneData());
            resp.addResponse(0, gModel);
        } else {
            resp.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getView", "");
        }
    }
}

