/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.req;

import java.util.HashMap;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.agent.req.AgentStatusReq;
import org.eclipse.aperi.common.LockResource;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.AuditConfigRequest;
import org.eclipse.aperi.logging.LogConfigRequest;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.StateChangeReq;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleData;
import org.eclipse.aperi.server.guireq.InbandFabricAgentInfo;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.server.req.AgentCommandReq;
import org.eclipse.aperi.server.req.AgentStateReq;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.GuiInfoReq;
import org.eclipse.aperi.server.req.GuiToAgentReq;
import org.eclipse.aperi.server.req.RolesUpdateReq;
import org.eclipse.aperi.server.req.SignonReq;
import org.eclipse.aperi.server.req.UninstallAgentReq;
import org.eclipse.aperi.server.req.UserPrefUpdReq;

public class ServerRequest {
    private static final String CLASSNAME = ServerRequest.class.getName();

    public static void serverRequest(Request request) {
        String methodName = "serverRequest";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverRequest", "request");
        }
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName("org.eclipse.aperi.server.svp.ServerSvp");
        request.requestData = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverRequest");
        }
    }

    public static void stateChange(Request request, byte newState, String service) {
        String methodName = "stateChange";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "stateChange", "request, newState, service");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.StateChangeHndlr";
        request.flags = (byte)5;
        StateChangeReq scReq = new StateChangeReq();
        scReq.newState = newState;
        scReq.serviceProvider = service;
        request.requestData = scReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "stateChange");
        }
    }

    public static void serverStatus(Request request) {
        String methodName = "serverStatus";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverStatus", "request");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ServerStatusHndlr";
        request.flags = (byte)4;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverStatus");
        }
    }

    public static void signon(Request request, String id, String pwd) {
        String methodName = "signon";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "signon", "request, id, pwd");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.SignonHndlr";
        request.flags = (byte)4;
        SignonReq sr = new SignonReq();
        sr.id = id;
        sr.pwd = pwd;
        request.requestData = sr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "signon");
        }
    }

    public static void userPrefUpd(Request request, String id, UserPreferences prefs) {
        String methodName = "userPrefUpd";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "userPrefUpd", "request, id, prefs");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.UserPrefUpdHndlr";
        request.flags = (byte)4;
        UserPrefUpdReq req = new UserPrefUpdReq();
        req.id = id;
        req.prefs = prefs;
        request.requestData = req;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "userPrefUpd");
        }
    }

    public static void broadcast(Request request) {
        String methodName = "broadcast";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "broadcast", "request");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.BroadcastHndlr";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "broadcast");
        }
    }

    public static void lockQuery(Request request, short productID, String resource) {
        String methodName = "";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "", "request, productID, resource");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.LockQueryHndlr";
        request.requestData = LockResource.getLockResource(productID, resource);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "");
        }
    }

    public static void agentState(Request request, ComputerID computerID, byte state) {
        String methodName = "agentState";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentState", "request, computerID, state");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.AgentStateHndlr";
        request.flags = (byte)4;
        AgentStateReq asReq = new AgentStateReq();
        asReq.computerID = computerID;
        asReq.state = state;
        request.requestData = asReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentState");
        }
    }

    public static void guiInfo(Request request, int dataRequested, int dataFor) {
        String methodName = "guiInfo";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "guiInfo", "request, dataRequested, dataFor");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiHndlr";
        request.flags = (byte)4;
        GuiInfoReq giReq = new GuiInfoReq();
        giReq.dataRequested = dataRequested;
        giReq.dataFor = dataFor;
        request.requestData = giReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "guiInfo");
        }
    }

    public static void agentJobs(Request request, int agentComputerID) {
        String methodName = "agentJobs";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentJobs", "request, agentComputerID");
        }
        GuiToAgentReq g2aReq = ServerRequest.guiToAgentReq(request, agentComputerID);
        g2aReq.requestHandler = "org.eclipse.aperi.agent.handler.status.StatusHandler";
        g2aReq.agentData = new AgentStatusReq(true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentJobs");
        }
    }

    public static void agentStatus(Request request, int agentComputerID) {
        String methodName = "agentStatus";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentStatus", "request, agentComputerID");
        }
        GuiToAgentReq g2aReq = ServerRequest.guiToAgentReq(request, agentComputerID);
        g2aReq.requestHandler = "org.eclipse.aperi.agent.handler.status.StatusHandler";
        g2aReq.agentData = new AgentStatusReq(false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentStatus");
        }
    }

    private static GuiToAgentReq guiToAgentReq(Request request, int agentComputerID) {
        String methodName = "guiToAgentReq";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "guiToAgentReq", "request, agentComputerID");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.flags = (byte)4;
        GuiToAgentReq g2aReq = new GuiToAgentReq();
        g2aReq.computerID = agentComputerID;
        request.requestData = g2aReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "guiToAgentReq", g2aReq);
        }
        return g2aReq;
    }

    public static void agentStop(Request request, int agentComputerID, byte stopType) {
        String methodName = "agentStop";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentStop", "request, agentComputerID, stopType");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.flags = (byte)5;
        GuiToAgentReq g2aReq = new GuiToAgentReq();
        g2aReq.computerID = agentComputerID;
        g2aReq.requestHandler = "org.eclipse.aperi.agent.handler.state.ShutdownHandler";
        StateChangeReq agentRequest = new StateChangeReq();
        agentRequest.newState = stopType;
        g2aReq.agentData = agentRequest;
        request.requestData = g2aReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentStop");
        }
    }

    public static void agentReadConfig(Request request, int agentComputerID) {
        String methodName = "agentReadConfig";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentReadConfig", "request, agentComputerID");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.flags = (byte)5;
        GuiToAgentReq g2aReq = new GuiToAgentReq();
        g2aReq.computerID = agentComputerID;
        g2aReq.requestHandler = "org.eclipse.aperi.agent.handler.log.config.ReadConfigHandler";
        g2aReq.agentData = new AgentRequestData();
        request.requestData = g2aReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentReadConfig");
        }
    }

    public static void agentGetAgentHome(Request request, int agentComputerID) {
        String methodName = "agentGetAgentHome";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentGetAgentHome", "request, agentComputerID");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.flags = (byte)5;
        GuiToAgentReq g2aReq = new GuiToAgentReq();
        g2aReq.computerID = agentComputerID;
        g2aReq.requestHandler = "org.eclipse.aperi.agent.handler.config.GetAgentHomeHandler";
        g2aReq.agentData = new AgentRequestData();
        request.requestData = g2aReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentGetAgentHome");
        }
    }

    public static void agentReadLog(Request request, int agentComputerID, ReadLogRequest readLogRequest) {
        String methodName = "agentReadLog";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentReadLog", "request, agentComputerID, readLogRequest");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        request.flags = (byte)5;
        GuiToAgentReq g2aReq = new GuiToAgentReq();
        g2aReq.computerID = agentComputerID;
        g2aReq.requestHandler = "org.eclipse.aperi.agent.handler.log.DaemonLogFileHandler";
        g2aReq.agentData = readLogRequest;
        request.requestData = g2aReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentReadLog");
        }
    }

    public static void readInbandAgentLog(Request request, int agentComputerID, ReadLogRequest readLogRequest) {
        String methodName = "readInbandAgentLog";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "readInbandAgentLog", "request, agentComputerID, readLogRequest");
        }
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
        request.flags = (byte)5;
        InbandFabricAgentInfo ifai = new InbandFabricAgentInfo();
        ifai.hostId = agentComputerID;
        ifai.request_type = 4;
        ifai.agentData = readLogRequest;
        request.requestData = ifai;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "readInbandAgentLog");
        }
    }

    public static void agentReadJobLog(Request request, int agentComputerID, ReadLogRequest readLogRequest) {
        String methodName = "agentReadJobLog";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentReadJobLog", "request, agentComputerID, readLogRequest");
        }
        ServerRequest.serverRequest(request);
        request.flags = (byte)4;
        if (agentComputerID < 0) {
            request.subType = "org.eclipse.aperi.server.handler.server.ReadJobLogHndlr";
            request.requestData = readLogRequest;
        } else {
            request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
            GuiToAgentReq g2aReq = new GuiToAgentReq();
            g2aReq.computerID = agentComputerID;
            g2aReq.requestHandler = "org.eclipse.aperi.agent.handler.log.JobLogFileHandler";
            g2aReq.agentData = readLogRequest;
            request.requestData = g2aReq;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentReadJobLog");
        }
    }

    public static void readServiceLog(Request request, ReadLogRequest readLogRequest) {
        String methodName = "readServiceLog";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "readServiceLog", "request, readLogRequest");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiHndlr";
        request.flags = (byte)5;
        GuiInfoReq giReq = new GuiInfoReq();
        giReq.dataRequested = GuiInfoReq.READ_LOG;
        giReq.rlRequest = readLogRequest;
        request.requestData = giReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "readServiceLog");
        }
    }

    public static void uninstallAgent(Request request, int agentComputerID, byte productCode) {
        String methodName = "uninstallAgent";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "uninstallAgent", "request, agentComputerID, productCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.UninstallAgentHndlr";
        request.flags = (byte)5;
        UninstallAgentReq uaReq = new UninstallAgentReq();
        uaReq.computerID = agentComputerID;
        uaReq.productCode = productCode;
        request.requestData = uaReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "uninstallAgent");
        }
    }

    public static void agentGetTracingConfig(Request request, int agentComputerID, String reqCode) {
        String methodName = "agentGetTracingConfig";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentGetTracingConfig", "request, agentComputerID, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        GuiToAgentReq g2aReq = new GuiToAgentReq();
        g2aReq.computerID = agentComputerID;
        g2aReq.requestHandler = "org.eclipse.aperi.agent.handler.log.config.AgentLogConfigHandler";
        g2aReq.agentData = new LogConfigRequest(false, null, reqCode);
        request.requestData = g2aReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentGetTracingConfig");
        }
    }

    public static void agentSetTracingConfig(Request request, int agentComputerID, HashMap tracingConfigMap, String reqCode) {
        String methodName = "agentSetTracingConfig";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentSetTracingConfig", "request, agentComputerID, tracingConfigMap, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiToAgentHndlr";
        GuiToAgentReq g2aReq = new GuiToAgentReq();
        g2aReq.computerID = agentComputerID;
        g2aReq.requestHandler = "org.eclipse.aperi.agent.handler.log.config.AgentLogConfigHandler";
        g2aReq.agentData = new LogConfigRequest(true, tracingConfigMap, reqCode);
        request.requestData = g2aReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentSetTracingConfig");
        }
    }

    public static void serverGetTracingConfig(Request request, String reqCode) {
        String methodName = "serverGetTracingConfig";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverGetTracingConfig", "request, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ServerLogConfigHandler";
        request.requestData = new LogConfigRequest(false, null, reqCode);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverGetTracingConfig");
        }
    }

    public static void serverSetTracingConfig(Request request, HashMap tracingConfigMap, String reqCode) {
        String methodName = "serverSetTracingConfig";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverSetTracingConfig", "request, tracingConfigMap, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ServerLogConfigHandler";
        request.requestData = new LogConfigRequest(true, tracingConfigMap, reqCode);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverSetTracingConfig");
        }
    }

    public static void serverGetAuditConfig(Request request, String reqCode) {
        String methodName = "serverGetAuditConfig";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverGetAuditConfig", "request, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ServerAuditConfigHandler";
        request.requestData = new AuditConfigRequest(false, null, reqCode);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverGetAuditConfig");
        }
    }

    public static void serverSetAuditConfig(Request request, HashMap tracingConfigMap, String reqCode) {
        String methodName = "serverSetAuditConfig";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "serverSetAuditConfig", "request, tracingConfigMap, reqCode");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ServerAuditConfigHandler";
        request.requestData = new AuditConfigRequest(true, tracingConfigMap, reqCode);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "serverSetAuditConfig");
        }
    }

    public static void agentCommand(Request request, Request agentRequest, int[] agentComputerIDs) {
        String methodName = "agentCommand";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "agentCommand", "request, agentRequest, agentComputerIDs");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.AgentCommandHndlr";
        request.flags = (byte)4;
        AgentCommandReq acrReq = new AgentCommandReq();
        acrReq.acrRequest = agentRequest;
        acrReq.acrAgentIDs = agentComputerIDs;
        request.requestData = acrReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "agentCommand");
        }
    }

    public static void updateGroup2Roles(Request request, byte flags, RoleData[] roleData) {
        String methodName = "updateGroup2Roles";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "updateGroup2Roles", "request, groupData");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.RolesUpdateHndlr";
        request.flags = (byte)4;
        RolesUpdateReq updateData = new RolesUpdateReq();
        updateData.flags = flags;
        updateData.roleData = roleData;
        request.requestData = updateData;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "updateGroup2Roles");
        }
    }

    public static void deviceReadJobLog(Request request, int agentComputerID, ReadLogRequest readLogRequest) {
        String methodName = "deviceReadJobLog";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, "deviceReadJobLog", "request, agentComputerID, readLogRequest");
        }
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.ReadDeviceLogHndlr";
        request.flags = (byte)4;
        GuiToAgentReq g2aReq = new GuiToAgentReq();
        g2aReq.computerID = agentComputerID;
        g2aReq.requestHandler = "org.eclipse.aperi.agent.handler.log.JobLogFileHandler";
        g2aReq.agentData = readLogRequest;
        request.requestData = g2aReq;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, "deviceReadJobLog");
        }
    }
}

